//autogenerated:yes
//nolint:revive,misspell,govet,lll
package storm32

// Radio link statistics for a MAVLink RC receiver or transmitter and other links. Tx: ground-side device, Rx: vehicle-side device.
// The message is normally emitted in regular time intervals upon each actual or expected reception of an over-the-air data packet on the link.
// A MAVLink RC receiver should emit it shortly after it emits a RADIO_RC_CHANNELS message (if it is emitting that message).
// Per default, rssi values are in MAVLink units: 0 represents weakest signal, 254 represents maximum signal, UINT8_MAX represents unknown.
// The RADIO_LINK_STATS_FLAGS_RSSI_DBM flag is set if the rssi units are negative dBm: 1..254 correspond to -1..-254 dBm, 0 represents no reception, UINT8_MAX represents unknown.
// The target_system field should normally be set to the system id of the system the link is connected to, typically the flight controller.
// The target_component field can normally be set to 0, so that all components of the system can receive the message.
// Note: The frequency fields are extensions to ensure that they are located at the end of the serialized payload and subject to MAVLink's trailing-zero trimming.
type MessageMlrsRadioLinkStats struct {
	// System ID (ID of target system, normally flight controller).
	TargetSystem uint8
	// Component ID (normally 0 for broadcast).
	TargetComponent uint8
	// Radio link statistics flags.
	Flags MLRS_RADIO_LINK_STATS_FLAGS `mavenum:"uint16"`
	// Link quality of RC data stream from Tx to Rx. Values: 1..100, 0: no link connection, UINT8_MAX: unknown.
	RxLqRc uint8 `mavname:"rx_LQ_rc"`
	// Link quality of serial MAVLink data stream from Tx to Rx. Values: 1..100, 0: no link connection, UINT8_MAX: unknown.
	RxLqSer uint8 `mavname:"rx_LQ_ser"`
	// Rssi of antenna 1. 0: no reception, UINT8_MAX: unknown.
	RxRssi1 uint8
	// Noise on antenna 1. Radio link dependent. INT8_MAX: unknown.
	RxSnr1 int8
	// Link quality of serial MAVLink data stream from Rx to Tx. Values: 1..100, 0: no link connection, UINT8_MAX: unknown.
	TxLqSer uint8 `mavname:"tx_LQ_ser"`
	// Rssi of antenna 1. 0: no reception. UINT8_MAX: unknown.
	TxRssi1 uint8
	// Noise on antenna 1. Radio link dependent. INT8_MAX: unknown.
	TxSnr1 int8
	// Rssi of antenna 2. 0: no reception, UINT8_MAX: use rx_rssi1 if it is known else unknown.
	RxRssi2 uint8
	// Noise on antenna 2. Radio link dependent. INT8_MAX: use rx_snr1 if it is known else unknown.
	RxSnr2 int8
	// Rssi of antenna 2. 0: no reception. UINT8_MAX: use tx_rssi1 if it is known else unknown.
	TxRssi2 uint8
	// Noise on antenna 2. Radio link dependent. INT8_MAX: use tx_snr1 if it is known else unknown.
	TxSnr2 int8
	// Frequency on antenna1 in Hz. 0: unknown.
	Frequency1 float32 `mavext:"true"`
	// Frequency on antenna2 in Hz. 0: unknown.
	Frequency2 float32 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageMlrsRadioLinkStats) GetID() uint32 {
	return 60045
}
