//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package storm32

import (
	"fmt"
	"strconv"
)

// RADIO_LINK_TYPE enum.
type MLRS_RADIO_LINK_TYPE uint64

const (
	// Unknown radio link type.
	MLRS_RADIO_LINK_TYPE_GENERIC MLRS_RADIO_LINK_TYPE = 0
	// Radio link is HereLink.
	MLRS_RADIO_LINK_TYPE_HERELINK MLRS_RADIO_LINK_TYPE = 1
	// Radio link is Dragon Link.
	MLRS_RADIO_LINK_TYPE_DRAGONLINK MLRS_RADIO_LINK_TYPE = 2
	// Radio link is RFD900.
	MLRS_RADIO_LINK_TYPE_RFD900 MLRS_RADIO_LINK_TYPE = 3
	// Radio link is Crossfire.
	MLRS_RADIO_LINK_TYPE_CROSSFIRE MLRS_RADIO_LINK_TYPE = 4
	// Radio link is ExpressLRS.
	MLRS_RADIO_LINK_TYPE_EXPRESSLRS MLRS_RADIO_LINK_TYPE = 5
	// Radio link is mLRS.
	MLRS_RADIO_LINK_TYPE_MLRS MLRS_RADIO_LINK_TYPE = 6
)

var value_to_label_MLRS_RADIO_LINK_TYPE = map[MLRS_RADIO_LINK_TYPE]string{
	MLRS_RADIO_LINK_TYPE_GENERIC:    "MLRS_RADIO_LINK_TYPE_GENERIC",
	MLRS_RADIO_LINK_TYPE_HERELINK:   "MLRS_RADIO_LINK_TYPE_HERELINK",
	MLRS_RADIO_LINK_TYPE_DRAGONLINK: "MLRS_RADIO_LINK_TYPE_DRAGONLINK",
	MLRS_RADIO_LINK_TYPE_RFD900:     "MLRS_RADIO_LINK_TYPE_RFD900",
	MLRS_RADIO_LINK_TYPE_CROSSFIRE:  "MLRS_RADIO_LINK_TYPE_CROSSFIRE",
	MLRS_RADIO_LINK_TYPE_EXPRESSLRS: "MLRS_RADIO_LINK_TYPE_EXPRESSLRS",
	MLRS_RADIO_LINK_TYPE_MLRS:       "MLRS_RADIO_LINK_TYPE_MLRS",
}

var label_to_value_MLRS_RADIO_LINK_TYPE = map[string]MLRS_RADIO_LINK_TYPE{
	"MLRS_RADIO_LINK_TYPE_GENERIC":    MLRS_RADIO_LINK_TYPE_GENERIC,
	"MLRS_RADIO_LINK_TYPE_HERELINK":   MLRS_RADIO_LINK_TYPE_HERELINK,
	"MLRS_RADIO_LINK_TYPE_DRAGONLINK": MLRS_RADIO_LINK_TYPE_DRAGONLINK,
	"MLRS_RADIO_LINK_TYPE_RFD900":     MLRS_RADIO_LINK_TYPE_RFD900,
	"MLRS_RADIO_LINK_TYPE_CROSSFIRE":  MLRS_RADIO_LINK_TYPE_CROSSFIRE,
	"MLRS_RADIO_LINK_TYPE_EXPRESSLRS": MLRS_RADIO_LINK_TYPE_EXPRESSLRS,
	"MLRS_RADIO_LINK_TYPE_MLRS":       MLRS_RADIO_LINK_TYPE_MLRS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MLRS_RADIO_LINK_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MLRS_RADIO_LINK_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MLRS_RADIO_LINK_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MLRS_RADIO_LINK_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MLRS_RADIO_LINK_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MLRS_RADIO_LINK_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
