/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.smali;

import java.util.regex.Pattern;

public abstract class LiteralTools {
    public static final Pattern specialFloatRegex = Pattern.compile("((-)?infinityf)|(nanf)", 2);
    public static final Pattern specialDoubleRegex = Pattern.compile("((-)?infinityd?)|(nand?)", 2);

    public static byte parseByte(String charSequence) {
        if (charSequence != null) {
            if (((String)charSequence).length() != 0) {
                char c;
                int n;
                char[] cArray;
                if (((String)charSequence).toUpperCase().endsWith("T")) {
                    String string = charSequence;
                    cArray = string.substring(0, string.length() - 1).toCharArray();
                } else {
                    cArray = ((String)charSequence).toCharArray();
                }
                int n2 = 0;
                int n3 = 10;
                boolean bl = false;
                if (cArray[0] == '-') {
                    n2 = 1;
                    bl = true;
                }
                if (cArray[n2] == '0') {
                    n = n2 + 1;
                    if (n == cArray.length) {
                        return 0;
                    }
                    c = cArray[n];
                    if (c != 'x' && c != 'X') {
                        if (Character.digit(c, 8) >= 0) {
                            n3 = 8;
                            n2 = n;
                        } else {
                            n2 = n;
                        }
                    } else {
                        n3 = 16;
                        n2 += 2;
                    }
                }
                n = 0;
                c = (char)(127 / (n3 / 2));
                while (n2 < cArray.length) {
                    StringBuilder stringBuilder;
                    int n4 = Character.digit(cArray[n2], n3);
                    if (n4 >= 0) {
                        int n5 = n;
                        n = (byte)(n * n3);
                        if (n5 <= c) {
                            if (n < 0 && n >= -n4) {
                                throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a byte"));
                            }
                            n = (byte)(n + n4);
                            ++n2;
                            continue;
                        }
                        throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a byte"));
                    }
                    charSequence = stringBuilder;
                    ((StringBuilder)charSequence)("The string contains invalid an digit - '");
                    throw new NumberFormatException(stringBuilder.append(cArray[n2]).append("'").toString());
                }
                if (bl) {
                    if (n == -128) {
                        return (byte)n;
                    }
                    if (n >= 0) {
                        return (byte)(n * -1);
                    }
                    throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a byte"));
                }
                return (byte)n;
            }
            throw new NumberFormatException("string is blank");
        }
        throw new NumberFormatException("string is null");
    }

    public static short parseShort(String charSequence) {
        if (charSequence != null) {
            if (((String)charSequence).length() != 0) {
                int n;
                char[] cArray;
                if (((String)charSequence).toUpperCase().endsWith("S")) {
                    CharSequence charSequence2 = charSequence;
                    cArray = ((String)charSequence2).substring(0, ((String)charSequence2).length() - 1).toCharArray();
                } else {
                    cArray = ((String)charSequence).toCharArray();
                }
                int n2 = 0;
                int n3 = 10;
                boolean bl = false;
                if (cArray[0] == '-') {
                    n2 = 1;
                    bl = true;
                }
                if (cArray[n2] == '0') {
                    n = n2 + 1;
                    if (n == cArray.length) {
                        return 0;
                    }
                    char c = cArray[n];
                    if (c != 'x' && c != 'X') {
                        if (Character.digit(c, 8) >= 0) {
                            n3 = 8;
                            n2 = n;
                        } else {
                            n2 = n;
                        }
                    } else {
                        n3 = 16;
                        n2 += 2;
                    }
                }
                n = 0;
                short s = (short)(Short.MAX_VALUE / (n3 / 2));
                while (n2 < cArray.length) {
                    StringBuilder stringBuilder;
                    int n4 = Character.digit(cArray[n2], n3);
                    if (n4 >= 0) {
                        int n5 = n;
                        n = (short)(n * n3);
                        if (n5 <= s) {
                            if (n < 0 && n >= -n4) {
                                throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a short"));
                            }
                            n = (short)(n + n4);
                            ++n2;
                            continue;
                        }
                        throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a short"));
                    }
                    charSequence = stringBuilder;
                    ((StringBuilder)charSequence)("The string contains invalid an digit - '");
                    throw new NumberFormatException(stringBuilder.append(cArray[n2]).append("'").toString());
                }
                if (bl) {
                    if (n == Short.MIN_VALUE) {
                        return (short)n;
                    }
                    if (n >= 0) {
                        return (short)(n * -1);
                    }
                    throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a short"));
                }
                return (short)n;
            }
            throw new NumberFormatException("string is blank");
        }
        throw new NumberFormatException("string is null");
    }

    public static int parseInt(String charSequence) {
        if (charSequence != null) {
            if (((String)charSequence).length() != 0) {
                char c;
                int n;
                char[] cArray = ((String)charSequence).toCharArray();
                int n2 = 0;
                int n3 = 10;
                boolean bl = false;
                if (cArray[0] == '-') {
                    n2 = 1;
                    bl = true;
                }
                if (cArray[n2] == '0') {
                    n = n2 + 1;
                    if (n == cArray.length) {
                        return 0;
                    }
                    c = cArray[n];
                    if (c != 'x' && c != 'X') {
                        if (Character.digit(c, 8) >= 0) {
                            n3 = 8;
                            n2 = n;
                        } else {
                            n2 = n;
                        }
                    } else {
                        n3 = 16;
                        n2 += 2;
                    }
                }
                n = 0;
                c = Integer.MAX_VALUE / (n3 / 2);
                while (n2 < cArray.length) {
                    StringBuilder stringBuilder;
                    int n4 = Character.digit(cArray[n2], n3);
                    if (n4 >= 0) {
                        int n5 = n;
                        n = n5 * n3;
                        if (n5 <= c) {
                            if (n < 0 && n >= -n4) {
                                throw new NumberFormatException(((String)charSequence).concat(" cannot fit into an int"));
                            }
                            n += n4;
                            ++n2;
                            continue;
                        }
                        throw new NumberFormatException(((String)charSequence).concat(" cannot fit into an int"));
                    }
                    charSequence = stringBuilder;
                    ((StringBuilder)charSequence)("The string contains an invalid digit - '");
                    throw new NumberFormatException(stringBuilder.append(cArray[n2]).append("'").toString());
                }
                if (bl) {
                    if (n == Integer.MIN_VALUE) {
                        return n;
                    }
                    if (n >= 0) {
                        return n * -1;
                    }
                    throw new NumberFormatException(((String)charSequence).concat(" cannot fit into an int"));
                }
                return n;
            }
            throw new NumberFormatException("string is blank");
        }
        throw new NumberFormatException("string is null");
    }

    public static long parseLong(String charSequence) {
        if (charSequence != null) {
            if (((String)charSequence).length() != 0) {
                char[] cArray;
                if (((String)charSequence).toUpperCase().endsWith("L")) {
                    String string = charSequence;
                    cArray = string.substring(0, string.length() - 1).toCharArray();
                } else {
                    cArray = ((String)charSequence).toCharArray();
                }
                int n = 0;
                int n2 = 10;
                boolean bl = false;
                if (cArray[0] == '-') {
                    n = 1;
                    bl = true;
                }
                if (cArray[n] == '0') {
                    int n3 = n + 1;
                    if (n3 == cArray.length) {
                        return 0L;
                    }
                    char c = cArray[n3];
                    if (c != 'x' && c != 'X') {
                        if (Character.digit(c, 8) >= 0) {
                            n2 = 8;
                            n = n3;
                        } else {
                            n = n3;
                        }
                    } else {
                        n2 = 16;
                        n += 2;
                    }
                }
                long l = 0L;
                long l2 = n2 / 2;
                l2 = Long.MAX_VALUE / l2;
                while (n < cArray.length) {
                    StringBuilder stringBuilder;
                    int n4 = Character.digit(cArray[n], n2);
                    if (n4 >= 0) {
                        long l3 = l;
                        l *= (long)n2;
                        if (l3 <= l2) {
                            if (l < 0L && l >= (long)(-n4)) {
                                throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a long"));
                            }
                            l += (long)n4;
                            ++n;
                            continue;
                        }
                        throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a long"));
                    }
                    charSequence = stringBuilder;
                    ((StringBuilder)charSequence)("The string contains an invalid digit - '");
                    throw new NumberFormatException(stringBuilder.append(cArray[n]).append("'").toString());
                }
                if (bl) {
                    if (l == Long.MIN_VALUE) {
                        return l;
                    }
                    if (l >= 0L) {
                        return l * -1L;
                    }
                    throw new NumberFormatException(((String)charSequence).concat(" cannot fit into a long"));
                }
                return l;
            }
            throw new NumberFormatException("string is blank");
        }
        throw new NumberFormatException("string is null");
    }

    public static void checkShort(long l) {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = l > 65535L;
        if (!(bl2 | (bl = l < -32768L))) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        throw new NumberFormatException(stringBuilder.append(Long.toString(l)).append(" cannot fit into a short").toString());
    }

    public static void checkByte(long l) {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = l > 255L;
        if (!(bl2 | (bl = l < -128L))) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        throw new NumberFormatException(stringBuilder.append(Long.toString(l)).append(" cannot fit into a byte").toString());
    }

    public static void checkNibble(long l) {
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = l > 15L;
        if (!(bl2 | (bl = l < -8L))) {
            return;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        throw new NumberFormatException(stringBuilder.append(Long.toString(l)).append(" cannot fit into a nibble").toString());
    }
}

