/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.JaveleonModule;
import org.netbeans.LocaleVariants;
import org.netbeans.Module;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.StandardModuleData;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class StandardModule
extends Module {
    private final File jar;
    private File physicalJar;
    private Manifest manifest;
    private static final Set<File> moduleJARs = new HashSet<File>();
    private Set<File> patches;
    private Properties localizedProps;
    private static PermissionCollection modulePermissions;
    private static final Logger CL_LOG;

    public StandardModule(ModuleManager moduleManager, Events events, File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(moduleManager, events, object, JaveleonModule.isJaveleonPresent || bl, bl2, bl3);
        this.jar = file;
        moduleJARs.add(file);
    }

    @Override
    ModuleData createData(ObjectInput objectInput, Manifest manifest) throws IOException {
        if (objectInput != null) {
            return new StandardModuleData(objectInput);
        }
        return new StandardModuleData(manifest, this);
    }

    @Override
    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.loadManifest();
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, "While loading manifest for " + this.getJarFile(), iOException);
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    @Override
    public void releaseManifest() {
        this.manifest = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String string) {
        int n;
        String string2;
        Object object;
        String string3 = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean bl = false;
        if (string3 != null) {
            Object object2;
            if (this.classloader != null) {
                if (string3.endsWith(".properties")) {
                    bl = true;
                    object2 = string3.substring(0, string3.length() - 11).replace('/', '.');
                    try {
                        object = NbBundle.getBundle((String)object2, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return ((ResourceBundle)object).getString(string);
                        }
                        catch (MissingResourceException missingResourceException) {
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = ((String)object2).replace('.', '/') + ".properties";
                        Exceptions.attachMessage((Throwable)missingResourceException, (String)("#149833: failed to find " + (String)object2 + " in locale " + Locale.getDefault() + " in " + this.classloader + " for " + this.jar + "; resource lookup of " + string2 + " -> " + this.classloader.getResource(string2)));
                        Exceptions.printStackTrace((Throwable)missingResourceException);
                    }
                } else {
                    Util.err.warning("cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + string3);
                }
            }
            if (!bl) {
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log(Level.FINE, "Trying to get localized attr {0} from disabled module {1}", new Object[]{string, this.getCodeNameBase()});
                        try {
                            if (this.jar != null && this.jar.isFile()) {
                                object2 = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps((JarFile)object2, this.getManifest());
                                    break block19;
                                }
                                finally {
                                    ((ZipFile)object2).close();
                                }
                            }
                            Util.err.log(Level.FINE, "Cannot get localized attr {0} from module {1} (missing or deleted JAR file: {2})", new Object[]{string, this.getCodeNameBase(), this.jar});
                        }
                        catch (IOException iOException) {
                            Util.err.log(Level.WARNING, this.jar.getAbsolutePath(), iOException);
                        }
                    }
                }
                if (this.localizedProps != null && (object2 = this.localizedProps.getProperty(string)) != null) {
                    return object2;
                }
            }
        }
        if ((n = string.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(string));
        }
        object = string.substring(0, n);
        string2 = string.substring(n + 1);
        Attributes attributes = this.getManifest().getAttributes((String)object);
        if (attributes != null) {
            return NbBundle.getLocalizedValue((Attributes)attributes, (Attributes.Name)new Attributes.Name(string2));
        }
        return null;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.warning("temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.fine("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.fine("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block9: {
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.fine("loading manifest of " + this.jar);
            }
            File file = null;
            try {
                if (this.reloadable) {
                    file = this.physicalJar;
                    this.ensurePhysicalJar();
                    file = this.physicalJar;
                    try (JarFile jarFile = new JarFile(this.physicalJar, false);){
                        Manifest manifest = jarFile.getManifest();
                        if (manifest == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = manifest;
                        break block9;
                    }
                }
                file = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException iOException) {
                if (file != null) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("While loading manifest from: " + file));
                }
                throw iOException;
            }
        }
    }

    private Set<File> findPatches() {
        if (this.patches == null) {
            Object object;
            File file = new File(new File(this.jar.getParentFile(), "patches"), this.getCodeNameBase().replace('.', '-'));
            if (file.isDirectory()) {
                object = file.listFiles(Util.jarFilter());
                if (object != null) {
                    for (File file2 : object) {
                        if (this.patches == null) {
                            this.patches = new HashSet<File>(5);
                        }
                        this.patches.add(file2);
                    }
                } else {
                    Util.err.warning("Could not search for patches in " + file);
                }
            }
            if ((object = System.getProperty("netbeans.patches." + this.getCodeNameBase())) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    File file3 = new File(string);
                    if (!file3.exists()) continue;
                    if (this.patches == null) {
                        this.patches = new HashSet<File>(15);
                    }
                    this.patches.add(file3);
                }
            }
            if (Util.err.isLoggable(Level.FINE)) {
                Util.err.log(Level.FINE, "patches of {0}: {1}", new Object[]{this.jar, this.patches});
            }
            if (this.patches != null) {
                for (File file4 : this.patches) {
                    this.events.log("patch", file4);
                }
            }
            if (this.patches == null) {
                this.patches = Collections.emptySet();
            }
        }
        return this.patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest manifest) throws IOException {
        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (string != null) {
            String string2;
            int n;
            Object object;
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry != null) {
                this.localizedProps = new Properties();
                object = jarFile.getInputStream(zipEntry);
                try {
                    this.localizedProps.load((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            if ((n = string.lastIndexOf(46)) == -1) {
                object = string;
                string2 = "";
            } else {
                object = string.substring(0, n);
                string2 = string.substring(n);
            }
            List<LocaleVariants.FileWithSuffix> list = LocaleVariants.findLocaleVariantsWithSuffixesOf(this.jar, this.getCodeNameBase());
            Collections.reverse(list);
            for (LocaleVariants.FileWithSuffix fileWithSuffix : list) {
                File file = fileWithSuffix.file;
                String string3 = fileWithSuffix.suffix;
                String string4 = (String)object + string3 + string2;
                try (JarFile jarFile2 = new JarFile(file, false);){
                    ZipEntry zipEntry2 = jarFile2.getEntry(string4);
                    if (zipEntry2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    try (InputStream inputStream = jarFile2.getInputStream(zipEntry2);){
                        this.localizedProps.load(inputStream);
                    }
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + string);
            }
        }
    }

    @Override
    public List<File> getAllJars() {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<File> set = this.findPatches();
        if (set != null) {
            arrayList.addAll(set);
        }
        if (this.physicalJar != null) {
            arrayList.add(this.physicalJar);
        } else if (this.jar != null) {
            arrayList.add(this.jar);
        }
        ((StandardModuleData)this.data()).addCp(arrayList);
        return arrayList;
    }

    @Override
    public void setReloadable(boolean bl) {
        this.getManager().assertWritable();
        if (this.reloadable != bl) {
            this.reloadable = bl;
            this.getManager().fireReloadable(this);
        }
    }

    @Override
    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String string = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.parseManifest();
        String string2 = this.getCodeNameBase();
        if (!string.equals(string2)) {
            throw new InvalidException("Code name base changed during reload: " + string + " -> " + string2);
        }
    }

    @Override
    protected void classLoaderUp(Set<Module> set) throws IOException {
        Object object;
        Object object22;
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("classLoaderUp on " + (Object)((Object)this) + " with parents " + set);
        }
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(set.size() + 1);
        arrayList.add(Module.class.getClassLoader());
        for (Object object22 : set) {
            object = object22.getPublicPackages();
            if (object != null && ((Module.PackageExport[])object).length == 0) {
                boolean bl = false;
                for (Dependency dependency : this.getDependenciesArray()) {
                    if (dependency.getType() != 1 || dependency.getComparison() != 2 || !dependency.getName().equals(object22.getCodeName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            ClassLoader classLoader = this.getParentLoader((Module)((Object)object22));
            if (object22.isFixed() && arrayList.contains(classLoader)) {
                Util.err.log(Level.FINE, "#24996: skipping duplicate classloader from {0}", object22);
                continue;
            }
            arrayList.add(classLoader);
        }
        ArrayList arrayList2 = new ArrayList(3);
        object22 = this.findPatches();
        if (object22 != null) {
            arrayList2.addAll(object22);
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            arrayList2.add(this.physicalJar);
        } else {
            arrayList2.add(this.jar);
        }
        ((StandardModuleData)this.data()).addCp(arrayList2);
        this.getManager().refineModulePath(this, arrayList2);
        object = this.getManager().refineClassLoader(this, arrayList);
        if (object != null) {
            this.classloader = object;
        } else {
            try {
                this.classloader = this.createNewClassLoader(arrayList2, arrayList);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new IOException(illegalArgumentException.toString()).initCause(illegalArgumentException);
            }
        }
    }

    protected ClassLoader createNewClassLoader(List<File> list, List<ClassLoader> list2) {
        return new OneModuleClassLoader(list, list2.toArray(new ClassLoader[0]));
    }

    protected ClassLoader getParentLoader(Module module) {
        return module.getClassLoader();
    }

    @Override
    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
    }

    @Override
    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        this.destroyPhysicalJar();
    }

    @Override
    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    @Override
    public String toString() {
        String string = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            string = string + "[invalid]";
        }
        return string;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    static boolean isModuleJar(File file) {
        return moduleJARs.contains(file);
    }

    static {
        CL_LOG = Logger.getLogger(OneModuleClassLoader.class.getName());
    }

    class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider {
        public OneModuleClassLoader(List<File> list, ClassLoader[] classLoaderArray) throws IllegalArgumentException {
            super(list, classLoaderArray, false, StandardModule.this);
            JaveleonModule.registerClassLoader(this, StandardModule.this.getCodeNameBase());
        }

        @Override
        public Module getModule() {
            return StandardModule.this;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return StandardModule.getAllPermission();
        }

        @Override
        protected String findLibrary(String string) {
            InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
            String string2 = System.getProperty("os.arch");
            String string3 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            String string4 = System.mapLibraryName(string);
            File file = installedFileLocator.locate("modules/lib/" + string4, StandardModule.this.getCodeNameBase(), false);
            if (file != null) {
                CL_LOG.log(Level.FINE, "found {0}", file);
                return file.getAbsolutePath();
            }
            file = installedFileLocator.locate("modules/lib/" + string2 + "/" + string4, StandardModule.this.getCodeNameBase(), false);
            if (file != null) {
                CL_LOG.log(Level.FINE, "found {0}", file);
                return file.getAbsolutePath();
            }
            file = installedFileLocator.locate("modules/lib/" + string2 + "/" + string3 + "/" + string4, StandardModule.this.getCodeNameBase(), false);
            if (file != null) {
                CL_LOG.log(Level.FINE, "found {0}", file);
                return file.getAbsolutePath();
            }
            if (BaseUtilities.isMac()) {
                String string5 = string4.replaceFirst("\\.dylib$", ".jnilib");
                file = installedFileLocator.locate("modules/lib/" + string5, StandardModule.this.getCodeNameBase(), false);
                if (file != null) {
                    CL_LOG.log(Level.FINE, "found {0}", file);
                    return file.getAbsolutePath();
                }
                file = installedFileLocator.locate("modules/lib/" + string2 + "/" + string5, StandardModule.this.getCodeNameBase(), false);
                if (file != null) {
                    CL_LOG.log(Level.FINE, "found {0}", file);
                    return file.getAbsolutePath();
                }
                file = installedFileLocator.locate("modules/lib/" + string2 + "/" + string3 + "/" + string5, StandardModule.this.getCodeNameBase(), false);
                if (file != null) {
                    CL_LOG.log(Level.FINE, "found {0}", file);
                    return file.getAbsolutePath();
                }
                CL_LOG.log(Level.FINE, "found nothing like modules/lib/{0}/{1}/{2}", new Object[]{string2, string3, string5});
            }
            CL_LOG.log(Level.FINE, "found nothing like modules/lib/{0}/{1}/{2}", new Object[]{string2, string3, string4});
            return null;
        }

        @Override
        protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
            if (!super.shouldDelegateResource(string, classLoader)) {
                return false;
            }
            Module module = classLoader instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)classLoader)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, module, string, classLoader);
        }

        public String toString() {
            return "ModuleCL@" + Integer.toHexString(System.identityHashCode(this)) + "[" + StandardModule.this.getCodeNameBase() + "]";
        }
    }
}

