'\"
'\" Generated from file 'img-flir\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2024 Jan Nijtmans <nijtmans@users\&.sourceforge\&.net>
'\" Copyright (c) 2002-2024 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\" Copyright (c) 2003-2024 Paul Obermeier <obermeier@users\&.sourceforge\&.net>
'\"
.TH "img-flir" n 2\&.0 img-flir "Img"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
img-flir \- FLIR FPF Public Image format (flir)
.SH SYNOPSIS
package require \fBimg::flir ?2\&.0?\fR
.sp
.BE
.SH DESCRIPTION
\fBpackage require img::flir\fR
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR, so
that it supports files containing raster images in the
FLIR FPF Public Image format (flir)\&. More specifically
\fBimg::flir\fR extends \fBTk\fR's
\fIphoto\fR [https://www\&.tcl\&.tk/man/tcl9\&.0/TkCmd/photo\&.html] image type\&.
.PP
The name of the new format handler is \fBflir\fR\&.
This handler provides new additional configuration options\&. See
section \fBOptions\fR for more detailed explanations\&.
.PP
All of the above means that in a call like
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?
.PP
.IP [1]
Image data in flir format (options \fB-data\fR and \fB-file\fR) is
detected automatically\&.
.IP [2]
The format name \fBflir\fR is recognized by the option \fB-format\fR\&.
.PP
In addition the value of option \fB-format\fR is treated as a list and may
contain any of the special options listed in section \fBOptions\fR\&.
.PP
The package \fBimg::flir\fR is \fInot\fR loaded when doing a
\fBpackage require Img\fR, but must be loaded explicitly via
\fBpackage require img::flir\fR\&.
.PP
.SH NOTES
.IP [1]
This format handler interprets FLIR temperature files as grayscale images\&.
.IP [2]
Temperature values specified as short, int, float and double are supported\&.
.IP [3]
This format handler only supports read functionality\&.
.PP
.SH OPTIONS
The handler provides the following options:
.TP
\fB-verbose\fR \fIbool\fR
Available since version 1\&.4\&.9\&.
.sp
If set to \fBtrue\fR, additional information about the read data
is printed to stdout\&. Default is \fBfalse\fR\&.
.TP
\fB-map\fR \fIstring\fR
Available since version 1\&.4\&.9\&.
.sp
Specify the mode when mapping the 16, 32 or 64-bit temperature values
to 8-bit grayscale values for displaying\&.
Possible values: \fBnone\fR, \fBminmax\fR, \fBagc\fR\&.
Default mode is \fBminmax\fR\&.
.RS
.IP [1]
If mode is set to \fBnone\fR, no mapping of input
values is done\&. Use this mode, if the input
values are already in the range of 0 \&.\&.255\&.
When using mode \fBnone\fR, no information about the
minimum and maximum input values is gathered during
reading and therefore no verbose output is printed\&.
On the other hand reading the input data is faster\&.
.IP [2]
Mode \fBminmax\fR maps the minimum and maximum input data
to 256 grayscale values\&.
.IP [3]
Mode \fBagc\fR applies an automatic gain control algorithmn to the input values\&.
Currently implemented for 1-channel 32-bit float images only\&.
.RE
.TP
\fB-min\fR \fIdouble\fR
Available since version 1\&.4\&.9\&.
.sp
Specify the minimum pixel value to be used for mapping
the input data to 8-bit image values\&.
If not specified or negative, the minimum value found in the image data\&.
Valid for mapping mode: \fBminmax\fR\&.
.TP
\fB-max\fR \fIdouble\fR
Available since version 1\&.4\&.9\&.
.sp
Specify the maximum pixel value to be used for mapping
the input data to 8-bit image values\&.
If not specified or negative, the maximum value found in the image data\&.
Valid for mapping mode: \fBminmax\fR\&.
.TP
\fB-gamma\fR \fIdouble\fR
Available since version 1\&.4\&.9\&.
.sp
Specify a gamma correction to be applied when mapping
the input data to 8-bit image values\&.
Default is \fB1\&.0\fR\&.
Valid for mapping modes: \fBminmax\fR and \fBagc\fR\&.
.TP
\fB-saturation\fR \fIdouble\fR
Available since version 1\&.4\&.9\&.
.sp
The supplied value specifies the saturation value, i\&.e\&. all
input values greater than the saturation value are mapped to white\&.
If not specified or negative, do not use saturation\&.
Valid for mapping mode: \fBagc\fR\&.
.TP
\fB-cutoff\fR \fIdouble\fR
Available since version 1\&.4\&.9\&.
.sp
The supplied value specifies the cut-off value in percent\&.
The cut-off value specifies, how many pixels from the lower and upper part of
the histogram are not considered for mapping\&.
This option is useful, if there are some hot or cold spots in the image\&.
Default is \fB3\&.0\fR\&.
Valid for mapping mode: \fBagc\fR\&.
.PP
.SH "SEE ALSO"
img, img-bmp, img-dted, img-flir, img-gif, img-ico, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-raw, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH COPYRIGHT
.nf
Copyright (c) 1995-2024 Jan Nijtmans <nijtmans@users\&.sourceforge\&.net>
Copyright (c) 2002-2024 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
Copyright (c) 2003-2024 Paul Obermeier <obermeier@users\&.sourceforge\&.net>

.fi
