/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * equal(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => bvec3(true, false, false)
 * equal(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u)) => bvec3(false, false, false)
 * equal(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u)) => bvec3(true, false, false)
 * equal(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u)) => bvec3(false, false, false)
 * equal(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => bvec3(true, false, false)
 * equal(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u)) => bvec3(false, false, false)
 * equal(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u)) => bvec3(true, false, false)
 * equal(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u)) => bvec3(false, false, false)
 * equal(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u)) => bvec3(true, true, false)
 */
#version 130

void main()
{
  float[equal(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u))[0] == true && equal(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u))[1] == false && equal(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u))[2] == false ? 1 : -1] array0;
  float[equal(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u))[0] == false && equal(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u))[1] == false && equal(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u))[2] == false ? 1 : -1] array1;
  float[equal(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u))[0] == true && equal(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u))[1] == false && equal(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u))[2] == false ? 1 : -1] array2;
  float[equal(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u))[0] == false && equal(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u))[1] == false && equal(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u))[2] == false ? 1 : -1] array3;
  float[equal(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u))[0] == true && equal(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u))[1] == false && equal(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u))[2] == false ? 1 : -1] array4;
  float[equal(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u))[0] == false && equal(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u))[1] == false && equal(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u))[2] == false ? 1 : -1] array5;
  float[equal(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u))[0] == true && equal(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u))[1] == false && equal(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u))[2] == false ? 1 : -1] array6;
  float[equal(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u))[0] == false && equal(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u))[1] == false && equal(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u))[2] == false ? 1 : -1] array7;
  float[equal(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u))[0] == true && equal(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u))[1] == true && equal(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u))[2] == false ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
