/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class DraggablePlayPenComponent
extends PlayPenComponent {
    private static final Logger logger = Logger.getLogger(DraggablePlayPenComponent.class);

    protected DraggablePlayPenComponent(DraggablePlayPenComponent copyMe, PlayPenContentPane parent) {
        super(copyMe, parent);
    }

    public DraggablePlayPenComponent(String name) {
        super(name);
    }

    public DraggablePlayPenComponent(String name, PlayPenContentPane parent) {
        super(name, parent);
    }

    protected void setupDrag(Point p) {
        PlayPen pp = this.getPlayPen();
        Iterator<DraggablePlayPenComponent> it = pp.getSelectedDraggableComponents().iterator();
        logger.debug((Object)("event point: " + p));
        logger.debug((Object)("zoomed event point: " + pp.zoomPoint(new Point(p))));
        pp.setDraggingContainerPanes(true);
        this.startedDragging();
        HashMap<DraggablePlayPenComponent, Point> ppcToHandleMap = new HashMap<DraggablePlayPenComponent, Point>();
        while (it.hasNext()) {
            DraggablePlayPenComponent ppc = it.next();
            logger.debug((Object)("(" + ppc.getModel() + ") zoomed selected containerPane's point: " + ppc.getLocationOnScreen()));
            logger.debug((Object)("(" + ppc.getModel() + ") unzoomed selected containerPane's point: " + pp.unzoomPoint(ppc.getLocationOnScreen())));
            Point clickedItem = this.getLocationOnScreen();
            Point otherContainer = ppc.getLocationOnScreen();
            logger.debug((Object)("(" + ppc.getModel() + ") translation x=" + (otherContainer.getX() - clickedItem.getX()) + ",y=" + (otherContainer.getY() - clickedItem.getY())));
            Point handle = pp.zoomPoint(new Point(p));
            handle.translate((int)(clickedItem.getX() - otherContainer.getX()), (int)(clickedItem.getY() - otherContainer.getY()));
            ppcToHandleMap.put(ppc, handle);
        }
        new PlayPen.FloatingContainerPaneListener(pp, ppcToHandleMap);
    }
}

