/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Compositor_CumulativeStats")
public class CompositorCumulativeStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NPID;
    public static final int M_NNUMFRAMEPRESENTS;
    public static final int M_NNUMDROPPEDFRAMES;
    public static final int M_NNUMREPROJECTEDFRAMES;
    public static final int M_NNUMFRAMEPRESENTSONSTARTUP;
    public static final int M_NNUMDROPPEDFRAMESONSTARTUP;
    public static final int M_NNUMREPROJECTEDFRAMESONSTARTUP;
    public static final int M_NNUMLOADING;
    public static final int M_NNUMFRAMEPRESENTSLOADING;
    public static final int M_NNUMDROPPEDFRAMESLOADING;
    public static final int M_NNUMREPROJECTEDFRAMESLOADING;
    public static final int M_NNUMTIMEDOUT;
    public static final int M_NNUMFRAMEPRESENTSTIMEDOUT;
    public static final int M_NNUMDROPPEDFRAMESTIMEDOUT;
    public static final int M_NNUMREPROJECTEDFRAMESTIMEDOUT;

    public CompositorCumulativeStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CompositorCumulativeStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int m_nPid() {
        return CompositorCumulativeStats.nm_nPid(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresents() {
        return CompositorCumulativeStats.nm_nNumFramePresents(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFrames() {
        return CompositorCumulativeStats.nm_nNumDroppedFrames(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumReprojectedFrames() {
        return CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresentsOnStartup() {
        return CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFramesOnStartup() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumReprojectedFramesOnStartup() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumLoading() {
        return CompositorCumulativeStats.nm_nNumLoading(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresentsLoading() {
        return CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFramesLoading() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumReprojectedFramesLoading() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumTimedOut() {
        return CompositorCumulativeStats.nm_nNumTimedOut(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumFramePresentsTimedOut() {
        return CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumDroppedFramesTimedOut() {
        return CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nNumReprojectedFramesTimedOut() {
        return CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address());
    }

    public static CompositorCumulativeStats malloc() {
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CompositorCumulativeStats calloc() {
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CompositorCumulativeStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CompositorCumulativeStats create(long address) {
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)address);
    }

    @Nullable
    public static CompositorCumulativeStats createSafe(long address) {
        return address == 0L ? null : (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CompositorCumulativeStats.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CompositorCumulativeStats.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CompositorCumulativeStats mallocStack() {
        return CompositorCumulativeStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CompositorCumulativeStats callocStack() {
        return CompositorCumulativeStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CompositorCumulativeStats mallocStack(MemoryStack stack) {
        return CompositorCumulativeStats.malloc(stack);
    }

    @Deprecated
    public static CompositorCumulativeStats callocStack(MemoryStack stack) {
        return CompositorCumulativeStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CompositorCumulativeStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CompositorCumulativeStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CompositorCumulativeStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CompositorCumulativeStats.calloc(capacity, stack);
    }

    public static CompositorCumulativeStats malloc(MemoryStack stack) {
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CompositorCumulativeStats calloc(MemoryStack stack) {
        return (CompositorCumulativeStats)CompositorCumulativeStats.wrap(CompositorCumulativeStats.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CompositorCumulativeStats.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_nPid(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NPID);
    }

    public static int nm_nNumFramePresents(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMFRAMEPRESENTS);
    }

    public static int nm_nNumDroppedFrames(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMDROPPEDFRAMES);
    }

    public static int nm_nNumReprojectedFrames(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMREPROJECTEDFRAMES);
    }

    public static int nm_nNumFramePresentsOnStartup(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMFRAMEPRESENTSONSTARTUP);
    }

    public static int nm_nNumDroppedFramesOnStartup(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMDROPPEDFRAMESONSTARTUP);
    }

    public static int nm_nNumReprojectedFramesOnStartup(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMREPROJECTEDFRAMESONSTARTUP);
    }

    public static int nm_nNumLoading(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMLOADING);
    }

    public static int nm_nNumFramePresentsLoading(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMFRAMEPRESENTSLOADING);
    }

    public static int nm_nNumDroppedFramesLoading(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMDROPPEDFRAMESLOADING);
    }

    public static int nm_nNumReprojectedFramesLoading(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMREPROJECTEDFRAMESLOADING);
    }

    public static int nm_nNumTimedOut(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMTIMEDOUT);
    }

    public static int nm_nNumFramePresentsTimedOut(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMFRAMEPRESENTSTIMEDOUT);
    }

    public static int nm_nNumDroppedFramesTimedOut(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMDROPPEDFRAMESTIMEDOUT);
    }

    public static int nm_nNumReprojectedFramesTimedOut(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NNUMREPROJECTEDFRAMESTIMEDOUT);
    }

    static {
        Struct.Layout layout = CompositorCumulativeStats.__struct((Struct.Member[])new Struct.Member[]{CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4), CompositorCumulativeStats.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NPID = layout.offsetof(0);
        M_NNUMFRAMEPRESENTS = layout.offsetof(1);
        M_NNUMDROPPEDFRAMES = layout.offsetof(2);
        M_NNUMREPROJECTEDFRAMES = layout.offsetof(3);
        M_NNUMFRAMEPRESENTSONSTARTUP = layout.offsetof(4);
        M_NNUMDROPPEDFRAMESONSTARTUP = layout.offsetof(5);
        M_NNUMREPROJECTEDFRAMESONSTARTUP = layout.offsetof(6);
        M_NNUMLOADING = layout.offsetof(7);
        M_NNUMFRAMEPRESENTSLOADING = layout.offsetof(8);
        M_NNUMDROPPEDFRAMESLOADING = layout.offsetof(9);
        M_NNUMREPROJECTEDFRAMESLOADING = layout.offsetof(10);
        M_NNUMTIMEDOUT = layout.offsetof(11);
        M_NNUMFRAMEPRESENTSTIMEDOUT = layout.offsetof(12);
        M_NNUMDROPPEDFRAMESTIMEDOUT = layout.offsetof(13);
        M_NNUMREPROJECTEDFRAMESTIMEDOUT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<CompositorCumulativeStats, Buffer>
    implements NativeResource {
        private static final CompositorCumulativeStats ELEMENT_FACTORY = CompositorCumulativeStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CompositorCumulativeStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int m_nPid() {
            return CompositorCumulativeStats.nm_nPid(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresents() {
            return CompositorCumulativeStats.nm_nNumFramePresents(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFrames() {
            return CompositorCumulativeStats.nm_nNumDroppedFrames(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumReprojectedFrames() {
            return CompositorCumulativeStats.nm_nNumReprojectedFrames(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresentsOnStartup() {
            return CompositorCumulativeStats.nm_nNumFramePresentsOnStartup(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFramesOnStartup() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesOnStartup(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumReprojectedFramesOnStartup() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesOnStartup(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumLoading() {
            return CompositorCumulativeStats.nm_nNumLoading(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresentsLoading() {
            return CompositorCumulativeStats.nm_nNumFramePresentsLoading(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFramesLoading() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesLoading(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumReprojectedFramesLoading() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesLoading(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumTimedOut() {
            return CompositorCumulativeStats.nm_nNumTimedOut(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumFramePresentsTimedOut() {
            return CompositorCumulativeStats.nm_nNumFramePresentsTimedOut(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumDroppedFramesTimedOut() {
            return CompositorCumulativeStats.nm_nNumDroppedFramesTimedOut(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nNumReprojectedFramesTimedOut() {
            return CompositorCumulativeStats.nm_nNumReprojectedFramesTimedOut(this.address());
        }
    }
}

