/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VIEWCONFIGURATIONTYPE;
    public static final int FOVMUTABLE;

    public XrViewConfigurationProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewConfigurationProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewConfigurationProperties.nnext(this.address());
    }

    @NativeType(value="XrViewConfigurationType")
    public int viewConfigurationType() {
        return XrViewConfigurationProperties.nviewConfigurationType(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean fovMutable() {
        return XrViewConfigurationProperties.nfovMutable(this.address()) != 0;
    }

    public XrViewConfigurationProperties type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationProperties.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationProperties type$Default() {
        return this.type(45);
    }

    public XrViewConfigurationProperties next(@NativeType(value="void *") long value) {
        XrViewConfigurationProperties.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationProperties viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
        XrViewConfigurationProperties.nviewConfigurationType(this.address(), value);
        return this;
    }

    public XrViewConfigurationProperties fovMutable(@NativeType(value="XrBool32") boolean value) {
        XrViewConfigurationProperties.nfovMutable(this.address(), value ? 1 : 0);
        return this;
    }

    public XrViewConfigurationProperties set(int type, long next, int viewConfigurationType, boolean fovMutable) {
        this.type(type);
        this.next(next);
        this.viewConfigurationType(viewConfigurationType);
        this.fovMutable(fovMutable);
        return this;
    }

    public XrViewConfigurationProperties set(XrViewConfigurationProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewConfigurationProperties malloc() {
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrViewConfigurationProperties calloc() {
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrViewConfigurationProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrViewConfigurationProperties create(long address) {
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)address);
    }

    @Nullable
    public static XrViewConfigurationProperties createSafe(long address) {
        return address == 0L ? null : (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrViewConfigurationProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrViewConfigurationProperties malloc(MemoryStack stack) {
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViewConfigurationProperties calloc(MemoryStack stack) {
        return (XrViewConfigurationProperties)XrViewConfigurationProperties.wrap(XrViewConfigurationProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrViewConfigurationProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nviewConfigurationType(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWCONFIGURATIONTYPE);
    }

    public static int nfovMutable(long struct) {
        return UNSAFE.getInt(null, struct + (long)FOVMUTABLE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nviewConfigurationType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWCONFIGURATIONTYPE, value);
    }

    public static void nfovMutable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FOVMUTABLE, value);
    }

    static {
        Struct.Layout layout = XrViewConfigurationProperties.__struct((Struct.Member[])new Struct.Member[]{XrViewConfigurationProperties.__member((int)4), XrViewConfigurationProperties.__member((int)POINTER_SIZE), XrViewConfigurationProperties.__member((int)4), XrViewConfigurationProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VIEWCONFIGURATIONTYPE = layout.offsetof(2);
        FOVMUTABLE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationProperties, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationProperties ELEMENT_FACTORY = XrViewConfigurationProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrViewConfigurationProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewConfigurationProperties.nnext(this.address());
        }

        @NativeType(value="XrViewConfigurationType")
        public int viewConfigurationType() {
            return XrViewConfigurationProperties.nviewConfigurationType(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean fovMutable() {
            return XrViewConfigurationProperties.nfovMutable(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(45);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewConfigurationProperties.nnext(this.address(), value);
            return this;
        }

        public Buffer viewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
            XrViewConfigurationProperties.nviewConfigurationType(this.address(), value);
            return this;
        }

        public Buffer fovMutable(@NativeType(value="XrBool32") boolean value) {
            XrViewConfigurationProperties.nfovMutable(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

