/*
 * Edscott Wilson Garcia Copyright 2012
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "rodent.h"
#include "rfm_modules.h"
#include "fuse-group_options.h"
#include "fuse-common.h"

/* this should be first 2 lines after headers: */
G_MODULE_EXPORT LIBRFM_MODULE

#define MODULE_NAME "cifs"
//Not applicable:
//#define SUBMODULE_NAME "fuse"
#define MODULE_LABEL _("CIFS Volume")
//#define MODULE_LABEL _("Windows networks (SMB)")
#define MODULE_ICON_ID "xffm/emblem_atom/compositeC/emblem_smb"
//#define MODULE_ICON_ID "rodent-cifs"
#define MODULE_ENTRY_TIP _("CIFS Volume")
#define MODULE_PLUGIN_INFO _("CIFS Volume")
#define PARENT_MODULE_NAME "fuse"
#define MODULE_PREFERENCES_KEY "RODENT-CIFS"

#include "module-skeleton.h"

// Skeleton definitions

G_MODULE_EXPORT RFM_MODULE_NAME
G_MODULE_EXPORT RFM_SUBMODULE_NAME
G_MODULE_EXPORT RFM_MODULE_LABEL
G_MODULE_EXPORT RFM_MODULE_ICON_ID
G_MODULE_EXPORT RFM_MODULE_ENTRY_TIP

G_MODULE_EXPORT RFM_MODULE_PREFERENCES_KEY(MODULE_PREFERENCES_KEY)
G_MODULE_EXPORT RFM_IS_ROOT_MODULE(FALSE)
G_MODULE_EXPORT RFM_PLUGIN_INFO(MODULE_PLUGIN_INFO)
G_MODULE_EXPORT RFM_MODULE_ACTIVE(TRUE)
G_MODULE_EXPORT RFM_MODULE_MONITOR(TRUE)
G_MODULE_EXPORT RFM_MODULE_RELOAD(TRUE)
G_MODULE_EXPORT RFM_MODULE_SKIPWAIT(TRUE)
G_MODULE_EXPORT RFM_IS_SELECTABLE(TRUE)

// Superceded:
// G_MODULE_EXPORT RFM_ITEM_ICON_ID
// G_MODULE_EXPORT RFM_G_MODULE_CHECK_INIT
// g_module_check_init is now located at fuse-common.c

#define FLAG_KEY(x)  g_strdup_printf("FLAG_%d", x)


#define CIFS_INFO1 _("CIFS Volume")
#define CIFS_INFO2 _("Windows networks (SMB)")
#define CIFS_AUTHORIZATION _("Windows Shared Volume")
#define CIFS_REMOTE_SHARE _("Remote Share")
#define CIFS_TIP _("CIFS Volume")

// option dialogs:
void *
mount_url (widgets_t *widgets_p, const gchar *url);

#include "mount-options.i"
#include "cifs-options.i"
#include "cifs-dialog.i"

#if 0
G_MODULE_EXPORT
void *
module_icon_id(void){
    static gchar *icon=NULL;
    if (icon == NULL){
	icon = g_strdup_printf("%s/pixmaps/rodent-cifs.svg", PACKAGE_DATA_DIR);
    }
    return icon;
}
#endif

// gboolean
// This function fills in previously allocated xfdir_p
// with glob records and entries of the module population.
// Records which are filled in are:
// xfdir_p->pathc: Number of icons for Rodent to display
// xfdir_p->gl[0 ... pathc-1].pathv: Labels to display with each icon
// xfdir_p->gl[0 ... pathc-1].en: Record_entry_t of each icon 
// 				  (NULL entries will point to Rodent root) 
G_MODULE_EXPORT
xfdir_t *
module_xfdir_get (void *p) {
// BSD mount_cifs!
    void *argv[] = {
	p,
#ifdef THIS_IS_LINUX
	(void *)"mount.cifs",
#else
# ifdef THIS_IS_BSD
	(void *)"mount_cifs",
# else
# error "This should not happen"
# endif
#endif
	(void *)"cifs://",
	(void *)"FUSE_MOUNT_POINT",
	(void *)MODULE_NAME,
	(void *)CIFS_AUTHORIZATION,
	NULL
    };
    xfdir_t *xfdir_p = FUSE_xfdir(argv);

    // Here we add the smb browser submodule icon
    dir_t *gl = (dir_t *)malloc((xfdir_p->pathc + 1)*sizeof(dir_t));
    if (!gl) g_error("malloc");
    memset(gl,0,(xfdir_p->pathc+1)*sizeof(dir_t));
    // up item:
    memcpy(gl,  xfdir_p->gl, sizeof(dir_t));
    // browser item:
    gl[1].en=rfm_mk_entry(0);
    gl[1].en->parent_module = MODULE_NAME;
    gl[1].en->st = NULL;
    gl[1].en->module = "smb";
    gchar *g = rfm_void(PLUGIN_DIR, "smb", "module_label");
    if (!g) g=g_strdup_printf("FIXME: no module label for \"%s\"", "smb");
    gl[1].en->path=g;
    gl[1].pathv = g_strdup(g);
    SET_DUMMY_TYPE (gl[1].en->type);

    // other items
    if (xfdir_p->pathc > 1) {
	memcpy(gl+2,  xfdir_p->gl+1, (xfdir_p->pathc-1)*sizeof(dir_t));
    }
    // make the switch
    g_free(xfdir_p->gl);
    xfdir_p->gl = gl;
    xfdir_p->pathc++;

    return xfdir_p;
}

// this is a repeat...
G_MODULE_EXPORT
const gchar *
item_icon_id (void *p){
    void *argv[] = {
	p,
	(void *)MODULE_LABEL,
	(void *)module_icon_id(),
	(void *)CIFS_AUTHORIZATION,
	NULL
    };
    return FUSE_icon(argv);
}

// gboolean
// This function informs Rodent by returning TRUE that the double click
// action will be processed by the module. If function returns FALSE
// (or is not defined in the module) then Rodent will attempt the default
// double click action.
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
double_click(void * p, void *q){
    record_entry_t *en = q;
    if (!en) return NULL;
    const gchar *url = en->pseudo_path;
    if (en->module && strcmp(en->module,"smb")==0){
	return NULL;
    }
    return FUSE_click((void *)confirm_cifs_host_dialog, url, en, MODULE_NAME);
}

static void
umount_host (GtkMenuItem * menuitem, gpointer user_data){
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en || !en->path) return;
    widgets_t * widgets_p = rfm_get_widget("widgets_p");
    SET_MOUNTED_TYPE (en->type);
    FSTAB_fstab_mount (widgets_p, en);
}

// /////////////////////////////////////

void *
mount_url (widgets_t *widgets_p, const gchar *url){
    gchar **options_mount = NULL;
    gchar **options_cifs = NULL;
    if (!url || !widgets_p) return NULL;
    
    NOOP( "mounting url: %s\n", url);
    gchar *mount_point = group_options_get_key_value (url, "FUSE_MOUNT_POINT");
    if (!fuse_mkdir( mount_point)){
	g_free(mount_point);
	return NULL;
    }
    
    gchar *computer = group_options_get_key_value (url, "FUSE_COMPUTER");
    gchar *share = group_options_get_key_value (url, "FUSE_REMOTE_PATH");
    gchar *user = group_options_get_key_value (url, "FUSE_LOGIN");

    gboolean broadband = group_options_get_key_boolean (url, "FUSE_BROADBAND");
    gboolean monitor = group_options_get_key_boolean (url, "FUSE_MONITOR");

    gchar *argv[MAX_COMMAND_ARGS];
    const gchar *remote = url;
    if (strncmp(remote, "cifs://", strlen("cifs://"))==0) {
	remote += strlen("cifs://");
    }
    
    gint i=0;

    // XXX: check if sudo is really needed or not before invoking
    // (mount.cifs may be suid root)
    if (geteuid() != 0) {
	argv[i++] = "sudo";
	argv[i++] = "-A";
    }
    
    argv[i++] = "mount";
    // Mount options
    options_mount = 
	group_options_get_key_options(url, 6, 
	    mount_options);
    gchar **o;
    gchar *m_options = NULL;
    for (o=options_mount; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	if (!m_options) m_options = g_strdup("-");
	gchar *p = *o;
	gchar *g=g_strconcat(m_options, p+1, NULL);
	m_options=g;
    }
    if (m_options) argv[i++] = m_options;
    NOOP(stderr, "m_options = %s\n", m_options);

    argv[i++] = "-t";
    argv[i++] = "cifs";


    if (broadband){
	NOOP(stderr, "%s: broadband\n", mount_point);
	rfm_set_local_type(mount_point);
    } else if (monitor) {
	NOOP(stderr, "%s: monitor\n", mount_point);
	rfm_set_monitor_type(mount_point);
    } else {
	rfm_set_remote_type(mount_point);
    }


    // The rest of options...

    // cifs options
    options_cifs = 
	group_options_get_key_options(url, 10, 
	    cifs_options);
    if (!user || !strlen(user)){
	//get user dialog.
	g_free(user);
	user = g_object_get_data(G_OBJECT(widgets_p->paper), "smb-user");
	if (!user) {
	    user = rfm_get_response (widgets_p, _("Username:"), NULL, FALSE);
	}
    }
    if (!user || !strlen(user)){
	NOOP(stderr, "user field not specified\n");
	return NULL;
    }
    g_free(g_object_get_data(G_OBJECT(widgets_p->paper), "smb-user"));
    g_object_set_data(G_OBJECT(widgets_p->paper), "smb-user", g_strdup(user));
    
    gchar *options = g_strdup_printf("user=%s", user);

    gboolean passOK=FALSE;
    for (o=options_cifs; o && *o && i+1 < MAX_COMMAND_ARGS; o++) {
	if (strcmp(*o, "-o")==0) {
	    continue;
	}
	if (!options) options = g_strdup(*o);
	else {
	    gchar *g=g_strconcat(options, ",", *o, NULL);
	    g_free(options);
	    options=g;
	}
	//if (strncmp(*o, "user=", strlen("user="))==0) userOK = TRUE;
	if (strncmp(*o, "password=", strlen("password="))==0) {
	    passOK = TRUE;
	}
	if (strncmp(*o, "credentials=", strlen("credentials="))==0) {
	    passOK = TRUE;
	}
    }

    NOOP(stderr, "options=%s\n", options);
    gchar *pass = NULL;
    if (!passOK && !strchr(user, '%')) {
	//get password dialog.
	pass = g_object_get_data(G_OBJECT(widgets_p->paper), "smb-password");

	if (!pass) {
	    gchar *string = g_strdup_printf("%s:", _("Enter password"));
	    pass = rfm_get_response (widgets_p, string, NULL, TRUE);
	    g_free(string);
	}

	if (!pass) {
	    NOOP(stderr, "password field not specified\n");
	    return NULL;
	}
	g_object_set_data(G_OBJECT(widgets_p->paper), "smb-password", g_strdup(pass));
    }
    // Credentials

    //gchar *passfile = NULL;
    if (!passOK) {
#if 0
	credentials thing is not working with sudo...
	passfile = get_passfile(widgets_p, user, pass, NULL);
 	gchar *g=g_strconcat(options, ",credentials=", passfile, NULL);
	g_free(options);
	options=g;
#else 
 	gchar *g=g_strconcat(options, ",password=", pass, NULL);
	g_free(options);
	options=g;
#endif
    } 

    if (options){
	argv[i++] = "-o";
	argv[i++] = options;
    }

    gchar *rpath = g_strdup_printf("//%s%s", computer, share);
    argv[i++] = rpath;
    argv[i++] = mount_point;

    argv[i++] = NULL;

    rfm_show_text(widgets_p);

    gchar **p = argv;
    for (; p && *p; p++) NOOP(stderr, " %s", *p);
    NOOP(stderr, "\n");

    rfm_thread_run_argv (widgets_p, argv, FALSE);
    g_free(user);
    g_free(pass);
    g_free(rpath);
    g_free(share);
    g_free(computer);
    g_free(mount_point);
    g_free(options);
    g_free(m_options);

    g_strfreev(options_mount);
    g_strfreev(options_cifs);

    return GINT_TO_POINTER(TRUE);
}


static void
mount_host (GtkMenuItem * menuitem, gpointer user_data){
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    if (!en) return;
    widgets_t *widgets_p = rfm_get_widget("widgets_p");;
    mount_url(widgets_p, en->pseudo_path);
    return;
}


static void 
do_properties (GtkMenuItem * menuitem, gpointer user_data) {
    record_entry_t *en = g_object_get_data(G_OBJECT(menuitem), "entry");
    const gchar *url = en->pseudo_path;
    FUSE_click((void *)confirm_cifs_host_dialog, url, NULL, MODULE_NAME);
    return ;
}


// gboolean
// This function is to generate a module specific popup menu, either on
// icon click or on void space click . 
// If this function will generate a popup menu, return value should be TRUE,
// otherwise return FALSE so Rodent will generate the default popup menu.
// Popup menu for modules should be set as view data on the paper object
// identified by "private_popup_menu".
// Parameter p is the view's widgets_p pointer.
// Parameter q is the icon's record entry.
G_MODULE_EXPORT
void *
private_popup(void *p, void *q){
     void *argv[] = {
	(void *)CIFS_AUTHORIZATION,
	(void *)do_properties,
	(void *)mount_host,
	umount_host
    };
    return FUSE_popup(argv);
}


//  gchar *  
// This function returns a newly allocated string with the general information
// of the entry (parameter p). Rodent uses this to construct the popup tip.
// Returned value should be freed when no longer used.
G_MODULE_EXPORT
void *
item_entry_tip(void *p){
    if (!p) return NULL;
    record_entry_t *en = p;
    if (!en->path) return NULL;
    if (strcmp(en->path, CIFS_AUTHORIZATION)==0){
	return g_strdup(CIFS_TIP);
    }
    if (rfm_g_file_test(en->path, G_FILE_TEST_IS_DIR)){
	gchar *text =  g_strdup_printf("\n%s\n\n%s\n",
		en->path,
		_("The mount point used for the media device connection."));
	return text;
    }
    if (en->module  && strcmp(en->module, MODULE_NAME)){
	const gchar *text = rfm_void(PLUGIN_DIR, en->module, "module_entry_tip");
	return g_strdup(text);
    } 
    return g_strdup("fixme: cifs-submodule.c");
}



