#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static gchar *zypper;
#if 0
static gchar *z_global_lo[]={
    "help", 
    "version", 
    "promptids", 
    "quiet", 
    "verbose", 
    "no-abbrev", 
    "table-style", 
    "rug-compatible", 
    "non-interactive", 
    "non-interactive-include-reboot-patches", 
    "xmlout", 
    "ignore-unknown", 
    "no-gpg-checks", 
    "gpg-auto-import-keys", 
    "disable-repositories", 
    "no-refresh", 
    "no-cd", 
    "no-remote", 
    "disable-system-resolvables", 
    NULL};
static gchar *z_global_lop[]={
    "config", 
    "userdata", 
    "reposd-dir", 
    "cache-dir", 
    "raw-cache-dir", 
    "solve-cache-dir", 
    "pkg-cache-dir", 
    "plus-repo", 
    "root", 
    NULL};


static gchar *z_rt[] = {"repo", "type", NULL};
static gchar *z_r[] = {"repo",  NULL};
static gchar *z_search_o[] = {"match-all", "match-any", "match-substrings", "match-words", "match-exact",  "search-descriptions", "case-sensitive", "installed-only", "uninstalled-only", "sort-by-name", "sort-by-repo", "details", NULL};
static gchar *z_install_o[] = {"name", "capability", "force",
    "oldpackage", "auto-agree-with-licenses", "debug-solver",
    "no-recommends", "recommends", "no-force-resolution",
    "force-resolution", "dry-run", "download", "download-only", NULL};
static gchar *z_remove_o[] = {"name", "capability", "force", "debug-solver",
     "no-force-resolution","force-resolution", "clean-deps",  "no-clean-deps", 
     "dry-run",NULL};
static gchar *z_update_o[] = {  "debug-solver", "auto-agree-with-licenses", 
    "best-effort","debug-solver","download", "download-only", 
    "skip-interactive",
    "no-recommends", "recommends",
     "no-force-resolution","force-resolution",  
     "dry-run",NULL};
static gchar *z_refresh_o[] = {"force", "force-build", "force-download", "build-only", 
    "download-only", "services", NULL};
static gchar *z_clean_o[] = {"metadata", "raw-metadata", "all",  NULL};
static gchar *z_list_updates_o[] =  {"best-effort", "all",  NULL};

#define ZYPPER_MENU_STUFF \
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_search",\
	    {0x2001, N_("search"),"xffm/emblem_find",\
	    (gpointer) pkg_option, "search",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_install",\
	    {0x2001, N_("install"),"xffm/emblem_greenball",\
	    (gpointer) pkg_option, "install",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_remove",\
	    {0x2001, N_("remove"),"xffm/stock_remove",\
	    (gpointer) pkg_option, "remove",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_update",\
	    {0x2001, N_("update"),"xffm/stock_refresh",\
	    (gpointer) pkg_option, "update",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_refresh",\
	    {0x2001, N_("refresh"),"xffm/emblem_synchronized",\
	    (gpointer) pkg_option, "refresh",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_clean",\
	    {0x2001, N_("clean"),"xffm/stock_clear",\
	    (gpointer) pkg_option, "clean",0,0}},\
	{MENUITEM_TYPE,"pkg_menu_menu","pkg_list-updates",\
	    {0x2001, N_("list-updates"),"xffm/stock_dialog-info",\
	    (gpointer) pkg_option, "list-updates",0,0}},\
	{NULL_TYPE} 

static pkg_command_t zyppers[] = {
    {.flags=ACCESS_READ|NO_SELECTION, 
        .cmd="search", .eoptions="tr", .argument="pattern/pkg_name", .loptions=z_search_o},
    {.flags=ACCESS_WRITE|NO_SELECTION|REMOTE_SELECTION|LOCK_DATABASE, 
        .cmd="install", .argument="pkg-name", .loptions=z_install_o, .loptions_p=z_rt},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION|LOCK_DATABASE|ZYPPER_ONLY, 
        .cmd="remove", .argument="pkg-name", .loptions=z_remove_o, .loptions_p=z_rt },
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCAL_SELECTION, 
        .cmd="update", .argument="pkg-name", .loptions=z_update_o, .loptions_p=z_rt},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE|ZYPPER_ONLY, 
        .cmd="refresh",  .loptions=z_refresh_o, .loptions_p=z_r},
    {.flags=ACCESS_WRITE|NO_SELECTION|LOCK_DATABASE, 
        .cmd="clean",  .loptions=z_clean_o, .loptions_p=z_rt},
    {.flags=ACCESS_READ|NO_SELECTION|LOCK_DATABASE|ZYPPER_ONLY, 
        .cmd="list-updates",  .loptions=z_list_updates_o, .loptions_p=z_rt},
    {.cmd=NULL} // no comma after last item
};


#endif

static GSList *add_zypper_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
	if (!strchr(line,'\n')) return pkg_list;
	if (!strchr(line,'|')){
	    //rfm_threaded_diagnostics(widgets_p, "xffm/emblem_package", NULL);
	    rfm_threaded_diagnostics(widgets_p, "xffm_tag/blue", g_strdup(line));	
	    return pkg_list;
	}    
	rfm_threaded_diagnostics(widgets_p, "xffm_tag/red", g_strdup(line));	
	NOOP("line=%s",line);
	
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	if (line[0] == 'E')  return pkg_list;

	gchar **split = g_strsplit(line, "|", -1);
	DBG("%s|%s|%s\n", split[0], split[1], split[2]);
	g_strstrip(split[1]);
	g_strstrip(split[2]);
	record_entry_t *en=rfm_mk_entry(0);
	en->path = g_strdup(split[1]);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));
	if (*(split[0]) == 'i') SET_LOCAL_TYPE(en->type);
	g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n", split[2]));
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
        g_strfreev(split);
    return pkg_list;
}

static GSList *add_rpm_item(GSList *pkg_list, gchar *line){
	// XXX item 2: update-po not working in fbsd...
	if (!strchr(line,'\n')) return pkg_list;
	*(strchr(line,'\n'))=0;
	g_strchug(line);
	record_entry_t *en=rfm_mk_entry(0);
	en->type=0; /* remove local-type attributes */
	en->st = (struct stat *)malloc(sizeof(struct stat));
	if (!en->st) g_error("malloc: %s\n", strerror(errno));
	memset(en->st,0,sizeof(struct stat));
	NOOP("line=%s",line);
	{
            en->path = package_name(line);
            //en->tag = g_strdup(line);
            SET_LOCAL_TYPE(en->type);
            g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(""));
	} 
	en->module=MODULE_NAME;
	pkg_list=g_slist_prepend(pkg_list,en);
    return pkg_list;
}

