#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif

static gchar *pkg=NULL;

static GSList *add_search_item(GSList *pkg_list, gchar *line, widgets_t *widgets_p){
    if (!strchr(line,'\n')) return pkg_list;
    *(strchr(line,'\n'))=0;
    g_strchug(line);
    record_entry_t *en=rfm_mk_entry(0);
    en->type=0; /* remove local-type attributes */
    en->st = (struct stat *)malloc(sizeof(struct stat));
    if (!en->st) g_error("malloc: %s\n", strerror(errno));
    memset(en->st,0,sizeof(struct stat));
    NOOP("line=%s",line);
    en->path = g_strdup(line);
    
    // Check if installed...
    gboolean installed = FALSE;
    gchar *cmd;

    gchar xline[4096];
    FILE *pp=NULL;

    cmd = g_strdup_printf("pkg query \"%%c\" %s", en->path);
    pp = popen(cmd, "r");
    memset(xline,0,4096);
    if (pp){
        if (fgets(xline, 4095, pp)) {
            installed = TRUE;
            SET_LOCAL_TYPE(en->type);
            g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup(xline));
        }
        pclose(pp);
    }
    g_free(cmd);

    if (!installed) {
        gchar *name = package_name(en->path);
        cmd = g_strdup_printf("pkg info %s", name);
        gchar *old_version_string = NULL;
        pp = popen(cmd, "r");
        if (pp){
            while (fgets(xline, 4095, pp) && !feof(pp)){
                if (strstr(xline, "Installed") || strstr(xline, "Version") || strstr(xline, "@")){
                    gchar *g = g_strconcat((old_version_string)?old_version_string:"", xline, NULL);
                    g_free(old_version_string);
                    old_version_string = g;
                }
            }
            pclose(pp);
        }
        g_free(cmd);
        g_free(name);

        cmd = g_strdup_printf("pkg rquery \"%%c\" %s", en->path);
        pp = popen(cmd, "r");
        if (pp){
          if (fgets(xline, 4095, pp)) {
            gchar *tip_string = NULL;
            if (old_version_string) {
                SET_PLUGIN_TYPE1(en->type);
                tip_string = g_strdup_printf("%s\n%s\n%s\n%s:\n",_("New!"), xline,  old_version_string, _("Update"));
                //tip_string = g_strconcat("New! ", xline,  NULL);
                //tip_string = g_strconcat("<b>New!</b> ", xline, "\n", old_version_string, NULL);
            } else {
                tip_string = g_strdup(xline);
            }

            g_hash_table_replace(installed_hash, g_strdup(en->path), tip_string);
          }
          pclose(pp);
        }
        g_free(cmd);
    }
    en->module=MODULE_NAME;
    pkg_list=g_slist_prepend(pkg_list,en);
    return pkg_list;
}

static GSList *add_pkg_item(GSList *pkg_list, gchar *line){
    if (!strchr(line,'\n')) return pkg_list;
    *(strchr(line,'\n'))=0;
    g_strchug(line);
    record_entry_t *en=rfm_mk_entry(0);
    en->type=0; /* remove local-type attributes */
    en->st = (struct stat *)malloc(sizeof(struct stat));
    if (!en->st) g_error("malloc: %s\n", strerror(errno));
    memset(en->st,0,sizeof(struct stat));
    gchar **split = g_strsplit(line, " ", 2);
    if (!split) {
        DBG("pkg-module pkg_xfdir_get(): split barfed [%s]\n", line);
        return pkg_list;
    }
    en->path = g_strdup(split[0]);
    SET_LOCAL_TYPE(en->type);
    g_strchug(split[1]);
    g_hash_table_replace(installed_hash, g_strdup(en->path), g_strdup_printf("%s\n", split[1]));
    NOOP("hashing %s -> %s\n", en->path, split[1]);
    g_strfreev(split);
    en->module=MODULE_NAME;
    pkg_list=g_slist_prepend(pkg_list,en);
    return pkg_list;
}

