/*
 * Copyright 2005-2012 Edscott Wilson Garcia 
 * license: GPL v.3
 */

#define __RFM_MAIN_C__
#include  "config.h"



#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <glob.h>
#include <limits.h>
#include <memory.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <gmodule.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "rodent.h"



# include <sys/time.h>
# include <sys/resource.h>

static pid_t animation_pid=0;
static rfm_global_t *rfm_global_p=NULL;
extern gchar *rfm_iconpath;

static void
critical_module_error(const gchar *mod){
    g_error("Critical module error. Cannot load module \"%s\".\n", mod);
}

static void
finishit (int sig) {
    TRACE ("ZZZ got signal %d\n", sig);
    DBG ("ZZZ got signal %d (SIGUSR1=%d,SIGUSR2=%d)\n", sig, SIGUSR1, SIGUSR2);
    if(sig == SIGUSR1) {
        return;
    } else if(sig == SIGUSR2) {
        return;
    } else {
        DBG ("ZZZ Rodent: signal %d received. \n", sig);
#ifndef CORE
	if (sig == SIGSEGV) {
	    rfm_killall_children();
	    if (fork()) exit(1);    
	    if (strstr(rfm_global_p->argv[0], "rodent-desk")){
		execlp("rodent-desk", "rodent-desk", NULL);
	    } else {
		widgets_t *widgets_p = rfm_get_widget("widgets_p");
		view_t *view_p = widgets_p->view_p;
		if (view_p->en) {
                    if (view_p->en->module) 
		        execlp("rodent-plug", "rodent-plug", 
                                view_p->en->module, NULL);
                    else
                        execlp("rodent-fm", "rodent-fm",
                                view_p->en->path, NULL);
		} else {
		    execlp("rodent", "rodent", NULL);
		}
	    }

	}
#endif
        //rfm_void (RFM_MODULE_DIR, "settings", "mcs_shm_stop");
	// Clean shutdown.
	if (!rfm_rational(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(QUIT_ACTIVATE), NULL, "callback")){
            exit(1);
	    //critical_module_error("callbacks");
	} 
    }
}

static void
signal_connections (void
    ) {
#ifdef HAVE_SIGACTION
    struct sigaction act;
    act.sa_handler = finishit;
    sigemptyset (&act.sa_mask);
# ifdef SA_RESTART
    act.sa_flags = SA_RESTART;
# else
    act.sa_flags = 0;
# endif

//      sigaction(SIGHUP,&act,NULL);
      sigaction(SIGTERM,&act,NULL);
# ifndef DEBUG
//      sigaction(SIGINT,&act,NULL);
//      sigaction(SIGQUIT,&act,NULL);
//      sigaction(SIGABRT,&act,NULL);
//      sigaction(SIGBUS,&act,NULL);
    sigaction (SIGSEGV, &act, NULL);
//      sigaction(SIGFPE,&act,NULL);

    sigaction (SIGUSR1, &act, NULL);
    sigaction (SIGUSR2, &act, NULL);
# endif
#else
//      signal(SIGHUP, finishit);
      signal(SIGTERM, finishit);
# ifndef DEBUG
//      signal(SIGINT, finishit);
//      signal(SIGQUIT, finishit);
//      signal(SIGABRT, finishit);
//      signal(SIGBUS, finishit);
    signal (SIGSEGV, finishit);
//      signal(SIGFPE, finishit);
    signal (SIGUSR1, finishit);
    signal (SIGUSR2, finishit);
# endif
#endif
}

static void
rfm_global_init (int argc, char *argv[]) {
    //gchar *leak = g_strdup("This is leak test.");
    TRACE("rfm_global_init...\n");
    if(rfm_global_p) return;
    rfm_global_p = rfm_global_new();

    rfm_global_p->argv = (char **)malloc ((argc + 3) * sizeof (char *));
    memset (rfm_global_p->argv, 0, (argc + 3) * sizeof (char *));
    rfm_global_p->argv[0] = g_path_get_basename (argv[0]);
    gint i;
    for(i = 1; i < argc; i++) {
        rfm_global_p->argv[i] = g_strdup (argv[i]);
    }
    rfm_global_p->argc = argc;
    // main thread...
    rfm_rw_lock_init(&(rfm_global_p->setup_lock));
    rfm_rw_lock_init(&(rfm_global_p->window_lock));
    rfm_cond_init(rfm_global_p->janitor_signal);
    
    // Popup control
    rfm_mutex_init(rfm_global_p->status_mutex);
    rfm_cond_init(rfm_global_p->status_signal);


 
}

static void
free_global_p(void){
    rfm_rw_lock_clear(&(rfm_global_p->setup_lock));
    rfm_rw_lock_clear(&(rfm_global_p->window_lock));
    rfm_cond_free(rfm_global_p->janitor_signal);
    rfm_cond_free(rfm_global_p->status_signal);
    rfm_mutex_free(rfm_global_p->status_mutex);
    gint i;
    for(i = 0; i < rfm_global_p->argc; i++) {
	g_free(rfm_global_p->argv[i]);
    }

    g_free(rfm_global_p->argv);
    g_free(rfm_global_p);
}

static gboolean
version_query (int argc, char *argv[]
    ) {
    int i;
    for(i = 0; i < argc; i++) {
        if(strcmp (argv[i], "--version") == 0) {
            fprintf (stdout, "%s %s \n", PACKAGE, VERSION );
            // Copyright
            fprintf (stdout, "%c[31m%s\n", 0x1B, COPYRIGHT);
            // License
            const gchar *license = _("\nLicense GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>.\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n");
            fprintf(stdout, "%s", license);
            fprintf(stdout, _("Written by %s.\n"), "Edscott Wilson Garcia <edscott@users.sf.net>");

            fprintf (stdout, "%c[31mBuilt with GTK+-%d.%d.%d,linked with GTK+-%d.%d.%d.\n",
                     0x1B, GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION,
                     gtk_major_version, gtk_minor_version, gtk_micro_version);
            
            fprintf (stdout, "%c[31mRodent may use the following solid programs: ", 0x1B);
            gchar *commands[] = { getenv ("SHELL"), "cp", "mv", "ln", "rm", "mount", "grep", "fgr", "sudo", "bcrypt", "shred", "touch", "chown", "chmod", "kill" ,"smbclient", "nmblookup", "ps", "pkg", "rpm", "yum", "zypper", NULL};
            
            gchar **pp;
            for(pp = commands; pp && *pp; pp++) {
		gchar *path=g_find_program_in_path(*pp);
                fprintf (stdout, "%c[32m %s", 0x1B, *pp);
                if (path) {
                    g_free(path);
                } else {
                    fprintf (stdout, " (%s)", _("not installed"));
                }
                if (*(pp+1)) fprintf (stdout, "%c[32m, ", 0x1B);
	    }
            
            fprintf (stdout, "\n%c[31mFind a bug or would like an enhancement? Open a ticket at %s\n", 0x1B, PACKAGE_BUGREPORT);
            fprintf (stdout, "%c[0m\n", 0x1B);
            exit (0);            
        }

    }
    return FALSE;
}

static gboolean enable_desktop = FALSE;
static gboolean synchronize_X = FALSE;

static void
process_arg (int *argc, char ***argv) {
    int i;
    int out_argc = 0;
    static char **out_argv;

    out_argv = (char **)malloc ((*argc + 2) * sizeof (char *));
    out_argv[*argc - 1] = out_argv[*argc] = NULL;
    for(i = 0; i < *argc; i++) {
	if (strcmp(*((*argv) + i), "--sync")==0) {
	    synchronize_X = TRUE;
	    continue;
	}
        out_argv[out_argc] = *((*argv) + i);
        TRACE ("out_argcv[%d]=%s\n", out_argc, out_argv[out_argc]);
        out_argc++;
    }
    /* do variable substitution for $HOME or ~ */
    if(strcmp (out_argv[out_argc - 1], "$HOME") == 0)
        out_argv[out_argc - 1] = g_strdup(g_get_home_dir ());
    if(strcmp (out_argv[out_argc - 1], "~") == 0)
        out_argv[out_argc - 1] = g_strdup(g_get_home_dir ());
    if (rfm_g_file_test(out_argv[out_argc - 1], G_FILE_TEST_IS_DIR)){
	// change to absolute path
	if (!g_path_is_absolute (out_argv[out_argc - 1])){
	    gchar *original= g_get_current_dir();
	    if (chdir(out_argv[out_argc - 1]) < 0){
		DBG("chdir(%s): %s\n", out_argv[out_argc - 1], strerror(errno));
	    }
	    out_argv[out_argc - 1] = g_get_current_dir();
	    if (chdir(original) < 0){
		DBG("chdir(%s): %s\n", original, strerror(errno));
	    }
	    g_free(original);
	}
    }
    *argv = out_argv;
    *argc = out_argc;
}
static void cleanup(void){
    // Final cleanup to sieve out Valgrind detected memory leaks.
    rfm_free_lite_hash();
    rodent_clear_tooltip();
    // unload plugins.
    rfm_unload_module("dotdesktop");
    rfm_unload_module("fstab");
    rfm_unload_module("ps");
    rfm_unload_module("smb");
     rfm_unload_module("workgroup");
     rfm_unload_module("shares");
    rfm_unload_module("fuse");
     rfm_unload_module("cifs");
#ifdef THIS_IS_LINUX
     rfm_unload_module("ecryptfs");
     rfm_unload_module("ftp");
     rfm_unload_module("obex");
#endif
     rfm_unload_module("nfs");
     rfm_unload_module("sftp");
    // unload modules. Just for valgrind tests
#if 0
    rfm_unload_module("properties");
    rfm_unload_module("combobox");
    rfm_unload_module("completion");
    rfm_unload_module("icons");// check for hash tables OK
    rfm_unload_module("mime");// check for hash tables OK
    rfm_unload_module("mimemagic");
    rfm_unload_module("mimezip");
    rfm_unload_module("run");
    rfm_unload_module("settings");// check for hash tables
    rfm_unload_module("xmltree");
    rfm_unload_module("fgr");
    rfm_unload_module("callbacks");//harakiri
#endif
    rfm_destroy_module_hash();
    if (rfm_global_p->thread_queue) {
	g_thread_pool_free(rfm_global_p->thread_queue, TRUE, TRUE); 
    }
    environ_t *environ_v = rfm_get_environ();
    gint i; for(i=0; environ_v[i].env_var; i++){
	g_free(environ_v[i].env_string); 
    }

    while (gtk_events_pending()) gtk_main_iteration();
    // free rfm_global_p
    free_global_p();
}   

  

static gboolean
do_setup(void *data){

    gchar **argv = data;
    /* read in shm settings: this will also pull in icon module... */
    // Icon functionality *requires* main loop to be running!
    TRACE("Rodent: Loading settings dialog module\n");
    if (!rfm_void (RFM_MODULE_DIR, "settings", "module_load")){
	TRACE("Setting default or preset envvars\n");
	gint i;
        environ_t *environ_v = rfm_get_environ();
	for(i = 0; i < RFM_OPTIONS; i++) {
	    gboolean default_value =
		environ_v[i].env_string && 
		strlen(environ_v[i].env_string);
	    gboolean preset_value =
		getenv(environ_v[i].env_var) &&
		strlen(getenv(environ_v[i].env_var));
	    if (preset_value) {
		// Do nothing: use preset value over default value
	    } else if (default_value){
		// use default value
		gchar *value = g_strdup(environ_v[i].env_string);
		rfm_setenv(environ_v[i].env_var, value, FALSE);
		g_free(value);
		NOOP("setting %s -> %s (%d)\n",
			environ_v[i].env_var, environ_v[i].env_string, FALSE);
	    } else {
		// unset envvar
		rfm_setenv(environ_v[i].env_var, NULL, FALSE);
	    }
	}
    }
    //rfm_set_text_editor_envar();
   // Check if icon module was available to load
    if(strstr (argv[0], "-getpass")) {

        gchar *p;
	const gchar *sudo_command=getenv("RFM_ASKPASS_COMMAND");

	gchar *string=NULL;
	gchar *fullstring=NULL;
	if (argv[1]) {
	    string = g_strdup(_(argv[1]));

	} else {
	    string = g_strdup_printf("%s:", _("Enter password"));
	}
	if (sudo_command && strlen(sudo_command)) {
	    gchar *p = (gchar *)sudo_command;
	    gchar *markup=g_strdup("");
	    for (;p && *p; p++){
		gchar *g;
		if (*p == '&') g = g_strdup_printf("%s&amp;", markup);
		else g = g_strdup_printf("%s%c", markup, *p );
		g_free(markup);
		markup = g;
	    }
	    fullstring=g_strdup_printf("%s\n%s", markup, string);
	    g_free(markup);
	} else {
	    fullstring = g_strdup(string);
	}
	
        p = rfm_get_response (NULL, fullstring, NULL, TRUE);

	g_free(string);
	g_free(fullstring);
	if (p && strlen(p)) {
	    fprintf (stdout, "%s\n", p);
	    memset(p, 0, strlen(p));
	} else {
	    // No password, either cancel or close, then
	    // send interrupt signal to parent
	    pid_t parent = getppid();
	    kill(parent, SIGINT);
	}
	g_free(p);

	exit(0);
    }






#ifndef PACKAGE_URL
# define PACKAGE_URL "http://xffm.org"
#endif

    if (strstr(argv[0], "rodent-desk")) {
        TRACE("Rodent: create_desktop ()\n");
        rfm_global_p->window = rfm_void(MODULE_DIR, "deskview", "create_desktop");
   } else {
        TRACE("Rodent: create_gridview ()\n");
        rfm_global_p->window = rfm_void(MODULE_DIR, "gridview", "create_gridview");
   }
    TRACE("rfm_global_p->window=0x%x\n", GPOINTER_TO_INT(rfm_global_p->window));
    if (!rfm_global_p->window) {
	critical_module_error((strstr(argv[0], "rodent-desk"))?"deskview":"gridview");
    }
    SETWD();

    TRACE("Rodent: wait on setup semaphore\n");
    NOOP("Starting janitor thread...\n");
    // This thread will exit only after window is destroyed in this
    // thread. Therefore, window nor view destruction should wait for 
    // janitor_thread termination.
    rfm_thread_create ("janitor", janitor, rfm_global_p->window, FALSE);

    //if (animation_pid) kill(animation_pid, SIGKILL); else 
    {
	    pid_t pid = fork();
	    if (!pid){
		gchar *a[]={"/bin/sh", "-c", "killall rodent-anim 2>/dev/null", NULL};
		execvp("/bin/sh", a);
		_exit(123);
	    }
	    gint status;
	    waitpid(pid, &status, 0);
    }
            
    gchar *prg = g_path_get_basename(rfm_global_p->argv[0]);

    if(strcmp (prg, "rodent") ){
        enable_desktop = FALSE;
    } else if(getenv ("RFM_ENABLE_DESKTOP") && strlen (getenv ("RFM_ENABLE_DESKTOP"))){
        enable_desktop = GPOINTER_TO_INT(rfm_void(RFM_MODULE_DIR, "settings", "localhost_check"));
    }

    TRACE (">>>> enable_desktop=%d\n", enable_desktop);

    if(enable_desktop) {
	Display *display=gdk_x11_display_get_xdisplay(
		gdk_display_get_default());
        GError *error = NULL;
        Atom selection_atom = XInternAtom (display, "RODENT_DESK_ATOM", True);
        Window xid = (selection_atom != None)?
	    XGetSelectionOwner (display, selection_atom):
	    None;
        NOOP ("enabling desktop=%d atom=%d xid=%d\n", 
		enable_desktop, (gint)selection_atom, (gint)xid);
        if(selection_atom != None && xid != None) 
	{
            TRACE ("rodent-desk already running\n");
        } else if(!g_spawn_command_line_async ("rodent-desk", &error)) {
            DBG ("%s\n", error->message);
        }
    } else {
        NOOP ("Auto deskview disabled\n");
    }
    rfm_rw_lock_writer_unlock (&(rfm_global_p->setup_lock));
    return FALSE;
}

static gboolean
welcome(void *data){
	gchar *text3=g_strdup_printf("<i>Rodent %s (xffm-%s)</i>", 
		TAG, PACKAGE_VERSION);
	gchar *text1=g_strdup_printf(_("Welcome to %s"), text3); 

        gchar *rcfile = g_build_filename (MCS_SHM_PLUGIN_FILE, NULL);
	gchar *text2=g_strdup_printf(_("Settings saved to '%s'"), rcfile);

	gchar *message=g_strdup_printf("\n%s: %s\n\n%s...\n\n", 
		_("Icon Theme Specification"),
		(getenv("RFM_USE_GTK_ICON_THEME") 
		 && strlen(getenv("RFM_USE_GTK_ICON_THEME")))?
		"GTK": "Elite",
		"");
		//_("Creating index file"));

	gchar *text=g_strdup_printf("<b>%s</b>\n\n%s\n\n%s\n%s\n\n", 
		_("Welcome!"),
		text1, message,
		text2);
	    
        rfm_confirm (NULL, -1, text, NULL, NULL);
	g_free(message);
 	g_free(text3);
	g_free(text2);
	g_free(text1);
	g_free(text);	  
	g_free(rcfile);	  

	// Open settings dialog
	rfm_rational(RFM_MODULE_DIR, "callbacks", GINT_TO_POINTER(SETTINGS_ACTIVATE), NULL, "callback");
    return FALSE;
}

//HACK:
//should fix dbh so that bak file will not be created when appropriate flag is set.
// XXX: is this done in dbh yet?
static void
cache_cleanup(void){
    gchar *cache_dir;
    cache_dir = g_build_filename (USER_DBH_CACHE_DIR, NULL);
    if (g_file_test(cache_dir, G_FILE_TEST_IS_DIR)){
         GDir *c_dir = g_dir_open (cache_dir, 0, NULL); 
         if (!c_dir) return;
         const gchar *name;
         while ((name = g_dir_read_name(c_dir)) != NULL){
             if (strrchr(name, '.') && strcmp(strrchr(name, '.'),".bak")==0){
                 gchar *fname = g_build_filename(cache_dir, name, NULL);
                 gchar *command = g_strdup_printf("unlink %s", fname);
                 TRACE("%s\n", command);
                 if (unlink(fname) < 0){
                     DBG("%s: %s\n", command, strerror(errno));
                 }
                 g_free(command);
                 g_free(fname);
             }
         }
         g_dir_close(c_dir);
    }
    g_free(cache_dir);
}

gint
main (int argc, char *argv[]) {

#if GTK_MAJOR_VERSION==2
    if (rfm_gtk_version() != 2)
#else
    if (rfm_gtk_version() != 3)
#endif
	g_error("Critical error. Librfm is compiled for gtk+%d.0 You need to reconfigure and compile to match gtk versions.\n", rfm_gtk_version());


    cache_cleanup();
    gchar *b = g_path_get_basename(argv[0]);
    gboolean anim_OK = FALSE;
    if (strcmp(b, "rodent")==0){
	if (argc == 1 || g_file_test(argv[1], G_FILE_TEST_EXISTS) ){
	    anim_OK = TRUE;
	}
    }
    if (anim_OK)
    {
	animation_pid = fork();
	if (!animation_pid){
	    gchar *ra = g_find_program_in_path("rodent-anim");
	    if (ra){
		execlp(ra, ra, NULL);
	    }
	    _exit(123);
	}
    }
    // set timeout to zap stale parallel safe locks
    dbh_set_lock_timeout(3);

    {
        gchar *dir = g_strconcat ("rfm", G_DIR_SEPARATOR_S, "plugins", NULL);
        rfm_set_plugin_dir(LIBDIR, dir);
        g_free(dir);
    }

    gchar *first = g_build_filename (MCS_SHM_PLUGIN_FILE, NULL); 

    if (g_file_test(first, G_FILE_TEST_EXISTS)) {
	g_free(first);
	first = NULL;
    } 
    NOOP ("Rodent: program name is = %s\n", argv[0]);

    rfm_sanity_check (argc, argv, LIBRFM_SERIAL);
    if(version_query (argc, argv)) exit (1);
    
    // In order for SSH_ASKPASS to work (for sshfs or for executing
    // ssh commands at the lpterminal) we must detach the tty. 
    // This interferes with stepwise debugging with gdb.
    // The other caveat with gdb is that rfm_g_file_test_with_wait()
    // will detect the timeout under stepwise gdb.
 
    /* do the following before allowing any dynamic library
     * to be loaded to memory (except glib)... */

#if defined TCMALLOC 
    g_warning("TCMALLOC enabled: sudo/ssh password dialog will not operate (if started from a tty)!\n");
#else
    
    if(strstr (argv[0], "rodent-getpass") == NULL)
    {
	if(fork ()){
	    sleep(2);
	    _exit (123);
	}
	setsid();
    } 
    
#endif

   /* g_thread_supported is geeky. returns true if g_threads are already 
     * initialized, not whether they are supported on the current platform! */
    XInitThreads ();
    rfm_thread_init (NULL);

    // this is a must. Nothing interesting in stdin anyways.
    // This should be done in tubo (>=5.0.14)
    /*int fd = fileno (stdin);
    if (fd >= 0){
	FILE *nullfd = fopen ("/dev/null", "rb");
	dup2 (fileno (nullfd), fd);
    }*/

    /* ignore hangups? */
    (void)signal (SIGHUP, SIG_IGN);



#ifdef CORE
    struct rlimit rlim;
    if (!strstr(argv[0], "getpass")) {
	DBG("Enabling core dumps...\n");
    }
    rlim.rlim_cur = RLIM_INFINITY;
    rlim.rlim_max = RLIM_INFINITY;
    setrlimit (RLIMIT_CORE, &rlim);
#endif

    rfm_global_init (argc, argv);
    process_arg (&argc, &argv);
    if(!g_module_supported ()) {
        g_error ("g_module_supported() != TRUE\n");
        exit (1);
    }
    TRACE("Rodent: signal_connections\n");
    signal_connections ();

    rfm_init_env ();            /* allocate memory for dynamic environment variables */
    rfm_setenv ("PWD", (gchar *) GETWD, FALSE);

    TRACE("Rodent: rfm_rw_lock_writer_lock\n");
    rfm_rw_lock_writer_lock (&(rfm_global_p->setup_lock));

    /***************************************************/
    /* start loading required dynamic libraries here... */
    TRACE("Rodent: rfm_init\n");
    rfm_init();
    DBG("rfm_global_init(): gtk thread=0x%x\n",
	    GPOINTER_TO_INT(rfm_get_gtk_thread()));   

#ifdef ENABLE_NLS
    /* this binds rodent domain: */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    TRACE("main(): textdomain=%s (%s) locale_dir=%s (%s)\n",
	    textdomain(NULL), GETTEXT_PACKAGE,
	    bindtextdomain(textdomain(NULL), NULL), PACKAGE_LOCALE_DIR);
# ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
# endif
#endif
 
    setlocale (LC_ALL, "");

    NOOP("test: %s\n", _("Remote Share"));

    TRACE("Rodent: gtk_init\n");
    gtk_init (&argc, &argv);

    if (synchronize_X) {
	    TRACE("Synchronizing X events!!!!\n");
	    Display *display=gdk_x11_display_get_xdisplay(gdk_display_get_default());
	    XSynchronize(display, True);
    }
#if 0
    deprecated
    // set gtk properties
    GtkSettings *settings = gtk_settings_get_default();
    if (settings){
	/* make sure the type is realized */
	g_type_class_unref (g_type_class_ref (GTK_TYPE_BUTTON));
	g_object_set(G_OBJECT(settings), 
	    "gtk-button-images", TRUE,
	    NULL);
    }
#endif
    // Set up popup construction mutex:
    TRACE("Rodent: rodent_popup_control\n");
    rodent_popup_control();

    rfm_global_p->root_Xwindow = gdk_x11_get_default_root_xwindow ();
    rfm_global_p->Xdisplay = gdk_x11_display_get_xdisplay(gdk_display_get_default());
    rfm_global_p->Xvisual = gdk_x11_visual_get_xvisual(gdk_visual_get_system());
#if GTK_MAJOR_VERSION==3 
    GdkDeviceManager *gdm = gdk_display_get_device_manager(gdk_display_get_default());
    rfm_global_p->pointer = gdk_device_manager_get_client_pointer(gdm);
#endif

    TRACE("Adding idle function: do_setup()\n");
    g_idle_add(do_setup, argv);
    if (first && !strstr(argv[0], "rodent-desk")) {
	g_idle_add(welcome, NULL);
	g_free(first);
    }


    TRACE("Rodent: entering event loop\n");
    rodent_main_loop();
    TRACE("Rodent: exited event loop: no more threads are active.\n");

    cleanup();
    

    return 0;
}
