# RPM spec file for SUSE OpenSUSE created by configure script.
Summary: Advanced user file manager for Linux and BSD systems	
Name: rodent-fm
Version: 5.3.12
Release: 1
License: GPL-3.0
URL: http://xffm.org/rodent-fm.html
Source0: %{name}-%{version}.tar.gz
Group: System/GUI/Other 
BuildRoot: %{_tmppath}/%{name}-root
Requires: librfm5 >= 5.2.11
Conflicts: rodent
BuildRequires: librfm5-devel >= 5.2.11
BuildRequires: fdupes
BuildRequires: update-desktop-files

%changelog
* Fri Nov 22 2013  <edscott@users.sf.net> 5.3.12-1
- RPM release


%description
Rodent is fast, small and powerful parallel file manager. All operations are
done in threads, and command are inherited from the GNU or BSD operating
systems to reduce the possibility of bugs to a minimum.

%prep
%setup -q

%build
%configure
make -j4
strip -s Build/modules/.libs/libgridview.so
strip -s Build/modules/.libs/libdeskview.so
strip -s Build/plugins/.libs/libfstab.so
strip -s Build/plugins/.libs/libecryptfs.so
strip -s Build/plugins/.libs/libobex.so
strip -s Build/plugins/.libs/libfuse.so
strip -s Build/plugins/.libs/libdotdesktop.so
strip -s Build/plugins/.libs/libps.so
strip -s Build/plugins/.libs/libftp.so
strip -s Build/plugins/.libs/libnfs.so
strip -s Build/plugins/.libs/libsftp.so
strip -s Build/plugins/.libs/libshares.so
strip -s Build/plugins/.libs/libsmb.so
strip -s Build/plugins/.libs/libcifs.so
strip -s Build/plugins/.libs/libworkgroup.so
strip -s Build/bin/rodent-root
strip -s Build/bin/rodent-anim
strip -s Build/bin/rodent

%clean
rm -rf $RPM_BUILD_ROOT
%if 0%{?suse_version} >= 1140
%post
%desktop_database_post
%endif

%if 0%{?suse_version} >= 1140
%postun
%desktop_database_postun
%endif


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir}
%if 0%{?suse_version} >= 1140
# create hardlinks for binaries
%fdupes %buildroot/%_bindir
%fdupes %buildroot/%_datadir
%fdupes %buildroot/%_mandir
%endif
rm -rf  %buildroot/%_libdir/rfm/modules/*.la
rm -rf  %buildroot/%_libdir/rfm/plugins/*.la



%find_lang %{name}

%files  -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README 
%{_mandir}/man1/rodent.1.gz
%{_mandir}/man1/rodent-fm.1.gz
%{_mandir}/man1/rodent-desk.1.gz
%{_mandir}/man1/rodent-getpass.1.gz
%{_mandir}/man1/rodent-plug.1.gz
%{_mandir}/man1/rodent-anim.1.gz
%{_mandir}/man1/rodent-root.1.gz
%{_datadir}/doc/rodent/RTFM.pdf
%{_datadir}/icons/rfm/48x48/apps/rodent.png
%{_datadir}/icons/rfm/48x48/apps/rodent-cifs.png
%{_datadir}/icons/rfm/48x48/apps/rodent-dotdesktop.png
%{_datadir}/icons/rfm/48x48/apps/rodent-ecryptfs.png
%{_datadir}/icons/rfm/48x48/apps/rodent-fstab.png
%{_datadir}/icons/rfm/48x48/apps/rodent-ftp.png
%{_datadir}/icons/rfm/48x48/apps/rodent-fuse.png
%{_datadir}/icons/rfm/48x48/apps/rodent-nfs.png
%{_datadir}/icons/rfm/48x48/apps/rodent-obex.png
%{_datadir}/icons/rfm/48x48/apps/rodent-ps.png
%{_datadir}/icons/rfm/48x48/apps/rodent-root.png
%{_datadir}/icons/rfm/48x48/apps/rodent-shares.png
%{_datadir}/icons/rfm/48x48/apps/rodent-smb.png
%{_datadir}/icons/rfm/48x48/apps/rodent-sshfs.png
%{_datadir}/icons/rfm/48x48/apps/rodent-workgroup.png
%{_datadir}/icons/rfm/animated/rodent-160.gif
%{_datadir}/icons/rfm/animated/rodent-96.gif
%{_datadir}/icons/rfm/animated/rodent_animate_logo.gif
%{_datadir}/icons/hicolor/scalable/apps/rodent.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-cifs.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-dotdesktop.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-ecryptfs.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-fstab.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-ftp.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-nfs.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-obex.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-ps.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-shares.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-smb.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-sshfs.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-workgroup.svg
%{_datadir}/icons/hicolor/scalable/apps/rodent-fuse.svg
# symlinks 
%{_datadir}/pixmaps/rodent.svg
%{_datadir}/pixmaps/rodent-cifs.svg
%{_datadir}/pixmaps/rodent-dotdesktop.svg
%{_datadir}/pixmaps/rodent-ecryptfs.svg
%{_datadir}/pixmaps/rodent-fstab.svg
%{_datadir}/pixmaps/rodent-ftp.svg
%{_datadir}/pixmaps/rodent-nfs.svg
%{_datadir}/pixmaps/rodent-obex.svg
%{_datadir}/pixmaps/rodent-ps.svg
%{_datadir}/pixmaps/rodent-shares.svg
%{_datadir}/pixmaps/rodent-smb.svg
%{_datadir}/pixmaps/rodent-sshfs.svg
%{_datadir}/pixmaps/rodent-workgroup.svg
%{_datadir}/pixmaps/rodent-fuse.svg

%{_bindir}/rodent
%{_bindir}/rodent-root
%{_bindir}/rodent-anim

%{_bindir}/rodent-fm
%{_bindir}/rodent-desk
%{_bindir}/rodent-plug
%{_bindir}/rodent-getpass

%{_datadir}/applications/Rodent.desktop
%{_datadir}/applications/Rodent-root.desktop
%{_datadir}/applications/Rodent-fstab.desktop
%{_datadir}/applications/Rodent-ps.desktop
%{_datadir}/applications/Rodent-dotdesktop.desktop

%{_datadir}/appdata/Rodent.appdata.xml
%{_libdir}/rfm/modules/libgridview.so
%{_libdir}/rfm/modules/libdeskview.so

%{_libdir}/rfm/plugins/libfstab.so
%{_libdir}/rfm/plugins/libecryptfs.so
%{_libdir}/rfm/plugins/libobex.so
%{_libdir}/rfm/plugins/libfuse.so
%{_libdir}/rfm/plugins/libdotdesktop.so
%{_libdir}/rfm/plugins/libps.so
%{_libdir}/rfm/plugins/libftp.so
%{_libdir}/rfm/plugins/libnfs.so
%{_libdir}/rfm/plugins/libsftp.so
%{_libdir}/rfm/plugins/libshares.so
%{_libdir}/rfm/plugins/libsmb.so
%{_libdir}/rfm/plugins/libcifs.so
%{_libdir}/rfm/plugins/libworkgroup.so



