#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program;  */

/*******************************************************************/
#if 0
static gboolean
signal_keyboard_event (
    GtkWidget * window,
    GdkEventKey * event,
    gpointer data
) {
    NOOP(stderr, ">> signal_keyboard_event: 0x%x\n", event->keyval);
    view_t *view_p = rodent_get_current_view (window);
    /* asian Input methods */
    if(event->keyval == GDK_KEY_space && (event->state & (GDK_MOD1_MASK | GDK_SHIFT_MASK))) {
        return FALSE;
    }

    if (rodent_do_callback(event->keyval, event->state)) return TRUE;

    return TRUE;

}
#endif

static view_t *
create_deskview (void) {
    view_t *view_p = rodent_new_view();

    rfm_global_t *rfm_global_p = rfm_global();

    view_p->flags.serial = 1;
    /* initializations: */

    view_p->widgets.view_p = view_p;

    /* exported functions: */
    view_p->constructor = NULL;
    view_p->child_constructor = child_constructor;


    gtk_widget_set_has_tooltip (rfm_global_p->window, TRUE);

    gtk_window_set_decorated ((GtkWindow *) rfm_global_p->window, FALSE);
    /* this doesn't do the trick with twm, so we'll just lower the window
       at the monitor step: Gdk-CRITICAL **: void IA__gdk_window_set_keep_below(GdkWindow *, gboolean): assertion `GDK_IS_WINDOW (window)*/
    //gdk_window_set_keep_below (gtk_widget_get_parent_window(rfm_global_p->window),TRUE); 
    view_p->flags.type = DESKVIEW_TYPE;
    gtk_window_set_title (GTK_WINDOW (rfm_global_p->window), "Rodent-desk");
#if 0
    view_p->widgets.scrolled_window = (GtkScrolledWindow *) gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (view_p->widgets.scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add (GTK_CONTAINER (rfm_global_p->window), GTK_WIDGET (view_p->widgets.scrolled_window));
    gtk_widget_show (GTK_WIDGET (view_p->widgets.scrolled_window));
#endif

    view_p->widgets.paper = gtk_drawing_area_new ();
    if(gtk_widget_get_double_buffered(view_p->widgets.paper))
        gtk_widget_set_double_buffered (view_p->widgets.paper, FALSE);
    gtk_widget_show (view_p->widgets.paper);

#if GTK_MAJOR_VERSION==2
    gtk_container_add (GTK_CONTAINER (rfm_global_p->window), GTK_WIDGET (view_p->widgets.paper));
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "expose-event", G_CALLBACK (rodent_expose), view_p);
#endif

#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION<10
    gtk_container_add (GTK_CONTAINER (rfm_global_p->window), GTK_WIDGET (view_p->widgets.paper));
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "draw", G_CALLBACK (rodent_draw), view_p);
#endif

#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>=10
    GtkWidget *viewport = gtk_viewport_new (NULL, NULL);
    gtk_container_add (GTK_CONTAINER (rfm_global_p->window), GTK_WIDGET (viewport));
    gtk_container_add (GTK_CONTAINER (viewport), GTK_WIDGET (view_p->widgets.paper));
    gtk_widget_show(viewport);
    gtk_widget_add_events (viewport,
                           GDK_POINTER_MOTION_MASK |
                           GDK_BUTTON_MOTION_MASK |
                           GDK_BUTTON_PRESS_MASK |
                           GDK_BUTTON_RELEASE_MASK |
                           GDK_ENTER_NOTIFY_MASK | 
			   GDK_LEAVE_NOTIFY_MASK | 
			   GDK_SCROLL_MASK | 
			   GDK_EXPOSURE_MASK);
    g_signal_connect (G_OBJECT (viewport), "draw", G_CALLBACK (signal_on_draw_vport), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "draw", G_CALLBACK (signal_on_draw_paper), view_p);
#endif

#if GTK_MAJOR_VERSION==2
#else 
#endif
    
    rfm_layout_set_root_parameters(view_p);
    gint width;
    gint height;
    rfm_layout_get_root_parameters(view_p, &width, &height, NULL);
    gtk_window_set_default_size ((GtkWindow *) rfm_global_p->window, width, height);
    do_atoms (view_p);

    gtk_widget_add_events (view_p->widgets.paper,
                           GDK_POINTER_MOTION_MASK |
                           GDK_BUTTON_MOTION_MASK |
                           GDK_BUTTON_PRESS_MASK |
                           GDK_BUTTON_RELEASE_MASK |
                           GDK_ENTER_NOTIFY_MASK | 
			   GDK_LEAVE_NOTIFY_MASK | 
			   GDK_SCROLL_MASK | 
			   GDK_EXPOSURE_MASK);

    //g_signal_connect (G_OBJECT (rfm_global_p->window), "key-press-event", G_CALLBACK (signal_keyboard_event), NULL);
    g_signal_connect (G_OBJECT (rfm_global_p->window), "query-tooltip", G_CALLBACK (rodent_tip_function), NULL);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "scroll-event", G_CALLBACK (scroll_cb), NULL);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "configure-event", G_CALLBACK (on_configure), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "size-allocate", G_CALLBACK (on_size), view_p);

//    g_signal_connect (G_OBJECT (view_p->widgets.paper), "configure-event", G_CALLBACK (rodent_expose), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-press-event", G_CALLBACK (rodent_signal_on_button_press), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "button-release-event", G_CALLBACK (rodent_signal_on_button_release), view_p);
    //g_signal_connect (G_OBJECT (view_p->widgets.paper), "enter-notify-event", G_CALLBACK (rodent_signal_on_enter), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "leave-notify-event", G_CALLBACK (signal_on_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "motion-notify-event", G_CALLBACK (rodent_signal_on_motion), view_p);

    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-received", G_CALLBACK (rodent_signal_drag_data), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-get", G_CALLBACK (rodent_signal_drag_data_get), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-motion", G_CALLBACK (rodent_signal_drag_motion), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-end", G_CALLBACK (rodent_signal_drag_end), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-begin", G_CALLBACK (rodent_signal_drag_begin), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-leave", G_CALLBACK (rodent_signal_drag_leave), view_p);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "drag-data-delete", G_CALLBACK (rodent_signal_drag_delete), view_p);
//    g_signal_connect(G_OBJECT(view_p->widgets.paper), "drag-drop",
//          G_CALLBACK(rodent_signal_drag_drop), view_p);

    g_signal_connect (G_OBJECT (rfm_global_p->window), "destroy_event", G_CALLBACK (destroy_event), view_p);
    g_signal_connect (G_OBJECT (rfm_global_p->window), "delete_event", G_CALLBACK (destroy_event), view_p);

    rodent_create_target_list (view_p);


    gtk_widget_show_all (rfm_global_p->window);
        
    //rodent_clean_paper (view_p);
    screen_set_selection (view_p);
    /* get around fvwm margins: */
    gtk_window_move ((GtkWindow *) (rfm_global_p->window), 0, 0);

#if 0
    /* Make the root window send events to me */
    gdk_window_set_user_data (GDK_ROOT_PARENT (), view_p->widgets.paper);
    XSelectInput (GDK_DISPLAY (), GDK_ROOT_WINDOW (), PropertyChangeMask);
    g_signal_connect (G_OBJECT (view_p->widgets.paper), "property-notify-event", G_CALLBACK (handle_property_notify), view_p);
#endif
    NOOP ("create_deskview done----------------------------\n");
    NOOP ("POP_SEM:  sem_init(&(view_p->population_sem),0,1)\n");
    rfm_set_widget(&(view_p->widgets), "widgets_p" );

    return view_p;
}


/*********************************************************************/
