/*
 * Created on 26-Feb-2008
 * Copyright (C) 2008 by Andrea Vacondio.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the 
 * GNU General Public License as published by the Free Software Foundation; 
 * either version 2 of the License.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 
 *  59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.pdfsam.guiclient.updates.checkers;

import org.pdfsam.guiclient.exceptions.CheckForUpdateException;
/**
 * Interface for the update checker
 * @author Andrea Vacondio
 *
 */
public interface UpdateChecker {

	/**
	 * @return the latest available version. Empty string if no version information is available
	 * @throws CheckForUpdateException if an error occur
	 */
	public String getLatestVersion() throws CheckForUpdateException;
}
