/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.model;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.Observable;
import net.sourceforge.lxmed.model.Category;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.persistence.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
extends Observable {
    protected List<Category> categories = Category.init();
    private static Model model;

    public static Model getModel() {
        if (model == null) {
            model = new Model();
        }
        return model;
    }

    private Model() {
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public boolean containsCategory(String categoryCode) {
        for (Category categorie : this.categories) {
            if (!categorie.getCodeName().trim().equals(categoryCode.trim())) continue;
            return true;
        }
        return false;
    }

    public Category getCategoryByCode(String categoryCode) {
        for (Category categorie : this.categories) {
            if (!categorie.getCodeName().trim().equals(categoryCode.trim())) continue;
            return categorie;
        }
        return null;
    }

    public void addMenuItem(MenuItem toBeAdded) throws FileNotFoundException {
        if (FileUtil.save(toBeAdded)) {
            this.fireStructureChanged();
        } else {
            Category c = toBeAdded.getCategory();
            toBeAdded.setCategory(null);
            c.remove(toBeAdded);
        }
    }

    public void updateMenuItem(MenuItem menuItem) throws FileNotFoundException {
        if (FileUtil.save(menuItem)) {
            this.fireStructureChanged();
        }
    }

    public void deleteMenuItem(MenuItem menuItem) {
        if (FileUtil.delete(menuItem)) {
            menuItem.setCategory(null);
            this.fireStructureChanged();
        }
    }

    private void fireStructureChanged() {
        this.setChanged();
        this.notifyObservers();
    }
}

