/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sourceforge.lxmed.LxmedException;
import net.sourceforge.lxmed.commands.CommandManager;
import net.sourceforge.lxmed.commands.EditItemCommand;
import net.sourceforge.lxmed.commands.NewItemCommand;
import net.sourceforge.lxmed.gui.CodeEditDialog;
import net.sourceforge.lxmed.gui.ImagePreview;
import net.sourceforge.lxmed.gui.MainFrame;
import net.sourceforge.lxmed.model.Category;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.model.Model;
import net.sourceforge.lxmed.persistence.FileUtil;
import net.sourceforge.lxmed.utils.Configuration;

public class MenuItemDialog
extends JDialog {
    protected MenuItem temporary;
    protected MenuItem menuItem = null;
    protected MenuItem originalItem = null;
    protected ComboBoxModel cbm;
    protected boolean newItem = false;
    protected Category defaultCategory;
    protected MainFrame parent;
    protected static String imageNotAvailable = "N/A";
    private JButton btnBrowseCommand;
    private JButton btnBrowseIcon;
    private JButton btnCancel;
    private JButton btnOk;
    private JButton btnViewCode;
    private JComboBox cbCategories;
    private JCheckBox cbVisible;
    private JLabel lblCategories;
    private JLabel lblCommand;
    private JLabel lblComment;
    private JLabel lblIcon;
    private JLabel lblImage;
    private JLabel lblName;
    private JLabel lblPath;
    private JPanel pnlCenter;
    private JPanel pnlControls;
    private JPanel pnlIcon;
    private JSeparator sepSouth;
    private JTextField txtCommand;
    private JTextField txtComment;
    private JTextField txtIcon;
    private JTextField txtName;
    private JTextField txtPath;

    public MenuItemDialog(Frame parent, MenuItem item) {
        super(parent, true);
        this.parent = (MainFrame)parent;
        this.menuItem = item;
        this.cbm = new DefaultComboBoxModel<Object>(Model.getModel().getCategories().toArray());
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setLocationRelativeTo(null);
        if (item == null) {
            this.newItem = true;
            this.cbVisible.setSelected(true);
            this.btnViewCode.setVisible(false);
            this.temporary = new MenuItem();
            this.menuItem = new MenuItem();
        } else {
            this.temporary = new MenuItem(item);
            try {
                this.originalItem = (MenuItem)item.clone();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MenuItemDialog.this.btnCancelActionPerformed(e);
            }
        });
        InputMap map = this.getRootPane().getInputMap(1);
        map.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    private void setFileChooserFont(Component[] comp) {
        for (int x = 0; x < comp.length; ++x) {
            if (comp[x] instanceof Container) {
                this.setFileChooserFont(((Container)comp[x]).getComponents());
            }
            try {
                comp[x].setFont(this.txtName.getFont());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    void updateGui() {
        if (!Configuration.IS_ROOT && this.menuItem.isReadOnly()) {
            this.txtName.setEditable(false);
            this.txtCommand.setEditable(false);
            this.txtComment.setEditable(false);
            this.txtIcon.setEditable(false);
            this.cbCategories.setEnabled(false);
            this.cbVisible.setEnabled(false);
            this.btnOk.setEnabled(false);
            this.btnOk.setText("Close");
            this.btnOk.setMnemonic('c');
            this.btnCancel.setEnabled(false);
            this.btnBrowseIcon.setEnabled(false);
            this.btnBrowseCommand.setEnabled(false);
        }
        this.txtPath.setText(this.temporary.getPath().getAbsolutePath());
        this.txtName.setText(this.temporary.getName());
        this.txtCommand.setText(this.temporary.getExec());
        this.txtComment.setText(this.temporary.getComment());
        this.txtIcon.setText(this.temporary.getIconStr());
        this.cbCategories.setSelectedItem(this.temporary.getCategory());
        this.cbVisible.setSelected(!this.temporary.isNoDisplay());
        this.updateImage();
    }

    private void readyForNew() {
        this.cbCategories.setSelectedItem(this.defaultCategory);
        this.txtPath.setText(Configuration.getAppsFolder());
        this.txtName.requestFocus();
    }

    private void checkBtnOk() {
        if (this.txtName.getText().trim().equals("") || this.txtCommand.getText().trim().equals("")) {
            this.btnOk.setEnabled(false);
        } else {
            this.btnOk.setEnabled(true);
        }
    }

    public MenuItem getMenuItem() {
        return this.temporary;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.temporary = menuItem;
    }

    private void processNewItem() {
        for (String key : this.temporary.getContent().keySet()) {
            this.menuItem.putToContentMap(key, this.temporary.getContent().get(key));
        }
        this.menuItem.setName(this.txtName.getText().trim());
        this.menuItem.setExec(this.txtCommand.getText().trim());
        this.menuItem.setComment(this.txtComment.getText().trim());
        this.menuItem.setIconStr(this.txtIcon.getText().trim());
        this.menuItem.setNoDisplay(!this.cbVisible.isSelected());
        this.menuItem.setCategory((Category)this.cbCategories.getSelectedItem());
        this.menuItem.setPath(new File(this.txtPath.getText().trim()));
        this.menuItem.setReadOnly(false);
        NewItemCommand newMenuItem = new NewItemCommand(this.menuItem);
        try {
            CommandManager.getInstance().addCommand(newMenuItem);
        }
        catch (LxmedException e) {
            Logger.getLogger(MenuItemDialog.class.getName()).log(Level.SEVERE, "New menu item error", e);
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error while saving item", 0);
        }
        this.parent = null;
        this.dispose();
    }

    private void processEditItem() {
        if (!this.menuItem.isReadOnly()) {
            for (String key : this.temporary.getContent().keySet()) {
                this.menuItem.putToContentMap(key, this.temporary.getContent().get(key));
            }
            this.menuItem.setName(this.txtName.getText().trim());
            this.menuItem.setExec(this.txtCommand.getText().trim());
            this.menuItem.setComment(this.txtComment.getText().trim());
            this.menuItem.setIconStr(this.txtIcon.getText().trim());
            this.menuItem.setNoDisplay(!this.cbVisible.isSelected());
            this.menuItem.setCategory((Category)this.cbCategories.getSelectedItem());
            this.menuItem.setPath(new File(this.txtPath.getText().trim()));
            this.menuItem.setReadOnly(false);
            EditItemCommand eic = new EditItemCommand(this.originalItem, this.menuItem);
            CommandManager.getInstance().addCommand(eic);
        }
        this.parent = null;
        this.dispose();
    }

    private void updateImage() {
        ImageIcon icon;
        BufferedImage image;
        try {
            image = ImageIO.read(new File(this.txtIcon.getText().trim()));
        }
        catch (IOException ex) {
            this.lblImage.setText(imageNotAvailable);
            this.lblImage.setIcon(null);
            return;
        }
        try {
            icon = new ImageIcon(image.getScaledInstance(59, 59, 16));
        }
        catch (NullPointerException npe) {
            this.lblImage.setText(imageNotAvailable);
            this.lblImage.setIcon(null);
            return;
        }
        if (icon != null) {
            this.lblImage.setText("");
            this.lblImage.setIcon(icon);
        }
    }

    private void initComponents() {
        this.pnlIcon = new JPanel();
        this.lblImage = new JLabel();
        this.pnlControls = new JPanel();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.sepSouth = new JSeparator();
        this.btnViewCode = new JButton();
        this.pnlCenter = new JPanel();
        this.lblPath = new JLabel();
        this.txtPath = new JTextField();
        this.lblCategories = new JLabel();
        this.cbCategories = new JComboBox();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblCommand = new JLabel();
        this.txtCommand = new JTextField();
        this.btnBrowseCommand = new JButton();
        this.lblComment = new JLabel();
        this.txtComment = new JTextField();
        this.lblIcon = new JLabel();
        this.txtIcon = new JTextField();
        this.btnBrowseIcon = new JButton();
        this.cbVisible = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                MenuItemDialog.this.formComponentShown(evt);
            }
        });
        this.pnlIcon.setFont(new Font("Dialog", 0, 11));
        this.pnlIcon.setLayout(new GridBagLayout());
        this.lblImage.setHorizontalAlignment(0);
        this.lblImage.setText("N/A");
        this.lblImage.setBorder(BorderFactory.createEtchedBorder(0));
        this.lblImage.setMaximumSize(new Dimension(64, 64));
        this.lblImage.setMinimumSize(new Dimension(64, 64));
        this.lblImage.setPreferredSize(new Dimension(64, 64));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlIcon.add((Component)this.lblImage, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlIcon, "West");
        this.pnlControls.setFont(new Font("Dialog", 0, 11));
        this.pnlControls.setLayout(new GridBagLayout());
        this.btnCancel.setFont(this.btnCancel.getFont().deriveFont(this.btnCancel.getFont().getStyle() & 0xFFFFFFFE, this.btnCancel.getFont().getSize() - 1));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/cancel.png")));
        this.btnCancel.setMnemonic('c');
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuItemDialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.pnlControls.add((Component)this.btnCancel, gridBagConstraints);
        this.btnOk.setFont(this.btnOk.getFont().deriveFont(this.btnOk.getFont().getStyle() & 0xFFFFFFFE, this.btnOk.getFont().getSize() - 1));
        this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/ok.png")));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuItemDialog.this.btnOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 17;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlControls.add((Component)this.btnOk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlControls.add((Component)this.sepSouth, gridBagConstraints);
        this.btnViewCode.setFont(this.btnViewCode.getFont().deriveFont(this.btnViewCode.getFont().getStyle() & 0xFFFFFFFE, this.btnViewCode.getFont().getSize() - 1));
        this.btnViewCode.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/properties.png")));
        this.btnViewCode.setMnemonic('e');
        this.btnViewCode.setText("Edit code manually");
        this.btnViewCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuItemDialog.this.btnViewCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlControls.add((Component)this.btnViewCode, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlControls, "South");
        this.pnlCenter.setFont(new Font("Dialog", 0, 11));
        this.lblPath.setFont(this.lblPath.getFont().deriveFont(this.lblPath.getFont().getStyle() & 0xFFFFFFFE, this.lblPath.getFont().getSize() - 1));
        this.lblPath.setText("Path:");
        this.txtPath.setEditable(false);
        this.txtPath.setFont(this.txtPath.getFont().deriveFont(this.txtPath.getFont().getStyle() & 0xFFFFFFFE, this.txtPath.getFont().getSize() - 1));
        this.lblCategories.setDisplayedMnemonic('a');
        this.lblCategories.setFont(this.lblCategories.getFont().deriveFont(this.lblCategories.getFont().getStyle() & 0xFFFFFFFE, this.lblCategories.getFont().getSize() - 1));
        this.lblCategories.setLabelFor(this.cbCategories);
        this.lblCategories.setText("Category:");
        this.cbCategories.setFont(this.cbCategories.getFont().deriveFont(this.cbCategories.getFont().getStyle() & 0xFFFFFFFE, this.cbCategories.getFont().getSize() - 1));
        this.cbCategories.setMaximumRowCount(15);
        this.cbCategories.setModel(this.cbm);
        this.lblName.setDisplayedMnemonic('n');
        this.lblName.setFont(this.lblName.getFont().deriveFont(this.lblName.getFont().getStyle() & 0xFFFFFFFE, this.lblName.getFont().getSize() - 1));
        this.lblName.setLabelFor(this.txtName);
        this.lblName.setText("Name:");
        this.txtName.setFont(this.txtName.getFont().deriveFont(this.txtName.getFont().getStyle() & 0xFFFFFFFE, this.txtName.getFont().getSize() - 1));
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                MenuItemDialog.this.txtNameKeyTyped(evt);
            }
        });
        this.lblCommand.setDisplayedMnemonic('d');
        this.lblCommand.setFont(this.lblCommand.getFont().deriveFont(this.lblCommand.getFont().getStyle() & 0xFFFFFFFE, this.lblCommand.getFont().getSize() - 1));
        this.lblCommand.setLabelFor(this.txtCommand);
        this.lblCommand.setText("Command:");
        this.txtCommand.setFont(this.txtCommand.getFont().deriveFont(this.txtCommand.getFont().getStyle() & 0xFFFFFFFE, this.txtCommand.getFont().getSize() - 1));
        this.txtCommand.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                MenuItemDialog.this.txtCommandKeyTyped(evt);
            }
        });
        this.btnBrowseCommand.setFont(this.btnBrowseCommand.getFont().deriveFont(this.btnBrowseCommand.getFont().getStyle() & 0xFFFFFFFE, this.btnBrowseCommand.getFont().getSize() - 1));
        this.btnBrowseCommand.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/browse.png")));
        this.btnBrowseCommand.setMnemonic('b');
        this.btnBrowseCommand.setText("Browse...");
        this.btnBrowseCommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuItemDialog.this.btnBrowseCommandActionPerformed(evt);
            }
        });
        this.lblComment.setDisplayedMnemonic('m');
        this.lblComment.setFont(this.lblComment.getFont().deriveFont(this.lblComment.getFont().getStyle() & 0xFFFFFFFE, this.lblComment.getFont().getSize() - 1));
        this.lblComment.setLabelFor(this.txtComment);
        this.lblComment.setText("Comment:");
        this.txtComment.setFont(this.txtComment.getFont().deriveFont(this.txtComment.getFont().getStyle() & 0xFFFFFFFE, this.txtComment.getFont().getSize() - 1));
        this.lblIcon.setDisplayedMnemonic('i');
        this.lblIcon.setFont(this.lblIcon.getFont().deriveFont(this.lblIcon.getFont().getStyle() & 0xFFFFFFFE, this.lblIcon.getFont().getSize() - 1));
        this.lblIcon.setLabelFor(this.txtIcon);
        this.lblIcon.setText("Icon:");
        this.txtIcon.setFont(this.txtIcon.getFont().deriveFont(this.txtIcon.getFont().getStyle() & 0xFFFFFFFE, this.txtIcon.getFont().getSize() - 1));
        this.txtIcon.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                MenuItemDialog.this.txtIconKeyTyped(evt);
            }
        });
        this.btnBrowseIcon.setFont(this.btnBrowseIcon.getFont().deriveFont(this.btnBrowseIcon.getFont().getStyle() & 0xFFFFFFFE, this.btnBrowseIcon.getFont().getSize() - 1));
        this.btnBrowseIcon.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/browse.png")));
        this.btnBrowseIcon.setMnemonic('r');
        this.btnBrowseIcon.setText("Browse...");
        this.btnBrowseIcon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MenuItemDialog.this.btnBrowseIconActionPerformed(evt);
            }
        });
        this.cbVisible.setFont(this.cbVisible.getFont().deriveFont(this.cbVisible.getFont().getStyle() & 0xFFFFFFFE, this.cbVisible.getFont().getSize() - 1));
        this.cbVisible.setMnemonic('v');
        this.cbVisible.setText("Visible");
        GroupLayout pnlCenterLayout = new GroupLayout(this.pnlCenter);
        this.pnlCenter.setLayout(pnlCenterLayout);
        pnlCenterLayout.setHorizontalGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCenterLayout.createSequentialGroup().addContainerGap().addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblPath).addComponent(this.lblIcon).addComponent(this.lblComment).addComponent(this.lblCommand).addComponent(this.lblName).addComponent(this.lblCategories)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbVisible).addComponent(this.txtName, -1, 388, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlCenterLayout.createSequentialGroup().addComponent(this.txtCommand, -1, 273, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseCommand)).addComponent(this.txtComment, -1, 388, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlCenterLayout.createSequentialGroup().addComponent(this.txtIcon, -1, 273, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseIcon)).addComponent(this.cbCategories, 0, 388, Short.MAX_VALUE).addComponent(this.txtPath, -1, 388, Short.MAX_VALUE)).addContainerGap()));
        pnlCenterLayout.setVerticalGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCenterLayout.createSequentialGroup().addContainerGap().addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPath).addComponent(this.txtPath, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCategories).addComponent(this.cbCategories, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblName).addComponent(this.txtName, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCommand).addComponent(this.txtCommand, -2, -1, -2).addComponent(this.btnBrowseCommand)).addGap(18, 18, 18).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblComment).addComponent(this.txtComment, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlCenterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblIcon).addComponent(this.txtIcon, -2, -1, -2).addComponent(this.btnBrowseIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbVisible).addContainerGap(28, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.pnlCenter, "Center");
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.parent = null;
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.newItem) {
            this.processNewItem();
        } else {
            this.processEditItem();
        }
    }

    private void txtNameKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MenuItemDialog.this.newItem) {
                    MenuItemDialog.this.txtPath.setText(Configuration.getAppsFolder() + "/" + FileUtil.getFileName(MenuItemDialog.this.txtName.getText().trim()));
                }
                MenuItemDialog.this.checkBtnOk();
            }
        });
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.newItem) {
            this.setTitle("Editing menu " + this.temporary.getName());
            if (this.temporary.isReadOnly()) {
                this.btnViewCode.setText("View original code");
            }
            this.updateGui();
        } else {
            this.setTitle("New menu item");
            this.readyForNew();
        }
        this.checkBtnOk();
    }

    private void btnBrowseCommandActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser("/usr/local/bin");
        this.setFileChooserFont(fc.getComponents());
        fc.setFileSelectionMode(2);
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return true;
            }

            public String getDescription() {
                return "All files [*.*]";
            }
        });
        fc.setAcceptAllFileFilterUsed(false);
        fc.setDialogTitle("Choose executive file for this item");
        int returnVal = fc.showDialog(this, "Ok");
        if (returnVal == 0) {
            this.txtCommand.setText(fc.getSelectedFile().getAbsolutePath());
            this.checkBtnOk();
        }
        fc.setSelectedFile(null);
        this.checkBtnOk();
    }

    private void btnBrowseIconActionPerformed(ActionEvent evt) {
        File f = new File(this.txtIcon.getText().trim()).getParentFile();
        if (f == null && !(f = new File("/usr/local/share/icons")).isDirectory()) {
            f = new File("/usr/share/icons");
        }
        JFileChooser fc = new JFileChooser(f);
        this.setFileChooserFont(fc.getComponents());
        fc.setFileSelectionMode(2);
        fc.setFileFilter(new FileNameExtensionFilter("Image files [*.png, *.jpg, *.gif, *.xpm, *.svg]", "png", "xpm", "svg", "jpg", "gif"));
        fc.setAccessory(new ImagePreview(fc));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setDialogTitle("Choose icon file for this item");
        int returnVal = fc.showDialog(this, "Ok");
        if (returnVal == 0) {
            this.txtIcon.setText(fc.getSelectedFile().getAbsolutePath());
            this.checkBtnOk();
        }
        fc.setSelectedFile(null);
        this.updateImage();
    }

    private void txtCommandKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MenuItemDialog.this.checkBtnOk();
            }
        });
    }

    private void btnViewCodeActionPerformed(ActionEvent evt) {
        new CodeEditDialog((Frame)this.getParent(), this.temporary, !this.temporary.isReadOnly(), this).setVisible(true);
    }

    private void txtIconKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MenuItemDialog.this.updateImage();
            }
        });
    }
}

