/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.lxmed.actions.ActionManager;
import net.sourceforge.lxmed.clipboard.LxmedClipboard;
import net.sourceforge.lxmed.commands.CommandManager;
import net.sourceforge.lxmed.commands.DeleteItemCommand;
import net.sourceforge.lxmed.gui.CategoriesListCellRenderer;
import net.sourceforge.lxmed.gui.MenuItemDialog;
import net.sourceforge.lxmed.gui.MenuItemsListCellRenderer;
import net.sourceforge.lxmed.model.Category;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.model.Model;
import net.sourceforge.lxmed.persistence.ModelLoader;

public class MainFrame
extends JFrame
implements Observer {
    protected DefaultListModel dlmItems = new DefaultListModel();
    protected DefaultListModel dlmCategories = new DefaultListModel();
    protected MenuItemsListCellRenderer menuItemsListCellRenderer = new MenuItemsListCellRenderer();
    protected CategoriesListCellRenderer categoriesListCellRenderer = new CategoriesListCellRenderer(Model.getModel().getCategories());
    protected ActionManager actionManager = ActionManager.getInstance();
    private static MainFrame instance;
    private JButton btnAbout;
    private JButton btnClose;
    private JButton btnCopy;
    private JButton btnCut;
    private JButton btnDelete;
    private JButton btnHelp;
    private JButton btnNewItem;
    private JButton btnPaste;
    private JButton btnProperties;
    private JButton btnRedo;
    private JButton btnUndo;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblCategories;
    private JLabel lblItems;
    private JLabel lblTitle;
    private JList lstCategories;
    private JList lstItems;
    private JPanel pnlCenter;
    private JPanel pnlControls;
    private JPanel pnlNorth;
    private JPanel pnlSouth;
    private JScrollPane spCategories;
    private JScrollPane spItems;
    private JSeparator sprSouth;
    private JSeparator sprTitle;

    public static MainFrame getInstance() {
        if (instance == null) {
            instance = new MainFrame();
        }
        return instance;
    }

    private MainFrame() {
        this.setPreferredSize(new Dimension(640, 450));
        for (Category categorie : Model.getModel().getCategories()) {
            this.dlmCategories.addElement(categorie);
        }
        this.initComponents();
        this.lstCategories.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        Image iconimage = new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/lxmed_small.png")).getImage();
        this.setIconImage(iconimage);
    }

    private void enableControls() {
        this.btnDelete.setEnabled(true);
        this.btnProperties.setEnabled(true);
    }

    private void disableControls() {
        this.btnDelete.setEnabled(false);
        this.btnProperties.setEnabled(false);
    }

    private void editItem() {
        MenuItem mi = (MenuItem)this.lstItems.getSelectedValue();
        if (mi == null) {
            return;
        }
        new MenuItemDialog((Frame)this, mi).setVisible(true);
        this.lstItems.requestFocus();
    }

    private void deleteItem() {
        int confirm;
        if (this.lstItems.getSelectedValue() == null) {
            return;
        }
        if (!((MenuItem)this.lstItems.getSelectedValue()).isReadOnly() && (confirm = JOptionPane.showConfirmDialog(this, "Really delete file? You can just make it invisible in properties dialog.", "Delete file?", 0)) == 0) {
            MenuItem toDelete = (MenuItem)this.lstItems.getSelectedValue();
            DeleteItemCommand dic = new DeleteItemCommand(toDelete);
            CommandManager.getInstance().addCommand(dic);
        }
    }

    public MenuItem getSelectedMenuItem() {
        return (MenuItem)this.lstItems.getSelectedValue();
    }

    public Category getSelectedCategory() {
        return (Category)this.lstCategories.getSelectedValue();
    }

    public void updateCategory() {
        this.dlmItems.clear();
        Category c = (Category)this.lstCategories.getSelectedValue();
        ModelLoader.sortItemsByName(c);
        for (MenuItem menuItem : c) {
            this.dlmItems.addElement(menuItem);
        }
        this.disableControls();
    }

    public JButton getBtnRedo() {
        return this.btnRedo;
    }

    public JButton getBtnUndo() {
        return this.btnUndo;
    }

    public void update(Observable o, Object arg) {
        this.updateCategory();
    }

    public void updateCliboardButtons() {
        MenuItem selected = this.getSelectedMenuItem();
        this.btnCut.setEnabled(selected != null && !selected.isReadOnly());
        this.btnCopy.setEnabled(selected != null);
        this.btnPaste.setEnabled(!LxmedClipboard.getClipboard().isEmpty());
    }

    private void processClipboardKeys(KeyEvent evt) {
        if (evt.isControlDown()) {
            int key = evt.getKeyCode();
            switch (key) {
                case 88: {
                    this.actionManager.getCutAction().actionPerformed(null);
                    break;
                }
                case 67: {
                    this.actionManager.getCopyAction().actionPerformed(null);
                    break;
                }
                case 86: {
                    this.actionManager.getPasteAction().actionPerformed(null);
                    break;
                }
                case 90: {
                    CommandManager.getInstance().undoCommand();
                    break;
                }
                case 89: {
                    CommandManager.getInstance().doCommand();
                }
            }
        }
    }

    private void initComponents() {
        this.pnlSouth = new JPanel();
        this.btnHelp = new JButton();
        this.btnAbout = new JButton();
        this.btnClose = new JButton();
        this.sprSouth = new JSeparator();
        this.pnlNorth = new JPanel();
        this.lblTitle = new JLabel();
        this.sprTitle = new JSeparator();
        this.pnlCenter = new JPanel();
        this.lblCategories = new JLabel();
        this.spCategories = new JScrollPane();
        this.lstCategories = new JList();
        this.spItems = new JScrollPane();
        this.lstItems = new JList();
        this.lblItems = new JLabel();
        this.pnlControls = new JPanel();
        this.btnNewItem = new JButton();
        this.btnProperties = new JButton();
        this.btnDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.btnUndo = new JButton();
        this.btnRedo = new JButton();
        this.jSeparator2 = new JSeparator();
        this.btnCut = new JButton();
        this.btnCopy = new JButton();
        this.btnPaste = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("LXDE Main Menu Editor");
        this.pnlSouth.setLayout(new GridBagLayout());
        this.btnHelp.setFont(this.btnHelp.getFont().deriveFont(this.btnHelp.getFont().getStyle() & 0xFFFFFFFE, this.btnHelp.getFont().getSize() - 1));
        this.btnHelp.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/help.png")));
        this.btnHelp.setMnemonic('h');
        this.btnHelp.setText("Help");
        this.btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnHelpActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlSouth.add((Component)this.btnHelp, gridBagConstraints);
        this.btnAbout.setFont(this.btnAbout.getFont().deriveFont(this.btnAbout.getFont().getStyle() & 0xFFFFFFFE, this.btnAbout.getFont().getSize() - 1));
        this.btnAbout.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/about.png")));
        this.btnAbout.setMnemonic('b');
        this.btnAbout.setText("About");
        this.btnAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnAboutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.pnlSouth.add((Component)this.btnAbout, gridBagConstraints);
        this.btnClose.setFont(this.btnClose.getFont().deriveFont(this.btnClose.getFont().getStyle() & 0xFFFFFFFE, this.btnClose.getFont().getSize() - 1));
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/exit.png")));
        this.btnClose.setMnemonic('s');
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlSouth.add((Component)this.btnClose, gridBagConstraints);
        this.sprSouth.setForeground(new Color(0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.pnlSouth.add((Component)this.sprSouth, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlSouth, "South");
        this.pnlNorth.setLayout(new GridBagLayout());
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1, this.lblTitle.getFont().getSize() - 1));
        this.lblTitle.setText("Configure main menu:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(7, 10, 7, 10);
        this.pnlNorth.add((Component)this.lblTitle, gridBagConstraints);
        this.sprTitle.setForeground(new Color(0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlNorth.add((Component)this.sprTitle, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlNorth, "North");
        this.pnlCenter.setLayout(new GridBagLayout());
        this.lblCategories.setDisplayedMnemonic('a');
        this.lblCategories.setFont(this.lblCategories.getFont().deriveFont(this.lblCategories.getFont().getStyle() & 0xFFFFFFFE, this.lblCategories.getFont().getSize() - 1));
        this.lblCategories.setLabelFor(this.lstCategories);
        this.lblCategories.setText("Categories:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.pnlCenter.add((Component)this.lblCategories, gridBagConstraints);
        this.lstCategories.setFont(this.lstCategories.getFont().deriveFont(this.lstCategories.getFont().getStyle() & 0xFFFFFFFE, this.lstCategories.getFont().getSize() - 1));
        this.lstCategories.setModel(this.dlmCategories);
        this.lstCategories.setSelectionMode(0);
        this.lstCategories.setCellRenderer(this.categoriesListCellRenderer);
        this.lstCategories.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.lstCategoriesMouseClicked(evt);
            }
        });
        this.lstCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainFrame.this.lstCategoriesValueChanged(evt);
            }
        });
        this.lstCategories.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MainFrame.this.lstCategoriesKeyReleased(evt);
            }
        });
        this.spCategories.setViewportView(this.lstCategories);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 165;
        gridBagConstraints.ipady = 275;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.pnlCenter.add((Component)this.spCategories, gridBagConstraints);
        this.lstItems.setFont(this.lstItems.getFont().deriveFont(this.lstItems.getFont().getStyle() & 0xFFFFFFFE, this.lstItems.getFont().getSize() - 1));
        this.lstItems.setModel(this.dlmItems);
        this.lstItems.setSelectionMode(0);
        this.lstItems.setCellRenderer(this.menuItemsListCellRenderer);
        this.lstItems.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.lstItemsMouseClicked(evt);
            }
        });
        this.lstItems.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MainFrame.this.lstItemsValueChanged(evt);
            }
        });
        this.lstItems.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                MainFrame.this.lstItemsKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                MainFrame.this.lstItemsKeyReleased(evt);
            }
        });
        this.spItems.setViewportView(this.lstItems);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 264;
        gridBagConstraints.ipady = 275;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 12, 1);
        this.pnlCenter.add((Component)this.spItems, gridBagConstraints);
        this.lblItems.setDisplayedMnemonic('t');
        this.lblItems.setFont(this.lblItems.getFont().deriveFont(this.lblItems.getFont().getStyle() & 0xFFFFFFFE, this.lblItems.getFont().getSize() - 1));
        this.lblItems.setLabelFor(this.lstItems);
        this.lblItems.setText("Menu Items:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 10, 0, 0);
        this.pnlCenter.add((Component)this.lblItems, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlCenter, "Center");
        this.pnlControls.setLayout(new GridBagLayout());
        this.btnNewItem.setFont(this.btnNewItem.getFont().deriveFont(this.btnNewItem.getFont().getStyle() & 0xFFFFFFFE, this.btnNewItem.getFont().getSize() - 1));
        this.btnNewItem.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/new.png")));
        this.btnNewItem.setMnemonic('n');
        this.btnNewItem.setText("New Item");
        this.btnNewItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnNewItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(31, 10, 5, 10);
        this.pnlControls.add((Component)this.btnNewItem, gridBagConstraints);
        this.btnProperties.setFont(this.btnProperties.getFont().deriveFont(this.btnProperties.getFont().getStyle() & 0xFFFFFFFE, this.btnProperties.getFont().getSize() - 1));
        this.btnProperties.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/properties.png")));
        this.btnProperties.setMnemonic('r');
        this.btnProperties.setText("Properties");
        this.btnProperties.setEnabled(false);
        this.btnProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnPropertiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnProperties, gridBagConstraints);
        this.btnDelete.setFont(this.btnDelete.getFont().deriveFont(this.btnDelete.getFont().getStyle() & 0xFFFFFFFE, this.btnDelete.getFont().getSize() - 1));
        this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/delete.png")));
        this.btnDelete.setMnemonic('d');
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.pnlControls.add((Component)this.jSeparator1, gridBagConstraints);
        this.btnUndo.setFont(new Font("Dialog", 0, 11));
        this.btnUndo.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/edit-undo.png")));
        this.btnUndo.setMnemonic('u');
        this.btnUndo.setText("Undo");
        this.btnUndo.setEnabled(false);
        this.btnUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnUndoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnUndo, gridBagConstraints);
        this.btnRedo.setFont(new Font("Dialog", 0, 11));
        this.btnRedo.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/edit-redo.png")));
        this.btnRedo.setMnemonic('e');
        this.btnRedo.setText("Redo");
        this.btnRedo.setEnabled(false);
        this.btnRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnRedoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnRedo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        this.pnlControls.add((Component)this.jSeparator2, gridBagConstraints);
        this.btnCut.setFont(new Font("Dialog", 0, 11));
        this.btnCut.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/edit-cut.png")));
        this.btnCut.setMnemonic('c');
        this.btnCut.setText("Cut");
        this.btnCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnCut, gridBagConstraints);
        this.btnCopy.setFont(new Font("Dialog", 0, 11));
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/edit-copy.png")));
        this.btnCopy.setMnemonic('y');
        this.btnCopy.setText("Copy");
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnCopyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnCopy, gridBagConstraints);
        this.btnPaste.setFont(new Font("Dialog", 0, 11));
        this.btnPaste.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/edit-paste.png")));
        this.btnPaste.setMnemonic('p');
        this.btnPaste.setText("Paste");
        this.btnPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnPasteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.pnlControls.add((Component)this.btnPaste, gridBagConstraints);
        this.getContentPane().add((Component)this.pnlControls, "East");
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnHelpActionPerformed(ActionEvent evt) {
        try {
            Runtime.getRuntime().exec("firefox http://lxmed.sourceforge.net/help.html");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error while launching firefox browser. Visit http://lxmed.sourceforge.net/help.html for help", "Error", 0);
        }
    }

    private void btnAboutActionPerformed(ActionEvent evt) {
        String msg = "LXDE Main Menu Editor 20120515-beta\n\n";
        msg = msg + "Copyleft 2011. HEEM-BA-SHOU\n";
        JOptionPane.showMessageDialog(this, msg, "About", 1);
    }

    private void btnNewItemActionPerformed(ActionEvent evt) {
        MenuItemDialog mid = new MenuItemDialog((Frame)this, null);
        mid.setDefaultCategory((Category)this.lstCategories.getSelectedValue());
        mid.setVisible(true);
    }

    private void btnPropertiesActionPerformed(ActionEvent evt) {
        this.editItem();
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        this.deleteItem();
    }

    private void lstCategoriesValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.updateCategory();
        this.updateCliboardButtons();
    }

    private void lstItemsValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.updateCliboardButtons();
        MenuItem mi = (MenuItem)this.lstItems.getSelectedValue();
        if (mi == null) {
            this.disableControls();
            return;
        }
        if (mi.isReadOnly()) {
            this.btnProperties.setEnabled(true);
            this.btnDelete.setEnabled(false);
            return;
        }
        this.enableControls();
    }

    private void lstItemsMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.lstItems.setSelectedIndex(this.lstItems.locationToIndex(evt.getPoint()));
            MenuItem mi = (MenuItem)this.lstItems.getSelectedValue();
            JPopupMenu popupMenu = new JPopupMenu();
            if (mi.isReadOnly()) {
                this.actionManager.getCutAction().setEnabled(false);
            } else {
                this.actionManager.getCutAction().setEnabled(true);
            }
            popupMenu.add(this.actionManager.getCutAction());
            popupMenu.add(this.actionManager.getCopyAction());
            popupMenu.show(this.lstItems, evt.getX(), evt.getY());
        } else if (evt.getClickCount() == 2) {
            this.editItem();
        }
    }

    private void lstItemsKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                this.editItem();
                break;
            }
            case 127: {
                this.deleteItem();
            }
        }
    }

    private void lstCategoriesMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.lstCategories.setSelectedIndex(this.lstCategories.locationToIndex(evt.getPoint()));
            JPopupMenu popupMenu = new JPopupMenu();
            this.actionManager.getPasteAction().setEnabled(!LxmedClipboard.getClipboard().isEmpty());
            popupMenu.add(this.actionManager.getPasteAction());
            popupMenu.show(this.lstCategories, evt.getX(), evt.getY());
        }
    }

    private void lstCategoriesKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 525) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this.actionManager.getPasteAction());
            JList source = (JList)evt.getSource();
            popupMenu.show(source, 5, 5);
        } else {
            this.processClipboardKeys(evt);
        }
    }

    private void lstItemsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 525) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this.actionManager.getCutAction());
            popupMenu.add(this.actionManager.getCopyAction());
            JList source = (JList)evt.getSource();
            popupMenu.show(source, 5, 5);
        } else {
            this.processClipboardKeys(evt);
        }
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
        CommandManager.getInstance().undoCommand();
    }

    private void btnRedoActionPerformed(ActionEvent evt) {
        CommandManager.getInstance().doCommand();
    }

    private void btnCutActionPerformed(ActionEvent evt) {
        this.actionManager.getCutAction().actionPerformed(null);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        this.actionManager.getCopyAction().actionPerformed(null);
    }

    private void btnPasteActionPerformed(ActionEvent evt) {
        this.actionManager.getPasteAction().actionPerformed(null);
    }
}

