/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import net.sourceforge.lxmed.gui.MenuItemDialog;
import net.sourceforge.lxmed.model.MenuItem;
import net.sourceforge.lxmed.persistence.ModelLoader;

public class CodeEditDialog
extends JDialog {
    private MenuItem mi;
    private MenuItemDialog mid;
    boolean editable = true;
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel lblTitle;
    private JScrollPane spCode;
    private JTextArea txtCode;

    public CodeEditDialog(Frame parent, MenuItem mi, boolean editable, MenuItemDialog mid) {
        super(parent, true);
        this.mi = mi;
        this.editable = editable;
        this.mid = mid;
        this.setTitle("Original desktop code");
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.lblTitle.setText("Original code for " + mi.getName());
        this.txtCode.setText(mi.getDesktopCode());
        if (!editable) {
            this.setReadOnly();
        }
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CodeEditDialog.this.btnCancelActionPerformed(e);
            }
        });
        InputMap map = this.getRootPane().getInputMap(1);
        map.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    private void setReadOnly() {
        this.txtCode.setEditable(false);
        this.btnCancel.setVisible(false);
        this.btnOk.setText("Close");
        this.btnOk.setMnemonic('c');
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.spCode = new JScrollPane();
        this.txtCode = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.lblTitle.setDisplayedMnemonic('r');
        this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(this.lblTitle.getFont().getStyle() | 1, this.lblTitle.getFont().getSize() - 1));
        this.lblTitle.setText("lblTitle");
        this.btnOk.setFont(this.btnOk.getFont().deriveFont(this.btnOk.getFont().getStyle() & 0xFFFFFFFE, this.btnOk.getFont().getSize() - 1));
        this.btnOk.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/ok.png")));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CodeEditDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancel.setFont(this.btnCancel.getFont().deriveFont(this.btnCancel.getFont().getStyle() & 0xFFFFFFFE, this.btnCancel.getFont().getSize() - 1));
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/net/sourceforge/lxmed/images/dialogs/cancel.png")));
        this.btnCancel.setMnemonic('c');
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CodeEditDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.txtCode.setColumns(20);
        this.txtCode.setFont(new Font("Monospaced", 0, 13));
        this.txtCode.setRows(5);
        this.spCode.setViewportView(this.txtCode);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spCode, -1, 576, Short.MAX_VALUE).addComponent(this.lblTitle).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 392, Short.MAX_VALUE).addComponent(this.btnOk))).addContainerGap()));
        layout.linkSize(0, this.btnCancel, this.btnOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addGap(18, 18, 18).addComponent(this.spCode, -1, 266, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (!this.editable) {
            this.mid = null;
            this.dispose();
            return;
        }
        MenuItem newMenuItem = ModelLoader.loadData(this.txtCode.getText());
        newMenuItem.setReadOnly(false);
        this.mid.getMenuItem().cloneData(newMenuItem);
        this.mid.updateGui();
        this.mid = null;
        this.dispose();
    }
}

