/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lxmed.commands;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import net.sourceforge.lxmed.LxmedException;
import net.sourceforge.lxmed.commands.LxmedCommand;
import net.sourceforge.lxmed.gui.MainFrame;

public class CommandManager {
    private List<LxmedCommand> commands = new ArrayList<LxmedCommand>();
    private int currentCommand = 0;
    private static CommandManager instance;

    private CommandManager() {
    }

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    public void addCommand(LxmedCommand command) throws LxmedException {
        while (this.currentCommand < this.commands.size()) {
            this.commands.remove(this.currentCommand);
        }
        this.commands.add(command);
        this.doCommand();
    }

    public void doCommand() {
        if (this.currentCommand < this.commands.size()) {
            this.commands.get(this.currentCommand++).doCommand();
            this.refreshButtons();
        }
    }

    public void undoCommand() {
        if (this.currentCommand > 0) {
            this.commands.get(--this.currentCommand).undoCommand();
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        JButton undo = MainFrame.getInstance().getBtnUndo();
        JButton redo = MainFrame.getInstance().getBtnRedo();
        if (this.commands.isEmpty()) {
            undo.setEnabled(false);
            redo.setEnabled(false);
        } else if (this.currentCommand == this.commands.size()) {
            undo.setEnabled(true);
            redo.setEnabled(false);
        } else if (this.currentCommand == 0) {
            undo.setEnabled(false);
            redo.setEnabled(true);
        } else {
            undo.setEnabled(true);
            redo.setEnabled(true);
        }
    }
}

