.\" t
.\" @(#)FvwmTaskBar.1	6/30/96
.TH FvwmTaskBar 2.6 "June 30th, 1996"
.UC
.SH NAME
FvwmTaskBar \- the FVWM taskbar module - with plugins
.SH SYNOPSIS
FvwmTaskBar is spawned by FVWM, so no command line invocation will work.

.SH DESCRIPTION
The FvwmTaskBar module provides a taskbar made up of buttons arranged by
rows, each corresponding to a window that FVWM is managing.
Clicking on first button gives focus to the corresponding toplevel window;
clicking on the middle button will hide a toplevel window; third mouse button
is reserved for a future extension (context menu).
Like the other modules, FvwmTaskBar only works when fvwm is used as the
window manager. 

When started, the taskbar shows up as a single row of buttons filling the
full width of the screen, but during the work can be resized to accomodate
up to 8 rows. In adition, if the AutoStick option is used, the taskbar
will autoposition itself at the top or bottom of the screen, and can be
dragged from one position to another with a normal move operation. 

The first button of the taskbar, labelled "Start" sends a "Popup
StartMenu" command to the FVWM, which can be used to pop-up a
general-purpose menu when the button is pressed. 

The FvwmTaskBar also displays at the right side a window showing the
current time and the built-in incoming mail indicator. 

.SH COPYRIGHTS
The FvwmTaskBar module is derivated from Mike Finger's FvwmWinList.

Copyright 1994, Mike Finger. The author makes no guarantees or warranties of
any kind about the use of this module.  Use this modules at your own risk.
You may freely use this module or any portion of it for any purpose as long
as the copyright is kept intact. 

.SH INITIALIZATION
During initialization, \fIFvwmTaskBar\fP will scan the same configuration
file that FVWM used during startup to find the options that pertain to it. 
These options are discussed in a later section. 

.SH INVOCATION
FvwmTaskBar can be invoked by fvwm during initialization by inserting the
line 'Module FvwmTaskBar' in the .fvwmrc file. 

FvwmTaskBar must reside in a directory that is listed in the ModulePath 
option of FVWM for it to be executed by FVWM.

.SH CONFIGURATION OPTIONS
The following options can be placed in the .fvwm95rc file

.IP "*FvwmTaskBarGeometry \fI{+-}<X>x{+-}<Y>\fP"
Specifies the location and gravity of the FvwmTaskBar window.  At the
current version, size is not supported and the taskbar will resize itself
to fill the full witdh of the screen. If the AutoStick option is also
specified, the module will automatically "stick" to the top or the bottom
of the screen, whichever is closest to the geometry specification. 

.IP "*FvwmTaskBarFont \fIfont\fP"
Specifies the default font to be used for labeling the buttons, when they 
are not depressed. If not specified, fixed font is assumed.

.IP "*FvwmTaskBarSelFont \fIfont\fP"
Specifies the font to be used for the depressed buttons. Note that the 
Start button will use always this font even if is not pressed. If this 
option is not specified, the default font is used instead.

.IP "*FvwmTaskBarStatusFont \fIfont\fP"
Specifies the font to be used for the clock and tip windows. If this 
option is not specified, fixed font is used.

.IP "*FvwmTaskBarFore \fIcolor\fP"
Specifies the color to use for the button names.

.IP "*FvwmTaskBarBack \fIcolor\fP"
Specifies the background color for the bar and buttons.

.IP "*FvwmTaskBarTipsFore \fIcolor\fP"
Specifies the color to be used for the text in the tips windows.

.IP "*FvwmTaskBarTipsBack \fIcolor\fP"
Specifies the background color for the tips windows.

.IP "*FvwmTaskBarGeometry \fIgeometry\fP"
This option specifies the geometry of the window (only the Y coordinate is
useful)

.IP "*FvwmTaskBarAutoStick"
This option causes the taskbar to "stick" either to the top or bottom 
of the screen, whichever is closest to the initial window placement. Any 
further move operation is also subject to that behaviour.

.IP "*FvwmTaskBarAutoHide"
This option causes the taskbar to disappear leaving a narrow strip at the
bottom of the screen, and reappears only when the mouse is moved to that
strip. This option automatically enables AutoStick.

.IP "*FvwmTaskBarUseSkipList"
Tells FvwmTaskBar to not show the windows that are listed on a WindowListSkip
line in the configuration file.

.IP "*FvwmTaskBarDeskOnly"
Tells FvwmTaskBar to show the windows that are only on the current desktop.  
When desktops are switched, the list of windows changes accordingly.

.IP "*FvwmTaskBarUseIconNames"
Tells FvwmTaskBar to use the icon name of the window instead of the full 
window name.  This is useful to keep the width of the buttons small.

.IP "*FvwmTaskBarShowTransients"
Tells FvwmTaskBar to show the application transient windows also. By default
they are not shown.

.IP "*FvwmTaskBarAction \fIaction response[,response...]\fP"
Tells FvwmTaskBar to do \fIresponse\fP when \fIaction\fP is done.  The
currently supported \fIaction\fPs are: Click1, Click2, Click3.  The currently
supported \fIresponse\fPs are any fvwm built-in commands, including modules
and functions.
The configuration example below shows the default values.

.IP "*FvwmTaskBarButtonWidth \fIwidth\fP"
Indicates the maximum width that window buttons should reach.
(the minimum is hardcoded at 32).

.IP "*FvwmTaskBarHighlightFocus"
If the mouse pointer is over the taskbar, the window under the current 
button is active. This behavior is like the TVTWM Icon Manager or 
FvwmIconMan. \fINote:\fP If you use this option combined with FollowMouse 
focus style, you'll want the taskbar to be ClickToFocus.

.IP "*FvwmTaskBarShowTips"
Enables the tips windows (by default disabled).

.IP "*FvwmTaskBarMaxTipLines \fI[num]\fP"
This controls the maximum number of lines allowed in a multi-line tip window.  
The first [num] are displayed, and if more than [num] lines are in the tip text,
the last line will read "(more...)" to indicate it.  The default for this is 30

.IP "*FvwmTaskBarUpdateInterval \fIseconds\fP"
Specifies how often the clock display should be refreshed, so that times of 
the form HH:MM:SS can be used. By default 60 seconds.



.SH ""
The following options deal with the Start button at the left of the taskbar:

.IP "*FvwmTaskBarStartName \fIstring\fP"
This option specifies the string displayed in the Start button.
('Start' by default).

.IP "*FvwmTaskBarStartMenu \fIstring\fP"
This option specifies the popup to invoke when the start button is pressed.
('StartMenu' by default). The module send a 'Popup StartMenu' command to
the fvwm window manager.

.IP "*FvwmTaskBarStartIcon \fIicon-name\fP"
This option specifies the name of the icon to display at the left of the Start
button.



.SH ""
The following options deal with the goodies and modules of the taskbar:

  
.IP "*FvwmTaskBarGoodyLoadablePlugins \fIdirectory\fP"
Specifies a directory to search for plugins. After each occurence of this command
FvwmTaskBar scans the directory for files with ".so" at the end and attempts to 
load them. The default is "/usr/local/lib/X11/fvwm95"
   
.IP "*FvwmTaskBarGoodyLoadableQuiet"
Tells FvwmTaskBar to skip information about loaded modules. This 
information is extremely useful in determining if FvwmTaskBar loads them
at all. However once you got a stable configuration you may want to omit it.

.IP "*FvwmTaskBarGoodyLoadableSymbol \fISymbol\fP"
Create a new goody. Symbol is the name of struct GoodyLoadable in one
of the modules. Note that you can use the same module more than once
and you don't have to know which module has this symbol.
  
.IP "*FvwmTaskBarGoodyLoadableId \fIid\fP"
"Id" is an arbitrary character string passed to the initialization routine
of the module. The idea is that since the module can be used more the
once we need a mean to distinguish between strings in .fvwmrc corresponding
to different goodies. It's recommended not to use dots,spaces or empty 
strings..

.IP "*FvwmTaskBarGoodyModuleIcon<id> \fImini-icon name\fP"
Specifies which mini-icon should be inserted in the taskbar for goody <id>.
Default path is "\fIIconPath\fP" .

.IP "*FvwmTaskBarGoodyModuleTip.<id> \fItip\fP"
Sets the tip for goody <Id>
  
.IP "*FvwmTaskBarGoodyModuleCommand<id> \fIcommand\fP"
Sets the command to be executed when double-clicking on goody <id>'s icon.

.SH ""
   \fIDate Module: ShowDateModule\fP

.IP "*FvwmTaskBarShowDateModuleClockFormat<id> \fIformat-string\fP"
This option specifies the time format for the digital clock.
It is a \fIstfrtime(3)\fP compatible format string (see the manual
page of the 'date' command)
By default it is "%R". 

.IP "*FvwmTaskBarShowDateModuleHourlyCommand<id> \fIcommand\fP"
Specifies a command to be executed every hour.

.SH ""
   \fIMail Module: MailCheckModule\fP

.IP "*FvwmTaskBarMailCheckModuleNewMailCommand<id> \fIcommand\fP"
Specifies which command is to be executed when new mail arrives.

.IP "*FvwmTaskBarMailCheckModuleAutoMailTip<id> \fI[type]\fP"
This option controls the auto-display of new mail in a multi-line tip window.
Three possible values are allowed for the optional type argument:
Mail-FileTouched, MailFileBigger, or MailFileAnyChange.
MailFileTouched means the mail spool file has been modified since the last
access, MailFileBigger is when the mail spool file gets larger in size, and
Mail-FileAnyChang is when the mail spool file gets larger or smaller.   
These  conditions control when the AutoMailTip  window is displayed.  
The default is Mail-FileAnyChange.

.IP "*FvwmTaskBarMailCheckModuleMailTipFormat.MAIL \fI[l] [if] [wf] [is] [ws]\fP"
This options allows specification of how to display the mail information in 
the tip.  [l] can be either 1 for a single line per mail message, or 2 for a
double line format where the From: info appears on one line, and the
Subject: appears on the next line.  [if] is the number of spaces to indent 
the From: info, and [wf] is the max width. [is] and [ws] are the indent and width
of the Subject: info. The default is 1 0 20 2 30.

.IP "*FvwmTaskBarMailCheckModuleMailTipNoSmartFrom"
If set, this flag shuts off the automatic name extraction for the From: field.
The format seen in email is largely formatted by convention, and this allows
this process to be shut off when it does not work.
The smart name extraction algorithm works as follows.  Step 1:
all substrings delimited by <> and [] are removed, since they usually contain an email address.  If nothing is left, this step is reversed.  Step 2:
if any string delimited by "" or () is found, it is used as the smart name.  
Otherwise the result from Step 1 is used at the result. For most email I
have, this results in nicely formatted names.

.IP "*FvwmTaskBarMailCheckModuleMailTipUnblankScreen<id>"
If set, the screen will be un-blanked when the mail tip is drawn.

.IP "*FvwmTaskBarShowDateModuleHourlyCommand<id> \fIcommand\fP"
Executes the command every hour.

.SH ""
   \fIModem Module: CheckLockModule\fP

.IP "*FvwmTaskBarCheckLockModuleIcon<id> \fImini-icon name\fP"
Specifies which mini-icon should be inserted in the taskbar when the
modem is active.
Default path is "\fIIconPath\fP" .

.IP "*FvwmTaskBarCheckLockModuleTip<id> \fItip\fP"

.IP "*FvwmTaskBarCheckLockModuleCommand<id> \fIcommand\fP"
Specifies which command is to be executed when you double-click
on the icon.

.IP "*FvwmTaskBarCheckLockModuleLockFile<id> \fIfilename\fP"
Specifies which file is your modem's lock file.


.SH SAMPLE CONFIGURATION
The following are excepts from a \fI.fvwm95rc\fP file which describe FvwmTaskBar
initialization commands:

.nf
.sp
#
# Start the taskbar on fvwm startup and restart
#

AddToFunc "InitFunction" "I" Module FvwmTaskBar

AddToFunc "RestartFunction" "I" Module FvwmTaskBar

#
# Set the style for the taskbar window, keep always on top of another
# windows
#


Style "FvwmTaskBar" NoTitle,BorderWidth 4,HandleWidth 4,Sticky,\\
                    StaysOnTop,WindowListSkip,CirculateSkip

*FvwmTaskBarGeometry +0-0
*FvwmTaskBarFore Black
*FvwmTaskBarBack #c0c0c0
*FvwmTaskBarFont -adobe-helvetica-medium-r-*-*-*-120-*-*-*-*-*-*
*FvwmTaskBarSelFont -adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*
*FvwmTaskBarStatusFont fixed
*FvwmTaskBarTipsFore black
*FvwmTaskBarTipsBack bisque
*FvwmTaskBarAction Click1 Iconify -1,Raise,Focus
*FvwmTaskBarAction Click2 Iconify
*FvwmTaskBarAction Click3 PopUp Window-Ops2
*FvwmTaskBarUseSkipList
*FvwmTaskBarAutoStick
*FvwmTaskBarStartName Start
*FvwmTaskBarStartMenu StartMenu
*FvwmTaskBarStartIcon mini-penguin.xpm
*FvwmTaskBarShowTips
*FvwmTaskBarShowTransients
*FvwmTaskBarHighlightFocus
*FvwmTaskBarAutoHide
*FvwmTaskBarDeskOnly
*FvwmTaskBarMaxTipLines 5


# Now the goodies....

*FvwmTaskBarGoodyLoadablePlugins /usr/local/lib/X11/fvwm95/
*FvwmTaskBarGoodyLoadableQuiet

# Modem
*FvwmTaskBarGoodyLoadableSymbol CheckLockModuleSymbol
*FvwmTaskBarGoodyLoadableId .Modem
*FvwmTaskBarCheckLockModuleIcon.Modem mini-connect.xpm
*FvwmTaskBarCheckLockModuleTip.Modem Modem is in use
*FvwmTaskBarCheckLockModuleCommand.Modem Popup Network
*FvwmTaskBarCheckLockModuleLockFile.Modem /var/lock/LCK..modem

# Sound mixer
*FvwmTaskBarGoodyLoadableSymbol GoodyModuleSymbol
*FvwmTaskBarGoodyLoadableId .SPEAKER
*FvwmTaskBarGoodyModuleIcon.SPEAKER mini-speaker.xpm
*FvwmTaskBarGoodyModuleTip.SPEAKER Audio Control Panel
*FvwmTaskBarGoodyModuleCommand.SPEAKER Exec OXmixer

# Date
*FvwmTaskBarGoodyLoadableSymbol ShowDateModuleSymbol
*FvwmTaskBarGoodyLoadableId .DATE
*FvwmTaskBarShowDateModuleTip.DATE Date
*FvwmTaskBarShowDateModuleCommand.DATE Exec xmessage `date` 
*FvwmTaskBarShowDateModuleClockFormat.DATE %H:%M 
#*FvwmTaskBarShowDateModuleHourlyCommand.DATE exec xmessage hourly command

# Mail
*FvwmTaskBarGoodyLoadableSymbol MailCheckModuleSymbol
*FvwmTaskBarGoodyLoadableId .MAIL
*FvwmTaskBarMailCheckModuleMailIcon.MAIL mini-mail.xpm
*FvwmTaskBarMailCheckModuleCommand.MAIL Exec xterm -T Mail -e mail
*FvwmTaskBarMailCheckModuleNewMailIcon.MAIL mini-newmail.xpm
*FvwmTaskBarMailCheckModuleNewMailTip.MAIL You have new mail
#*FvwmTaskBarMailCheckModuleNewMailCommand.MAIL beep
*FvwmTaskBarMailCheckModuleUnreadMailIcon.MAIL mini-unreadmail.xpm
*FvwmTaskBarMailCheckModuleMailFile.MAIL /var/spool/mail/$USER
*FvwmTaskBarMailCheckModuleAutoMailTip.MAIL
#*FvwmTaskBarMailCheckModuleMailTipUnblankScreen.MAIL
*FvwmTaskBarMailCheckModuleMailTipFormat.MAIL 1 0 10 2 10

.sp
.fi
.SH BUGS
At present the \fIFvwmTaskBar\fP works only with \fIfvwm95\fP.

.SH AUTHOR
David Barth (barth@di.epfl.ch)
Modules and plugins by  Volodya Dergachev
and  Michael D. Beynon (beynon@acm.org)
