/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

public class StyledRectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public StyledRectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StyledRectangle)) {
            return false;
        }
        StyledRectangle styledRectangle = (StyledRectangle)object;
        return styledRectangle.x == this.x && styledRectangle.y == this.y && styledRectangle.width == this.width && styledRectangle.height == this.height;
    }

    public int hashCode() {
        return this.x + this.y + this.width + this.height;
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    private boolean noEmpty(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return n + n2 > n3;
        }
        return n3 + n4 > n;
    }

    public boolean hit(StyledRectangle styledRectangle) {
        if (!this.noEmpty(styledRectangle.x, styledRectangle.width, this.x, this.width)) {
            return false;
        }
        return this.noEmpty(styledRectangle.y, styledRectangle.height, this.y, this.height);
    }

    public void add(StyledRectangle styledRectangle) {
        if (styledRectangle.x < this.x) {
            this.width += this.x - styledRectangle.x;
            this.x = styledRectangle.x;
        }
        if (styledRectangle.y < this.y) {
            this.height += this.y - styledRectangle.y;
            this.y = styledRectangle.y;
        }
        if (styledRectangle.width > this.width) {
            this.width = styledRectangle.width;
        }
        if (styledRectangle.height > this.height) {
            this.height = styledRectangle.height;
        }
    }

    public String toString() {
        return "StyledRectangle : " + this.x + "," + this.y + "," + this.width + "," + this.height;
    }
}

