/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.FileTextProvider;
import irc.IRCConfiguration;
import irc.ParameterProvider;
import irc.StringParser;
import irc.TextProvider;
import irc.gui.pixx.PixxColorModel;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Color;
import java.util.Locale;
import java.util.Vector;

public class PixxConfigurationLoader {
    private IRCConfiguration _config;
    private ParameterProvider _provider;

    public PixxConfigurationLoader(IRCConfiguration iRCConfiguration) {
        this._config = iRCConfiguration;
        this._provider = this._config.getInterfaceParameterProvider();
    }

    public PixxConfiguration loadPixxConfiguration() throws Exception {
        return this.getPixxConfiguration();
    }

    private String getParameter(String string) {
        return this._provider.getParameter(string);
    }

    private boolean getBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return (string2 = string2.toLowerCase(Locale.ENGLISH).trim()).equals("true") || string2.equals("on") || string2.equals("1");
    }

    private String getString(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private int getInt(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private TextProvider getTextProvider() {
        String string = this.getString("language", "gui-english");
        String string2 = this.getString("languageencoding", "");
        String string3 = this.getString("lngextension", "lng");
        String string4 = this.getString("backuplanguage", "pixx-english");
        String string5 = this.getString("backuplanguageencoding", "");
        return new FileTextProvider(string + "." + string3, string2, string4 + "." + string3, string5, this._config.getFileHandler());
    }

    private String[] getArray(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        do {
            if ((string2 = this.getParameter(string + n)) != null) {
                vector.insertElementAt(string2, vector.size());
            }
            ++n;
        } while (string2 != null);
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void readDocking(PixxConfiguration pixxConfiguration) {
        StringParser stringParser = new StringParser();
        String[] stringArray = this.getArray("dockingconfig");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = stringParser.parseString(string);
            if (stringArray2.length < 3) continue;
            String string2 = stringArray2[0].toLowerCase(Locale.ENGLISH);
            String string3 = stringArray2[1].toLowerCase(Locale.ENGLISH);
            String string4 = stringArray2[2].toLowerCase(Locale.ENGLISH);
            boolean bl = false;
            if (string4.equals("undock")) {
                bl = true;
            }
            pixxConfiguration.setDockingPolicy(string2, string3, bl);
        }
    }

    private void readMouse(PixxConfiguration pixxConfiguration, String string, int n, int n2) throws Exception {
        String string2 = this.getString("mouse" + string.toLowerCase(Locale.ENGLISH), n + " " + n2);
        int n3 = string2.indexOf(32);
        if (n3 < 0) {
            throw new Exception("mouse" + string.toLowerCase(Locale.ENGLISH) + " parameter syntax error");
        }
        String string3 = string2.substring(0, n3).trim();
        String string4 = string2.substring(n3 + 1).trim();
        pixxConfiguration.setMouseConfiguration(string, new Integer(string3), new Integer(string4));
    }

    private String[] getHighLightWords() {
        String string = this.getParameter("highlightwords");
        if (string == null) {
            return new String[0];
        }
        return new StringParser().parseString(string);
    }

    private void add(Vector vector, Object object) {
        vector.insertElementAt(object, vector.size());
    }

    public void loadDefaultPopup(PixxConfiguration pixxConfiguration) {
        Vector vector = pixxConfiguration.getNickMenuVector();
        this.add(vector, new String[]{"Private Message", "/query %1"});
        this.add(vector, new String[]{"--"});
        this.add(vector, new String[]{"Ignore", "/ignore %1"});
        this.add(vector, new String[]{"Unignore", "/unignore %1"});
        this.add(vector, new String[]{"--"});
        this.add(vector, new String[]{"Host", "/mode %2 +o %1"});
        this.add(vector, new String[]{"Participant", "/mode %2 +v %1"});
        this.add(vector, new String[]{"Spectator", "/mode %2 -qaohv %1 %1 %1 %1 %1"});
        this.add(vector, new String[]{"--"});
        this.add(vector, new String[]{"Kick User", "/kick %2 %1 Disruptive Behavior"});
        this.add(vector, new String[]{"Ban User", "/mode %2 +b %1!*@*", "/kick %2 %1 Disruptive Behavior [Access Ban]"});
        this.add(vector, new String[]{"--"});
        this.add(vector, new String[]{"Local Time", "/CTCP TIME %1"});
    }

    private void readPopup(PixxConfiguration pixxConfiguration) {
        if (!this.getBoolean("configurepopup", false)) {
            this.loadDefaultPopup(pixxConfiguration);
            return;
        }
        Vector vector = pixxConfiguration.getNickMenuVector();
        String[] stringArray = this.getArray("popupmenustring");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getArray("popupmenucommand" + (i + 1) + "_");
            String[] stringArray3 = new String[1 + stringArray2.length];
            stringArray3[0] = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray3[j + 1] = stringArray2[j];
            }
            this.add(vector, stringArray3);
        }
    }

    private PixxColorModel getColorModel() {
        PixxColorModel pixxColorModel = new PixxColorModel();
        for (int i = 0; i < pixxColorModel.getColorCount(); ++i) {
            String string = this.getParameter("color" + i);
            try {
                if (string == null) continue;
                pixxColorModel.setColor(i, new Color(Integer.parseInt(string, 16)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pixxColorModel;
    }

    private PixxConfiguration getPixxConfiguration() throws Exception {
        PixxConfiguration pixxConfiguration = new PixxConfiguration(this._config);
        pixxConfiguration.setTextProvider(this.getTextProvider());
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getHighLightWords();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.insertElementAt(stringArray[i], vector.size());
        }
        pixxConfiguration.setHighLightConfig(this.getInt("highlightcolor", 5), this.getBoolean("highlightnick", false), vector);
        pixxConfiguration.set("highlight", this.getBoolean("highlight", false));
        pixxConfiguration.set("timestamp", this.getBoolean("timestamp", false));
        pixxConfiguration.set("showclose", this.getBoolean("showclose", true));
        pixxConfiguration.set("showconnect", this.getBoolean("showconnect", true));
        pixxConfiguration.set("showchanlist", this.getBoolean("showchanlist", true));
        pixxConfiguration.set("showabout", this.getBoolean("showabout", false));
        pixxConfiguration.set("showhelp", this.getBoolean("showhelp", false));
        pixxConfiguration.set("nicklistwidth", this.getInt("nicklistwidth", 150));
        pixxConfiguration.set("nickfield", this.getBoolean("nickfield", false));
        pixxConfiguration.set("showstatus", this.getBoolean("showstatus", true));
        pixxConfiguration.set("styleselector", this.getBoolean("styleselector", true));
        pixxConfiguration.set("setfontonstyle", this.getBoolean("setfontonstyle", false));
        pixxConfiguration.set("helppage", this.getString("helppage", "http://www.frostwire.com/chat/help"));
        pixxConfiguration.set("showchannelnickchanged", this.getBoolean("showchannelnickchanged", false));
        pixxConfiguration.set("showchannelnickmodeapply", this.getBoolean("showchannelnickmodeapply", false));
        pixxConfiguration.set("showchannelmodeapply", this.getBoolean("showchannelmodeapply", false));
        pixxConfiguration.set("showchanneltopicchanged", this.getBoolean("showchanneltopicchanged", true));
        pixxConfiguration.set("showchannelnickquit", this.getBoolean("showchannelnickquit", true));
        pixxConfiguration.set("showchannelnickkick", this.getBoolean("showchannelnickkick", true));
        pixxConfiguration.set("showchannelnickpart", this.getBoolean("showchannelnickpart", true));
        pixxConfiguration.set("showchannelnickjoin", this.getBoolean("showchannelnickjoin", true));
        pixxConfiguration.set("showdock", this.getBoolean("showdock", false));
        pixxConfiguration.set("prefixops", this.getBoolean("prefixops", true));
        pixxConfiguration.set("automaticqueries", this.getBoolean("automaticqueries", true));
        pixxConfiguration.set("leftnickalign", this.getBoolean("leftnickalign", false));
        pixxConfiguration.set("taskbaritemwidth", this.getInt("taskbaritemwidth", 100));
        pixxConfiguration.set("scrollspeed", this.getInt("scrollspeed", 0));
        pixxConfiguration.set("leaveonundockedwindowclose", this.getBoolean("leaveonundockedwindowclose", true));
        pixxConfiguration.set("showchannelyoujoin", this.getBoolean("showchannelyoujoin", false));
        pixxConfiguration.set("displayentertexthere", this.getBoolean("displayentertexthere", false));
        pixxConfiguration.set("ignoreallmouseevents", this.getBoolean("ignoreallmouseevents", false));
        pixxConfiguration.set("hideundockedsources", this.getBoolean("hideundockedsources", true));
        pixxConfiguration.set("displaychannelname", this.getBoolean("displaychannelname", false));
        pixxConfiguration.set("displaychannelmode", this.getBoolean("displaychannelmode", false));
        pixxConfiguration.set("displaychannelcount", this.getBoolean("displaychannelcount", true));
        pixxConfiguration.set("displaychanneltopic", this.getBoolean("displaychanneltopic", false));
        pixxConfiguration.setColorModel(this.getColorModel());
        this.readMouse(pixxConfiguration, "nickquery", 1, 2);
        this.readMouse(pixxConfiguration, "urlopen", 1, 2);
        this.readMouse(pixxConfiguration, "channeljoin", 1, 2);
        this.readMouse(pixxConfiguration, "nickpopup", 3, 1);
        this.readMouse(pixxConfiguration, "taskbarpopup", 3, 1);
        this.readPopup(pixxConfiguration);
        this.readDocking(pixxConfiguration);
        return pixxConfiguration;
    }
}

