/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.Channel;
import irc.ChannelListener2;
import irc.ModeHandler;
import irc.Source;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.NickMenuHandler;
import irc.gui.pixx.NickNameComparator;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.ScrollablePixxNickList;
import irc.style.StyledList;
import irc.tree.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class AWTChannel
extends BaseAWTSource
implements ChannelListener2,
PixxNickListListener {
    private ScrollablePixxNickList _nicks;
    private Label _label;
    private SortedList _sortedList;
    private Hashtable _modeMapping;
    private NickMenuHandler _menu;

    public AWTChannel(PixxConfiguration pixxConfiguration, Channel channel) {
        super(pixxConfiguration, channel);
        this._menu = new NickMenuHandler(pixxConfiguration, this, channel);
        this._nicks = new ScrollablePixxNickList(this._pixxConfiguration, channel.getIRCServer().getNickPrefixes());
        channel.addChannelListener2(this);
        this._nicks.addPixxNickListListener(this);
        this._sortedList = new SortedList(new NickNameComparator(channel.getIRCServer().getNickPrefixes()));
        this._modeMapping = new Hashtable();
        this._label = new Label("");
        this._label.setBackground(this._pixxConfiguration.getColor(6));
        this._label.setForeground(this._pixxConfiguration.getColor(1));
        if (this._pixxConfiguration.getIRCConfiguration().getB("asl")) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this._nicks, "Center");
            Panel panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel2.add((Component)new PixxSeparator(2), "West");
            panel2.add((Component)new PixxSeparator(3), "East");
            panel2.add((Component)new PixxSeparator(0), "North");
            panel2.add((Component)new PixxSeparator(1), "South");
            panel2.add((Component)this._label, "Center");
            panel.add((Component)panel2, "South");
            this.add((Component)panel, "East");
        } else {
            this.add((Component)this._nicks, "East");
        }
        this.doLayout();
        this.title();
        this.print("  Please wait, joining chat room...", 3);
        this.print("  Connected!", 4);
        this.print("  Welcome to FrostWire Chat! FrostWire does not control or endorse the content, messages or information found in this chat. FrostWire specifically disclaims any liability with regard to these areas. To review the FrostWire Chat guidelines, go to \u000312\u001fhttp://www.frostwire.com/chat/conduct\u001f\u0003", 1);
        this.print("");
        if (this._pixxConfiguration.getB("showchannelyoujoin")) {
            this.print("      *** Now chatting in room " + channel.getName() + " as " + channel.getServer().getNick() + ".", 3);
            this.print("");
        }
    }

    public void release() {
        this._menu.release();
        ((Channel)this._source).removeChannelListener2(this);
        this._nicks.removePixxNickListListener(this);
        this._nicks.release();
        this._menu = null;
        super.release();
    }

    public void doLayout() {
        this._label.setText("");
        super.doLayout();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this._nicks.dispose();
        }
    }

    public void messageReceived(String string, String string2, Source source) {
        this.checkSound(string2);
        String string3 = (String)this._modeMapping.get(string);
        if (string3 != null && !string3.equals(string)) {
            if (string3.startsWith("~")) {
                string = "\u00034" + string + "\u0003";
            } else if (string3.startsWith("&")) {
                string = "\u00034" + string + "\u0003";
            } else if (string3.startsWith("@")) {
                string = "\u000312" + string + "\u0003";
            } else if (string3.startsWith("%")) {
                string = "\u000312" + string + "\u0003";
            } else if (string3.startsWith("+")) {
                string = "\u000310" + string + "\u0003";
            }
        }
        super.messageReceived(string, string2, source);
    }

    private String getFullModeNick(String string, String string2) {
        Channel channel = (Channel)this.getSource();
        char[] cArray = channel.getIRCServer().getNickPrefixes();
        char[] cArray2 = channel.getIRCServer().getNickModes();
        char[][] cArray3 = channel.getIRCServer().getChannelModes();
        ModeHandler modeHandler = new ModeHandler(string2, cArray3, cArray2);
        for (int i = 0; i < cArray2.length; ++i) {
            if (!modeHandler.hasMode(cArray2[i])) continue;
            return cArray[i] + string;
        }
        return string;
    }

    private String getUnprefixedNick(String string) {
        if (string.length() == 0) {
            return string;
        }
        Channel channel = (Channel)this.getSource();
        char[] cArray = channel.getIRCServer().getNickPrefixes();
        for (int i = 0; i < cArray.length; ++i) {
            if (string.charAt(0) != cArray[i]) continue;
            return string.substring(1);
        }
        return string;
    }

    private void setNicks(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNick(stringArray[i]);
        }
    }

    private void addNick(String string) {
        String string2 = ((Channel)this._source).getNickMode(string);
        if (string2 != null) {
            String string3 = this.getFullModeNick(string, string2);
            this._sortedList.add(string3);
            this._modeMapping.put(string, string3);
        }
    }

    private void removeNick(String string) {
        String string2 = (String)this._modeMapping.get(string);
        if (string2 != null) {
            this._sortedList.remove(string2);
            this._modeMapping.remove(string);
        }
    }

    private void updateNick(String string) {
        this.removeNick(string);
        this.addNick(string);
    }

    private void update() {
        String string;
        String[] stringArray = new String[this._modeMapping.size()];
        Enumeration enumeration = this._modeMapping.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        this._textField.setCompleteList(stringArray);
        stringArray = new String[this._modeMapping.size()];
        enumeration = this._modeMapping.keys();
        n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringArray[n++] = string + ":" + ((Channel)this._source).whois(this.getUnprefixedNick(string));
        }
        this._list.setNickList(stringArray);
        stringArray = new String[this._sortedList.getSize()];
        enumeration = this._sortedList.getItems();
        n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = ((Channel)this._source).whois(this.getUnprefixedNick(string));
            stringArray[n++] = string + ":" + string2;
        }
        this._nicks.set(stringArray);
        this.title();
    }

    public synchronized void nickSet(String[] stringArray, String[] stringArray2, Channel channel) {
        this.setNicks(stringArray);
        this.update();
    }

    public synchronized void nickReset(Channel channel) {
        this._sortedList.clear();
        this._modeMapping.clear();
        this._nicks.removeAll();
        this.update();
    }

    public synchronized void nickJoin(String string, String string2, Channel channel) {
        this.addNick(string);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + string + " has joined the conversation.", 14);
        }
    }

    public synchronized void nickPart(String string, String string2, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + string + " has left the conversation.", 14);
        }
    }

    public synchronized void nickKick(String string, String string2, String string3, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickkick")) {
            if (string.equals(this._source.getServer().getNick())) {
                this.print("\u0002 You have been kicked out of the chat room by Host " + string2 + ": " + string3, 4);
                this._nicks.removeAll();
                this.kicktitle();
            } else if (string3.length() > 0) {
                this.print("\u0002 Host " + string2 + " kicked " + string + " out of the chat room" + ": " + string3, 4);
            } else {
                this.print("\u0002 Host " + string2 + " kicked " + string + " out of the chat room.", 4);
            }
        }
    }

    public synchronized void nickQuit(String string, String string2, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._sortedList.getSize() <= 100) {
            this.print("      *** " + string + " has left the conversation.", 14);
        }
    }

    private void title() {
        int n = this._sortedList.getSize();
        String string = " Welcome to FrostWire Live Chat!";
        if (this._pixxConfiguration.getB("displaychannelcount")) {
            if (this._sortedList.getSize() == 1) {
                string = string + " There is " + n + " person chatting in " + this._source.getName() + ".";
            } else if (this._sortedList.getSize() <= 0) {
                string = string + " There is nobody chatting in " + this._source.getName() + ".";
            } else if (this._sortedList.getSize() >= 2) {
                string = string + " There are " + n + " people chatting in " + this._source.getName() + ".";
            }
        }
        if (this._pixxConfiguration.getB("displaychannelname")) {
            string = string + " Chat Room: " + this._source.getName();
        }
        if (this._pixxConfiguration.getB("displaychannelmode")) {
            string = string + " Room Modes: " + ((Channel)this._source).getMode();
        }
        if (this._pixxConfiguration.getB("displaychanneltopic")) {
            string = string.length() != 0 ? string + ": " + ((Channel)this._source).getTopic() : ((Channel)this._source).getTopic();
        }
        this.setTitle(string.trim());
    }

    private void kicktitle() {
        String string = " You were kicked out of the chat room.";
        this.setTitle(string.trim());
    }

    public synchronized void topicChanged(String string, String string2, Channel channel) {
        if (this._pixxConfiguration.getB("showchanneltopicchanged")) {
            if (string2.length() == 0) {
                this.print("\u000310 The chat's topic is: \u0003" + string);
                this.print("");
            } else {
                this.print("\u000310 The chat's topic has changed to: \u0003" + string);
            }
            this.title();
        }
    }

    public synchronized void modeApply(String string, String string2, Channel channel) {
        if (string2.length() > 0) {
            if (string.equals("+X")) {
                this.print("      *** " + channel + " is now an official room.", 14);
            } else if (string.equals("+G")) {
                this.print("      *** This room is now Rated G for all audiences.", 14);
            }
        }
        this.title();
    }

    public synchronized void nickModeApply(String string, String string2, String string3, Channel channel) {
        if (!string.equals(this._source.getServer().getNick())) {
            if (string2.equals("+q")) {
                this.print("      *** " + string3 + " has made " + string + " an Owner.", 14);
            } else if (string2.equals("+a")) {
                this.print("      *** " + string3 + " has made " + string + " an Admin.", 14);
            } else if (string2.equals("+o")) {
                this.print("      *** " + string3 + " has made " + string + " a Host.", 14);
            } else if (string2.equals("+h")) {
                this.print("      *** " + string3 + " has made " + string + " a Helper.", 14);
            } else if (string2.equals("-v")) {
                this.print("      *** " + string3 + " has made " + string + " a Spectator.", 14);
            }
        } else if (string.equals(this._source.getServer().getNick())) {
            if (string2.equals("+q")) {
                this.print("      *** " + string3 + " has made you an Owner.", 3);
            } else if (string2.equals("+a")) {
                this.print("      *** " + string3 + " has made you an Admin.", 3);
            } else if (string2.equals("+o")) {
                this.print("      *** " + string3 + " has made you a Host.", 3);
            } else if (string2.equals("+h")) {
                this.print("      *** " + string3 + " has made you a Helper.", 3);
            } else if (string2.equals("+v")) {
                this.print("      *** " + string3 + " has made you a Participant.", 3);
            } else if (string2.equals("-v")) {
                this.print("      *** " + string3 + " has made you a Spectator.", 3);
            }
        }
        this.updateNick(string);
        this.update();
    }

    public synchronized void nickChanged(String string, String string2, Channel channel) {
        if (!string2.equals(this._source.getServer().getNick())) {
            this.print("      *** " + string + " is now known as " + string2 + ".", 14);
        }
        this.removeNick(string);
        this.addNick(string2);
        this.update();
    }

    public void nickWhoisUpdated(String string, String string2, Channel channel) {
        this.update();
    }

    public void eventOccured(String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, ((Channel)this._source).whois(string), this._nicks, mouseEvent.getX(), mouseEvent.getY());
        } else if (this._pixxConfiguration.matchMouseConfiguration("nickquery", mouseEvent) && this._pixxConfiguration.getB("automaticqueries") && !string.equals(this._source.getServer().getNick())) {
            this._source.sendString("/focus Query " + string);
            this._source.sendString("/query " + string);
        }
    }

    public void ASLEventOccured(String string, String string2) {
        this._label.setText(this._pixxConfiguration.getIRCConfiguration().formatASL(string2));
    }

    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, ((Channel)this._source).whois(string), this._list, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.nickEvent(styledList, string, mouseEvent);
        }
    }
}

