/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.IRCConfiguration;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.ServerManager;
import irc.Source;
import java.util.Date;
import java.util.Locale;

public class CTCPInterpretor
extends BasicInterpretor {
    protected ServerManager _mgr;

    public CTCPInterpretor(IRCConfiguration iRCConfiguration, Interpretor interpretor, ServerManager serverManager) {
        super(iRCConfiguration, interpretor);
        this._mgr = serverManager;
    }

    private void send(Server server, String string, String string2) {
        server.say(string, "\u0001" + string2 + "\u0001");
    }

    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        try {
            if (string.equals("ctcp")) {
                this.test(string, stringArray, 1);
                if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("ping")) {
                    this.test(string, stringArray, 2);
                    this.send(source.getServer(), stringArray[2], "PING " + new Date().getTime());
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("action")) {
                    this.test(string, stringArray, 2);
                    if (source.talkable()) {
                        this.send(source.getServer(), source.getName(), "ACTION " + stringArray2[2]);
                        source.action(source.getServer().getNick(), stringArray2[2]);
                    } else {
                        source.report(" *** Your message cannot be sent.");
                    }
                } else if (stringArray[1].toLowerCase(Locale.ENGLISH).equals("raw")) {
                    this.test(string, stringArray, 3);
                    this.send(source.getServer(), stringArray[2], stringArray2[3]);
                } else {
                    this.test(string, stringArray, 2);
                    this.send(source.getServer(), stringArray[2], stringArray[1]);
                }
            } else {
                super.handleCommand(source, string, stringArray, stringArray2);
            }
        }
        catch (NotEnoughParametersException notEnoughParametersException) {
            source.report(" *** Invalid command format: " + notEnoughParametersException.getMessage());
        }
    }
}

