/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Provider;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;
import org.limewire.util.RPNParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLDocument
implements RPNParser.StringLookup {
    private static final Log LOG = LogFactory.getLog(LimeXMLDocument.class);
    private static final String XML_ID_ATTRIBUTE = "identifier__";
    private static final String XML_ACTION_ATTRIBUTE = "action__";
    private static final String XML_ACTION_INFO = "addactiondetail__";
    static final String XML_INDEX_ATTRIBUTE = "index__";
    private static final String XML_LICENSE_ATTRIBUTE = "license__";
    private static final String XML_LICENSE_TYPE_ATTRIBUTE = "licensetype__";
    private static final String VERSION_STRING = "internal_version";
    private static final String XML_VERSION_ATTRIBUTE = "internal_version__";
    public static final List<LimeXMLDocument> EMPTY_LIST = Collections.emptyList();
    private static final int CURRENT_VERSION = 3;
    private volatile int hashCode = 0;
    private Map<String, String> fieldToValue = new HashMap<String, String>();
    private String schemaUri;
    private String attributeString;
    private File fileId;
    private String action;
    private String actionDetail;
    private volatile int version;
    private List<String> CACHED_KEYWORDS = null;
    private volatile LicenseType licenseType = LicenseType.NO_LICENSE;
    private final LicenseFactory licenseFactory;
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    LimeXMLDocument(String string, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> provider) throws SAXException, SchemaNotFoundException, IOException {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = provider;
        if (string == null || string.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        XMLParsingUtils.ParseResult parseResult = XMLParsingUtils.parse(inputSource);
        if (parseResult.isEmpty()) {
            throw new IOException("No element present");
        }
        if (parseResult.schemaURI == null) {
            throw new SchemaNotFoundException("no schema");
        }
        this.fieldToValue = (Map)parseResult.get(0);
        this.schemaUri = parseResult.schemaURI;
        this.setFields(parseResult.canonicalKeyPrefix);
        if (!this.isValid()) {
            throw new IOException("Invalid XML: " + string + ", fieldToValue: " + this.fieldToValue + ", attrString: " + this.getAttributeString() + ", schemaURI: " + this.schemaUri);
        }
    }

    LimeXMLDocument(Map<String, String> map, String string, String string2, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> provider) throws IOException {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = provider;
        if (map.isEmpty()) {
            throw new IllegalArgumentException("empty map");
        }
        this.schemaUri = string;
        this.fieldToValue = map;
        this.fieldToValue.remove(string2 + XML_ID_ATTRIBUTE);
        this.setFields(string2);
        if (!this.isValid()) {
            throw new IOException("invalid doc! " + map + " \nschema uri: " + string);
        }
    }

    LimeXMLDocument(Collection<? extends Map.Entry<String, String>> collection, String string, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> provider) {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = provider;
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        this.schemaUri = string;
        for (Map.Entry<String, String> entry : collection) {
            this.fieldToValue.put(entry.getKey().trim(), entry.getValue());
        }
        this.scanFields();
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid Doc!  nameValueList: " + collection + ", schema: " + string + ", attributeStrings: " + this.getAttributeString() + ", schemaFields: " + (this.getSchema() != null ? Arrays.asList(this.getSchema().getCanonicalizedFieldNames()) : "n/a"));
        }
    }

    boolean isValid() {
        if (this.schemaUri == null || this.getSchema() == null) {
            return false;
        }
        return this.getAttributeString().length() != 0;
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List<String> getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.fieldToValue.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string2 == null || string2.equals("") || this.isIndivisible(string)) continue;
            try {
                Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(string2);
            }
        }
        this.CACHED_KEYWORDS = arrayList;
        return arrayList;
    }

    public List<String> getKeyWordsIndivisible() {
        return this.licenseType.getIndivisibleKeywords();
    }

    private boolean isIndivisible(String string) {
        return string.endsWith(XML_LICENSE_TYPE_ATTRIBUTE);
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return this.limeXMLSchemaRepository.get().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema limeXMLSchema = this.getSchema();
        if (limeXMLSchema != null) {
            return limeXMLSchema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public File getIdentifier() {
        return this.fileId;
    }

    public void initIdentifier(File file) {
        this.fileId = file;
    }

    public String getAction() {
        return "";
    }

    public boolean actionDetailRequested() {
        return "true".equalsIgnoreCase(this.actionDetail);
    }

    public Set<Map.Entry<String, String>> getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set<String> getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection<String> getValueList() {
        return this.fieldToValue.values();
    }

    public boolean isLicenseAvailable() {
        return this.licenseType != LicenseType.NO_LICENSE;
    }

    public String getLicenseString() {
        if (this.isLicenseAvailable()) {
            String string = LimeXMLDocument.getVerifiableLicenseElement(this.licenseType);
            if (string == null) {
                return null;
            }
            for (Map.Entry<String, String> entry : this.fieldToValue.entrySet()) {
                String string2 = entry.getKey();
                if (!string2.endsWith(string)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private static String getVerifiableLicenseElement(LicenseType licenseType) {
        if (licenseType == LicenseType.CC_LICENSE) {
            return XML_LICENSE_ATTRIBUTE;
        }
        if (licenseType.isDRMLicense()) {
            return XML_LICENSE_TYPE_ATTRIBUTE;
        }
        return null;
    }

    public License getLicense() {
        String string = this.getLicenseString();
        if (string != null) {
            return this.licenseFactory.create(string);
        }
        return null;
    }

    public List<NameValue<String>> getOrderedNameValueList() {
        if (this.getSchema() == null) {
            return Collections.emptyList();
        }
        String[] stringArray = this.getSchema().getCanonicalizedFieldNames();
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            String string2 = this.fieldToValue.get(string);
            if (string2 == null) continue;
            arrayList.add(new NameValue<String>(string, string2));
        }
        return arrayList;
    }

    public String getValue(String string) {
        return this.fieldToValue.get(string);
    }

    public String getXMLString() {
        StringBuilder stringBuilder = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(stringBuilder, this.getSchema(), this.getAttributeString() + "/>");
        return stringBuilder.toString();
    }

    public String getAttributeStringWithIndex(int n) {
        String string = this.getAttributeString();
        return string + " index=\"" + n + "\"/>";
    }

    private String getAttributeString() {
        if (this.attributeString == null) {
            this.attributeString = this.constructAttributeString();
        }
        return this.attributeString;
    }

    String getXmlWithVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(stringBuilder, this.getSchema(), this.getAttributeString() + " " + VERSION_STRING + "=\"" + this.version + "\"/>");
        return stringBuilder.toString();
    }

    boolean isCurrent() {
        return this.version == 3;
    }

    void setCurrent() {
        this.version = 3;
    }

    private String constructAttributeString() {
        List<NameValue<String>> list = this.getOrderedNameValueList();
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getSchema().getRootXMLName();
        String string2 = this.getSchema().getInnerXMLName();
        String string3 = string + "__" + string2 + "__";
        stringBuilder.append("<");
        stringBuilder.append(string2);
        for (NameValue<String> nameValue : list) {
            String string4 = XMLStringUtils.getLastField(string3, nameValue.getName());
            if (string4 == null) continue;
            stringBuilder.append(" ");
            stringBuilder.append(string4);
            stringBuilder.append("=\"");
            stringBuilder.append(LimeXMLUtils.encodeXML(nameValue.getValue()));
            stringBuilder.append("\"");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument limeXMLDocument = (LimeXMLDocument)object;
        return (this.schemaUri == null ? limeXMLDocument.schemaUri == null : this.schemaUri.equals(limeXMLDocument.schemaUri)) && (this.action == null ? limeXMLDocument.action == null : this.action.equals(limeXMLDocument.action)) && (this.actionDetail == null ? limeXMLDocument.actionDetail == null : this.actionDetail.equals(limeXMLDocument.actionDetail)) && (this.fieldToValue == null ? limeXMLDocument.fieldToValue == null : ((Object)this.fieldToValue).equals(limeXMLDocument.fieldToValue)) && this.version == limeXMLDocument.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            if (this.fieldToValue != null) {
                n = 37 * n + ((Object)this.fieldToValue).hashCode();
            }
            if (this.schemaUri != null) {
                n = 37 * n + this.schemaUri.hashCode();
            }
            if (this.action != null) {
                n = 37 * n + this.action.hashCode();
            }
            if (this.actionDetail != null) {
                n = 37 * n + this.actionDetail.hashCode();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getXMLString();
    }

    private void scanFields() {
        String string = this.getCanonicalKey(this.getNameValueSet());
        if (string == null) {
            return;
        }
        this.setFields(string);
        this.fieldToValue.remove(string + XML_INDEX_ATTRIBUTE);
        this.fieldToValue.remove(string + XML_ID_ATTRIBUTE);
    }

    private void setFields(String string) {
        String string2;
        this.action = this.fieldToValue.get(string + XML_ACTION_ATTRIBUTE);
        this.actionDetail = this.fieldToValue.get(string + XML_ACTION_INFO);
        String string3 = this.fieldToValue.get(string + XML_LICENSE_ATTRIBUTE);
        String string4 = this.fieldToValue.get(string + XML_LICENSE_TYPE_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("type: " + string4);
        }
        this.licenseType = LicenseType.determineLicenseType(string3, string4);
        if (this.licenseType == LicenseType.CC_LICENSE) {
            this.fieldToValue.put(string + XML_LICENSE_TYPE_ATTRIBUTE, "creativecommons.org/licenses/");
        }
        if (this.licenseType == LicenseType.LIMEWIRE_STORE_PURCHASE) {
            this.fieldToValue.put(string + XML_LICENSE_TYPE_ATTRIBUTE, LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
        }
        if ((string2 = this.fieldToValue.get(string + XML_VERSION_ATTRIBUTE)) != null) {
            try {
                this.version = Integer.parseInt(string2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set version to: " + this.version);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn("Unable to set version", numberFormatException);
                this.version = 3;
            }
        } else {
            this.version = 3;
        }
        this.fieldToValue.remove(string + XML_VERSION_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fields after setting: " + this.fieldToValue);
        }
    }

    private String getCanonicalKey(Collection<? extends Map.Entry<String, String>> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        Map.Entry<String, String> entry = collection.iterator().next();
        String string = entry.getKey();
        int n = string.indexOf("__");
        if ((n = string.indexOf("__", n + 1)) == -1) {
            return null;
        }
        return string.substring(0, n + 2);
    }

    @Override
    public String lookup(String string) {
        if (string == null) {
            return null;
        }
        if ("schema".equals(string)) {
            return this.getSchemaDescription();
        }
        if ("numKWords".equals(string)) {
            return String.valueOf(this.getKeyWords().size());
        }
        if ("numKWordsI".equals(string)) {
            return String.valueOf(this.getKeyWordsIndivisible().size());
        }
        if ("numFields".equals(string)) {
            return String.valueOf(this.getNumFields());
        }
        if ("ver".equals(string)) {
            return String.valueOf(this.version);
        }
        if (string.startsWith("field_")) {
            string = string.substring(6, string.length());
            return this.getValue(string);
        }
        return null;
    }

    public LicenseFactory getLicenseFactory() {
        return this.licenseFactory;
    }
}

