/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.limewire.util.OSUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

class OS {
    private static final Version STAR;
    private static final Version BAD;
    private final String os;
    private final Version fromVersion;
    private final Version toVersion;
    private final boolean acceptable;

    OS(String string, Version version, Version version2) {
        this.os = string;
        this.fromVersion = version;
        this.toVersion = version2;
        this.acceptable = this.accept(string.toLowerCase());
    }

    public String toString() {
        return this.os;
    }

    public boolean isAcceptable() {
        return this.acceptable;
    }

    static OS[] createFromList(String string, String string2) {
        int n;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Object[] objectArray = new Version[stringTokenizer.countTokens()];
        Object[] objectArray2 = new Version[stringTokenizer.countTokens()];
        if (string2 != null && string2.length() > 0) {
            object = new StringTokenizer(string2, ",");
            if (((StringTokenizer)object).countTokens() == stringTokenizer.countTokens() * 2) {
                try {
                    for (n = 0; n < objectArray.length; ++n) {
                        String string3 = ((StringTokenizer)object).nextToken().trim();
                        objectArray[n] = string3.equals("*") ? STAR : new Version(string3);
                        string3 = ((StringTokenizer)object).nextToken().trim();
                        objectArray2[n] = string3.equals("*") ? STAR : new Version(string3);
                    }
                }
                catch (VersionFormatException versionFormatException) {
                    Arrays.fill(objectArray, BAD);
                    Arrays.fill(objectArray2, BAD);
                }
            } else {
                Arrays.fill(objectArray, BAD);
                Arrays.fill(objectArray2, BAD);
            }
        }
        object = new OS[stringTokenizer.countTokens()];
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object[n] = new OS(stringTokenizer.nextToken().trim(), (Version)objectArray[n], (Version)objectArray2[n]);
            ++n;
        }
        return object;
    }

    static boolean hasAcceptableOS(OS[] oSArray) {
        for (int i = 0; i < oSArray.length; ++i) {
            if (!oSArray[i].isAcceptable()) continue;
            return true;
        }
        return false;
    }

    static String toString(OS[] oSArray) {
        if (oSArray == null) {
            return "";
        }
        String string = "";
        for (int i = 0; i < oSArray.length; ++i) {
            string = string + oSArray[i].toString();
            if (i >= oSArray.length - 2) continue;
            string = string + ", ";
        }
        return string;
    }

    private boolean accept(String string) {
        Object object;
        if (this.fromVersion != null && this.toVersion != null) {
            if (this.fromVersion == BAD || this.toVersion == BAD) {
                return false;
            }
            try {
                object = new Version(OSUtils.getOSVersion());
                if (this.fromVersion != STAR && ((Version)object).compareTo(this.fromVersion) < 0) {
                    return false;
                }
                if (this.toVersion != STAR && ((Version)object).compareTo(this.toVersion) >= 0) {
                    return false;
                }
            }
            catch (VersionFormatException versionFormatException) {
                // empty catch block
            }
        }
        if (string.equals(object = OSUtils.getOS().toLowerCase())) {
            return true;
        }
        if ("windows".equals(string)) {
            return OSUtils.isWindows();
        }
        if ("mac".equals(string)) {
            return OSUtils.isAnyMac();
        }
        if ("linux".equals(string)) {
            return OSUtils.isLinux();
        }
        if ("unix".equals(string)) {
            return OSUtils.isUnix() && !OSUtils.isLinux();
        }
        if ("other".equals(string)) {
            return !OSUtils.isWindows() && !OSUtils.isAnyMac() && !OSUtils.isUnix() && !OSUtils.isLinux();
        }
        return "*".equals(string);
    }

    static {
        Version version;
        Version version2;
        try {
            version2 = new Version("0");
            version = new Version("0");
        }
        catch (VersionFormatException versionFormatException) {
            throw new RuntimeException(versionFormatException);
        }
        STAR = version2;
        BAD = version;
    }
}

