/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.util.NoSuchElementException;

public class QuotedStringTokenizer {
    public static final char QUOTE_CHAR = '\"';
    private final boolean returnSeparators;
    private final String text;
    private final int maxIndex;
    private String separators;
    private int index;

    public QuotedStringTokenizer(String string, String string2, boolean bl) {
        this.text = string;
        this.maxIndex = string.length() - 1;
        this.separators = string2;
        this.returnSeparators = bl;
    }

    public QuotedStringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public QuotedStringTokenizer(String string) {
        this(string, " ", false);
    }

    public int countTokens() {
        Token token;
        int n = 0;
        int n2 = this.index;
        while ((token = this.nextToken(n2)) != null) {
            ++n;
            n2 = token.nextIndex;
        }
        return n;
    }

    public boolean hasMoreTokens() {
        return this.nextToken(this.index) != null;
    }

    public String nextToken(String string) {
        this.separators = string;
        return this.nextToken();
    }

    public String nextToken() {
        Token token = this.nextToken(this.index);
        if (token != null) {
            this.index = token.nextIndex;
            return token.text;
        }
        throw new NoSuchElementException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Token nextToken(int n) {
        int n2;
        if (n > this.maxIndex) {
            return null;
        }
        if (this.returnSeparators && this.separators.indexOf(this.text.charAt(n)) != -1) {
            return new Token(this.text.substring(n, n + 1), n + 1);
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = n; n2 <= this.maxIndex && this.separators.indexOf(this.text.charAt(n2)) != -1; ++n2) {
        }
        if (n2 > this.maxIndex) {
            return null;
        }
        while (n2 <= this.maxIndex) {
            char c = this.text.charAt(n2);
            if (this.separators.indexOf(c) != -1) {
                if (!bl) return new Token(stringBuilder.toString(), n2);
                stringBuilder.append(c);
            } else if (c == '\"') {
                bl = !bl;
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return new Token(stringBuilder.toString(), n2);
    }

    private class Token {
        String text;
        int nextIndex;

        Token(String string, int n) {
            this.text = string;
            this.nextIndex = n;
        }
    }
}

