/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.util.FECUtils;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECCodeFactory;
import com.onionnetworks.util.Buffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FECUtilsImpl
implements FECUtils {
    private FECCodeFactory fecFactory;

    @Inject
    public FECUtilsImpl() {
        System.setProperty("com.onionnetworks.fec.keys", "pure8,pure16");
    }

    @Override
    public List<byte[]> encode(byte[] byArray, int n, float f) {
        int n2;
        if (this.fecFactory == null) {
            this.fecFactory = FECCodeFactory.getDefault();
        }
        int n3 = byArray.length / n + (byArray.length % n == 0 ? 0 : 1);
        int n4 = (int)Math.ceil((float)n3 * f);
        FECCode fECCode = this.fecFactory.createFECCode(n3, n4);
        Buffer[] bufferArray = new Buffer[n3];
        Buffer[] bufferArray2 = new Buffer[n4];
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n3; ++n2) {
            byte[] objectArray = new byte[n];
            System.arraycopy(byArray, n2 * n, objectArray, 0, Math.min(n, byArray.length - n2 * n));
            bufferArray[n2] = new Buffer(objectArray);
            bufferArray2[n2] = new Buffer(new byte[n]);
            nArray[n2] = n2;
        }
        for (n2 = n3; n2 < n4; ++n2) {
            bufferArray2[n2] = new Buffer(new byte[n]);
            nArray[n2] = n2;
        }
        fECCode.encode(bufferArray, bufferArray2, nArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n4);
        for (Buffer buffer : bufferArray2) {
            arrayList.add(buffer.b);
        }
        return arrayList;
    }

    @Override
    public byte[] decode(List<byte[]> list, int n) {
        if (this.fecFactory == null) {
            this.fecFactory = FECCodeFactory.getDefault();
        }
        int n2 = -1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        ArrayList<Buffer> arrayList2 = new ArrayList<Buffer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            arrayList2.add(new Buffer(list.get(i)));
            arrayList.add(i);
            if (n2 == -1) {
                n2 = list.get(i).length;
                continue;
            }
            if (list.get(i).length == n2) continue;
            return null;
        }
        if (n2 == -1) {
            return null;
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        Buffer[] bufferArray = new Buffer[arrayList2.size()];
        arrayList2.toArray(bufferArray);
        int n3 = n / n2 + (n % n2 == 0 ? 0 : 1);
        FECCode fECCode = this.fecFactory.createFECCode(n3, list.size());
        try {
            fECCode.decode(bufferArray, nArray);
        }
        catch (Throwable throwable) {
            return null;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n3; ++i) {
            byte[] byArray2 = bufferArray[i].b;
            System.arraycopy(byArray2, 0, byArray, i * n2, Math.min(n2, n - i * n2));
        }
        return byArray;
    }
}

