/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.http.AltLocHeaderInterceptor;
import com.limegroup.gnutella.http.FWNodeInfoInterceptor;
import com.limegroup.gnutella.http.FeatureHeaderInterceptor;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.http.UserAgentHeaderInterceptor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandler;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandlerFactory;
import com.limegroup.gnutella.uploader.FileRequestParser;
import com.limegroup.gnutella.uploader.FileResponseEntityFactory;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.THEXResponseEntity;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.BasicHeaderProcessor;
import org.limewire.http.MalformedHeaderException;
import org.limewire.http.RangeHeaderInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(FileRequestHandler.class);
    private static final String INACTIVE_RETRY_AFTER = "3600";
    private final HTTPUploadSessionManager sessionManager;
    private final FileManager fileManager;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final HttpRequestHandlerFactory httpRequestHandlerFactory;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final FileResponseEntityFactory fileResponseEntityFactory;
    private final AltLocManager altLocManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final HashTreeWriteHandlerFactory tigerWriteHandlerFactory;

    @Inject
    FileRequestHandler(HTTPUploadSessionManager hTTPUploadSessionManager, FileManager fileManager, HTTPHeaderUtils hTTPHeaderUtils, HttpRequestHandlerFactory httpRequestHandlerFactory, Provider<CreationTimeCache> provider, FileResponseEntityFactory fileResponseEntityFactory, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory, Provider<DownloadManager> provider2, Provider<HashTreeCache> provider3, PushEndpointFactory pushEndpointFactory, HashTreeWriteHandlerFactory hashTreeWriteHandlerFactory) {
        this.sessionManager = hTTPUploadSessionManager;
        this.fileManager = fileManager;
        this.httpHeaderUtils = hTTPHeaderUtils;
        this.httpRequestHandlerFactory = httpRequestHandlerFactory;
        this.creationTimeCache = provider;
        this.fileResponseEntityFactory = fileResponseEntityFactory;
        this.altLocManager = altLocManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = provider2;
        this.tigerTreeCache = provider3;
        this.pushEndpointFactory = pushEndpointFactory;
        this.tigerWriteHandlerFactory = hashTreeWriteHandlerFactory;
    }

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
        return null;
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Object object;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling upload request: " + httpRequest.getRequestLine().getUri());
        }
        FileRequestParser.FileRequest fileRequest = null;
        HTTPUploader hTTPUploader = null;
        try {
            object = httpRequest.getRequestLine().getUri();
            if (FileRequestParser.isURNGet((String)object)) {
                fileRequest = FileRequestParser.parseURNGet(this.fileManager, (String)object);
                if (fileRequest == null) {
                    hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.INVALID_URN, "Invalid URN query");
                    hTTPUploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
                    httpResponse.setStatusCode(404);
                }
            } else {
                fileRequest = FileRequestParser.parseTraditionalGet((String)object);
                assert (fileRequest != null);
            }
        }
        catch (IOException iOException) {
            hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.MALFORMED_REQUEST, "Malformed Request");
            this.handleMalformedRequest(httpResponse, hTTPUploader);
        }
        if (fileRequest != null) {
            object = this.getFileDesc(fileRequest);
            if (object != null) {
                hTTPUploader = this.findFileAndProcessHeaders(httpRequest, httpResponse, httpContext, fileRequest, (FileDesc)object);
            } else {
                hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.SHARED_FILE, fileRequest.filename);
                hTTPUploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
                httpResponse.setStatusCode(404);
            }
        }
        assert (hTTPUploader != null);
        this.sessionManager.sendResponse(hTTPUploader, httpResponse);
    }

    private HTTPUploader findFileAndProcessHeaders(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext, FileRequestParser.FileRequest fileRequest, FileDesc fileDesc) throws IOException, HttpException {
        UploadType uploadType = SharingUtils.isForcedShare(fileDesc) ? UploadType.FORCED_SHARE : UploadType.SHARED_FILE;
        HTTPUploader hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, uploadType, fileDesc.getFileName());
        hTTPUploader.setFileDesc(fileDesc);
        BasicHeaderProcessor basicHeaderProcessor = new BasicHeaderProcessor();
        RangeHeaderInterceptor rangeHeaderInterceptor = new RangeHeaderInterceptor();
        basicHeaderProcessor.addInterceptor(rangeHeaderInterceptor);
        basicHeaderProcessor.addInterceptor(new FeatureHeaderInterceptor(hTTPUploader));
        basicHeaderProcessor.addInterceptor(new AltLocHeaderInterceptor(hTTPUploader, this.altLocManager, this.alternateLocationFactory));
        basicHeaderProcessor.addInterceptor(new FWNodeInfoInterceptor(hTTPUploader, this.pushEndpointFactory));
        if (!hTTPUploader.getFileName().toUpperCase().startsWith("LIMEWIRE")) {
            basicHeaderProcessor.addInterceptor(new UserAgentHeaderInterceptor(hTTPUploader));
        }
        try {
            basicHeaderProcessor.process(httpRequest, httpContext);
        }
        catch (ProblemReadingHeaderException problemReadingHeaderException) {
            this.handleMalformedRequest(httpResponse, hTTPUploader);
            return hTTPUploader;
        }
        catch (MalformedHeaderException malformedHeaderException) {
            this.handleMalformedRequest(httpResponse, hTTPUploader);
            return hTTPUploader;
        }
        if (UserAgentHeaderInterceptor.isFreeloader(hTTPUploader.getUserAgent())) {
            this.sessionManager.handleFreeLoader(httpRequest, httpResponse, httpContext, hTTPUploader);
            return hTTPUploader;
        }
        if (!this.validateHeaders(hTTPUploader, fileRequest.isThexRequest())) {
            hTTPUploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
            httpResponse.setStatusCode(404);
            return hTTPUploader;
        }
        if (!fileRequest.isThexRequest()) {
            if (rangeHeaderInterceptor.hasRequestedRanges()) {
                RangeHeaderInterceptor.Range[] rangeArray = rangeHeaderInterceptor.getRequestedRanges();
                if (rangeArray.length > 1) {
                    this.handleInvalidRange(httpResponse, hTTPUploader, fileDesc);
                    return hTTPUploader;
                }
                hTTPUploader.setUploadBegin(rangeArray[0].getStartOffset(hTTPUploader.getFileSize()));
                hTTPUploader.setUploadEnd(rangeArray[0].getEndOffset(hTTPUploader.getFileSize()) + 1L);
                hTTPUploader.setContainedRangeRequest(true);
            }
            if (!hTTPUploader.validateRange()) {
                this.handleInvalidRange(httpResponse, hTTPUploader, fileDesc);
                return hTTPUploader;
            }
        }
        if (fileRequest.isThexRequest()) {
            this.handleTHEXRequest(httpRequest, httpResponse, httpContext, hTTPUploader, fileDesc);
        } else {
            this.handleFileUpload(httpContext, httpRequest, httpResponse, hTTPUploader, fileDesc);
        }
        return hTTPUploader;
    }

    private void handleMalformedRequest(HttpResponse httpResponse, HTTPUploader hTTPUploader) {
        hTTPUploader.setState(Uploader.UploadStatus.MALFORMED_REQUEST);
        httpResponse.setStatusCode(400);
        httpResponse.setReasonPhrase("Malformed Request");
    }

    private void handleFileUpload(HttpContext httpContext, HttpRequest httpRequest, HttpResponse httpResponse, HTTPUploader hTTPUploader, FileDesc fileDesc) throws IOException, HttpException {
        if (!hTTPUploader.getSession().isAccepted()) {
            HTTPUploadSessionManager.QueueStatus queueStatus = this.sessionManager.enqueue(httpContext, httpRequest);
            switch (queueStatus) {
                case REJECTED: {
                    this.httpRequestHandlerFactory.createLimitReachedRequestHandler(hTTPUploader).handle(httpRequest, httpResponse, httpContext);
                    break;
                }
                case BANNED: {
                    hTTPUploader.setState(Uploader.UploadStatus.BANNED_GREEDY);
                    httpResponse.setStatusCode(403);
                    httpResponse.setReasonPhrase("Banned");
                    break;
                }
                case QUEUED: {
                    this.handleQueued(httpContext, httpRequest, httpResponse, hTTPUploader, fileDesc);
                    break;
                }
                case ACCEPTED: {
                    this.sessionManager.addAcceptedUploader(hTTPUploader, httpContext);
                    break;
                }
            }
        }
        if (hTTPUploader.getSession().canUpload()) {
            this.handleAccept(httpContext, httpRequest, httpResponse, hTTPUploader, fileDesc);
        }
    }

    protected void handleAccept(HttpContext httpContext, HttpRequest httpRequest, HttpResponse httpResponse, HTTPUploader hTTPUploader, FileDesc fileDesc) throws IOException, HttpException {
        HashTree hashTree;
        Object object;
        assert (fileDesc != null);
        httpResponse.addHeader(HTTPHeaderName.DATE.create(HTTPUtils.getDateValue()));
        httpResponse.addHeader(HTTPHeaderName.CONTENT_DISPOSITION.create("attachment; filename=\"" + HTTPUtils.encode(hTTPUploader.getFileName(), "US-ASCII") + "\""));
        if (hTTPUploader.containedRangeRequest()) {
            object = "bytes " + hTTPUploader.getUploadBegin() + "-" + (hTTPUploader.getUploadEnd() - 1L) + "/" + hTTPUploader.getFileSize();
            httpResponse.addHeader(HTTPHeaderName.CONTENT_RANGE.create((String)object));
        }
        this.httpHeaderUtils.addAltLocationsHeader(httpResponse, hTTPUploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(httpResponse, hTTPUploader, fileDesc);
        this.httpHeaderUtils.addProxyHeader(httpResponse);
        object = fileDesc.getSHA1Urn();
        if (hTTPUploader.isFirstReply() && this.creationTimeCache.get().getCreationTime((URN)object) != null) {
            httpResponse.addHeader(HTTPHeaderName.CREATION_TIME.create(this.creationTimeCache.get().getCreationTime((URN)object).toString()));
        }
        if (hTTPUploader.isFirstReply()) {
            this.httpHeaderUtils.addFeatures(httpResponse);
        }
        if ((hashTree = this.tigerTreeCache.get().getHashTree(fileDesc)) != null) {
            httpResponse.addHeader(HTTPHeaderName.THEX_URI.create(hashTree));
        }
        httpResponse.setEntity(this.fileResponseEntityFactory.createFileResponseEntity(hTTPUploader, fileDesc.getFile()));
        hTTPUploader.setState(Uploader.UploadStatus.UPLOADING);
        if (hTTPUploader.isPartial()) {
            httpResponse.setStatusCode(206);
        } else {
            httpResponse.setStatusCode(200);
        }
    }

    private void handleTHEXRequest(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext, HTTPUploader hTTPUploader, FileDesc fileDesc) throws HttpException, IOException {
        hTTPUploader.getSession().updatePollTime(HTTPUploadSessionManager.QueueStatus.BYPASS);
        hTTPUploader.setIgnoreTotalAmountUploaded(true);
        HashTree hashTree = this.tigerTreeCache.get().getHashTree(fileDesc);
        if (hashTree == null) {
            hTTPUploader.setState(Uploader.UploadStatus.FILE_NOT_FOUND);
            httpResponse.setStatusCode(404);
            return;
        }
        HashTreeWriteHandler hashTreeWriteHandler = this.tigerWriteHandlerFactory.createTigerWriteHandler(hashTree);
        int n = hashTreeWriteHandler.getOutputLength();
        hTTPUploader.setFileSize(n);
        hTTPUploader.setUploadBegin(0L);
        hTTPUploader.setUploadEnd(n);
        hTTPUploader.setState(Uploader.UploadStatus.THEX_REQUEST);
        httpResponse.setEntity(new THEXResponseEntity(hTTPUploader, hashTreeWriteHandler, hTTPUploader.getFileSize()));
        httpResponse.setStatusCode(200);
    }

    private void handleInvalidRange(HttpResponse httpResponse, HTTPUploader hTTPUploader, FileDesc fileDesc) {
        this.httpHeaderUtils.addAltLocationsHeader(httpResponse, hTTPUploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(httpResponse, hTTPUploader, fileDesc);
        this.httpHeaderUtils.addProxyHeader(httpResponse);
        if (fileDesc instanceof IncompleteFileDesc && !this.downloadManager.get().isActivelyDownloading(fileDesc.getSHA1Urn())) {
            httpResponse.addHeader(HTTPHeaderName.RETRY_AFTER.create(INACTIVE_RETRY_AFTER));
        }
        hTTPUploader.setState(Uploader.UploadStatus.UNAVAILABLE_RANGE);
        httpResponse.setStatusCode(416);
        httpResponse.setReasonPhrase("Requested Range Unavailable");
    }

    private void handleQueued(HttpContext httpContext, HttpRequest httpRequest, HttpResponse httpResponse, HTTPUploader hTTPUploader, FileDesc fileDesc) throws IOException, HttpException {
        HashTree hashTree;
        int n = hTTPUploader.getSession().positionInQueue();
        assert (n != -1);
        String string = "position=" + (n + 1) + ", pollMin=" + 45 + ", pollMax=" + 120;
        httpResponse.addHeader(HTTPHeaderName.QUEUE.create(string));
        this.httpHeaderUtils.addAltLocationsHeader(httpResponse, hTTPUploader.getAltLocTracker(), this.altLocManager);
        this.httpHeaderUtils.addRangeHeader(httpResponse, hTTPUploader, fileDesc);
        if (hTTPUploader.isFirstReply()) {
            this.httpHeaderUtils.addFeatures(httpResponse);
        }
        if ((hashTree = this.tigerTreeCache.get().getHashTree(fileDesc)) != null) {
            httpResponse.addHeader(HTTPHeaderName.THEX_URI.create(hashTree));
        }
        httpResponse.setHeader("Connection", "Keep-Alive");
        hTTPUploader.setState(Uploader.UploadStatus.QUEUED);
        httpResponse.setStatusCode(503);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDesc getFileDesc(FileRequestParser.FileRequest fileRequest) {
        FileDesc fileDesc = null;
        int n = fileRequest.index;
        FileManager fileManager = this.fileManager;
        synchronized (fileManager) {
            if (this.fileManager.isValidIndex(n)) {
                fileDesc = this.fileManager.get(n);
            }
        }
        if (fileDesc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid index in request does not map to file descriptor: " + fileRequest);
            }
            return null;
        }
        if (!fileRequest.filename.equals(fileDesc.getFileName())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid file name in request: " + fileRequest + ", expected: " + fileDesc.getFileName());
            }
            return null;
        }
        return fileDesc;
    }

    private boolean validateHeaders(HTTPUploader hTTPUploader, boolean bl) {
        FileDesc fileDesc = hTTPUploader.getFileDesc();
        assert (fileDesc != null);
        URN uRN = hTTPUploader.getRequestedURN();
        if (uRN != null && !fileDesc.containsUrn(uRN)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid content urn: " + hTTPUploader);
            }
            return false;
        }
        if (bl && this.tigerTreeCache.get().getHashTree(fileDesc) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requested thex tree is not available: " + hTTPUploader);
            }
            return false;
        }
        if (fileDesc instanceof IncompleteFileDesc) {
            if (!SharingSettings.ALLOW_PARTIAL_SHARING.getValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sharing of partial files is diabled: " + hTTPUploader);
                }
                return false;
            }
            if (bl) {
                return false;
            }
        } else {
            File file = fileDesc.getFile();
            if (file.lastModified() != fileDesc.lastModified()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File has changed on disk, resharing: " + file);
                }
                this.fileManager.removeFileIfShared(file);
                this.fileManager.addFileIfShared(file);
                return false;
            }
        }
        return true;
    }
}

