/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Singleton;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeNodeManager;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import java.util.ArrayList;
import java.util.List;
import org.limewire.collection.FixedsizeForgetfulHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class HashTreeNodeManagerImpl
implements HashTreeNodeManager {
    private static final int MAX_NODES = 500;
    private FixedsizeForgetfulHashMap<HashTree, List<List<byte[]>>> MAP = new FixedsizeForgetfulHashMap(250);
    private int _currentNodes = 0;

    HashTreeNodeManagerImpl() {
    }

    @Override
    public List<List<byte[]>> getAllNodes(HashTree hashTree) {
        int n = hashTree.getDepth();
        if (hashTree.getDepth() == 0) {
            ArrayList<List<byte[]>> arrayList = new ArrayList<List<byte[]>>(1);
            arrayList.add(hashTree.getNodes());
            return arrayList;
        }
        if (n < 2 || n >= 7) {
            return HashTreeUtils.createAllParentNodes(hashTree.getNodes(), new Tiger());
        }
        return this.getAllNodesImpl(hashTree);
    }

    @Override
    public void register(HashTree hashTree, List<List<byte[]>> list) {
        int n = hashTree.getDepth();
        if (n > 2 && n < 7 && !this.MAP.containsKey(hashTree)) {
            this.insertEntry(hashTree, list);
        }
    }

    private synchronized List<List<byte[]>> getAllNodesImpl(HashTree hashTree) {
        List<List<byte[]>> list = (List<List<byte[]>>)this.MAP.get(hashTree);
        if (list != null) {
            this.MAP.put(hashTree, list);
            return list;
        }
        list = HashTreeUtils.createAllParentNodes(hashTree.getNodes(), new Tiger());
        this.insertEntry(hashTree, list);
        return list;
    }

    private synchronized void insertEntry(HashTree hashTree, List<List<byte[]>> list) {
        int n = HashTreeNodeManagerImpl.calculateSize(list);
        while (this._currentNodes + n > 500) {
            if (this.MAP.isEmpty()) {
                throw new IllegalStateException("current: " + this._currentNodes + ", size: " + n);
            }
            this.purgeLRU();
        }
        this._currentNodes += n;
        this.MAP.put(hashTree, list);
    }

    private synchronized void purgeLRU() {
        List<List<byte[]>> list = this.MAP.removeLRUEntry().getValue();
        this._currentNodes -= HashTreeNodeManagerImpl.calculateSize(list);
    }

    private static int calculateSize(List<List<byte[]>> list) {
        int n = 0;
        for (List<byte[]> list2 : list) {
            n += list2.size();
        }
        return n;
    }
}

