/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.AbstractToken;
import com.limegroup.gnutella.spam.Token;
import java.util.Arrays;

public class KeywordToken
extends AbstractToken {
    private static final long serialVersionUID = 3257850995487748662L;
    private static final byte INITAL_GOOD = 20;
    private static final int MAX = 100;
    private final byte[] _keyword;
    private byte _good = (byte)20;
    private byte _bad = 0;
    private final int _hashCode;

    KeywordToken(byte[] byArray) {
        this._keyword = byArray;
        int n = 0;
        for (int i = 0; i < this._keyword.length; ++i) {
            n = 31 * n + this._keyword[i];
        }
        this._hashCode = n;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof KeywordToken)) {
            return false;
        }
        if (this._hashCode != object.hashCode()) {
            return false;
        }
        return Arrays.equals(this._keyword, ((KeywordToken)object)._keyword);
    }

    public float getRating() {
        return (float)Math.pow(1.0f * (float)this._bad / (float)(this._good + this._bad + 1), 2.0);
    }

    public void rate(Token.Rating rating) {
        this._age = 0;
        switch (rating) {
            case PROGRAM_MARKED_GOOD: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case PROGRAM_MARKED_SPAM: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case USER_MARKED_GOOD: {
                this._bad = 0;
                break;
            }
            case USER_MARKED_SPAM: {
                this._bad = (byte)Math.min(this._bad + 10, 100);
                break;
            }
            case CLEARED: {
                this._bad = 0;
                this._good = (byte)20;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 100 || this._bad >= 100) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    public Token.TokenType getType() {
        return Token.TokenType.KEYWORD;
    }

    public String toString() {
        return new String(this._keyword) + " " + this._good + " " + this._bad;
    }
}

