/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteOrder;

public class ResetTableMessage
extends RouteTableMessage {
    private int tableSize;
    private byte infinity;

    public ResetTableMessage(int n, byte by) {
        super((byte)1, 6, (byte)0);
        if (n < 1 || by < 1) {
            throw new IllegalArgumentException("Argument too small: " + n + ", " + by);
        }
        this.tableSize = n;
        this.infinity = by;
    }

    protected void writePayloadData(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[5];
        ByteOrder.int2leb(this.tableSize, byArray, 0);
        byArray[4] = this.infinity;
        outputStream.write(byArray);
    }

    protected ResetTableMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) {
        super(byArray, by, by2, byArray2.length, (byte)0, network);
        this.tableSize = ByteOrder.leb2int(byArray2, 1);
        this.infinity = byArray2[5];
    }

    public byte getInfinity() {
        return this.infinity;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public String toString() {
        return "{RESET, tableSize: " + this.getTableSize() + ", Infinity: " + this.getInfinity() + "}";
    }
}

