/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.limewire.io.IOUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGMMetaData
extends VideoDataReader {
    public static final String TITLE_TAG = "title";
    public static final String COMMENT_TAG = "comment";
    public static final String LICENSE_TAG = "license";
    private static final String DATE_TAG = "date";
    private static final String LANGUAGE_TAG = "language";

    public OGMMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            Set<String> set = this.readMetaData(dataInputStream);
            this.parseMetaData(set);
        }
        catch (Throwable throwable) {
            IOUtils.close(fileInputStream);
            throw throwable;
        }
        IOUtils.close(fileInputStream);
    }

    private Set<String> readMetaData(DataInputStream dataInputStream) throws IOException {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        while (!(bl = this.parseCommentBlock(n = this.readHeader(dataInputStream), dataInputStream, hashSet))) {
        }
        return hashSet;
    }

    private int readHeader(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readByte() != 79) {
            throw new IOException("not an ogg file");
        }
        if (dataInputStream.readByte() != 103) {
            throw new IOException("not an ogg file");
        }
        if (dataInputStream.readByte() != 103) {
            throw new IOException("not an ogg file");
        }
        if (dataInputStream.readByte() != 83) {
            throw new IOException("not an ogg file");
        }
        IOUtils.ensureSkip(dataInputStream, 22L);
        int n = dataInputStream.readUnsignedByte();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += dataInputStream.readUnsignedByte();
        }
        return n2;
    }

    private boolean parseCommentBlock(int n, DataInputStream dataInputStream, Set<String> set) throws IOException {
        byte by = dataInputStream.readByte();
        --n;
        if ((by & 1) != 1) {
            IOUtils.ensureSkip(dataInputStream, n);
            return true;
        }
        if (by != 3) {
            IOUtils.ensureSkip(dataInputStream, n);
            return false;
        }
        byte[] byArray = new byte[6];
        dataInputStream.readFully(byArray);
        n -= 6;
        if (byArray[0] != 118 || byArray[1] != 111 || byArray[2] != 114 || byArray[3] != 98 || byArray[4] != 105 || byArray[5] != 115) {
            IOUtils.ensureSkip(dataInputStream, n);
            return true;
        }
        byte[] byArray2 = new byte[4];
        dataInputStream.readFully(byArray2);
        int n2 = ByteOrder.leb2int(byArray2, 0);
        byte[] byArray3 = new byte[n2];
        dataInputStream.readFully(byArray3);
        dataInputStream.readFully(byArray2);
        int n3 = ByteOrder.leb2int(byArray2, 0);
        for (int i = 0; i < n3; ++i) {
            dataInputStream.readFully(byArray2);
            int n4 = ByteOrder.leb2int(byArray2, 0);
            byte[] byArray4 = new byte[n4];
            dataInputStream.readFully(byArray4);
            set.add(new String(byArray4, "UTF-8"));
        }
        return (dataInputStream.readByte() & 1) != 1;
    }

    private void parseMetaData(Set<String> set) {
        for (String string : set) {
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equalsIgnoreCase(COMMENT_TAG)) {
                if (this.videoData.getComment() != null) {
                    this.videoData.setComment(this.videoData.getComment() + "\n" + string3);
                    continue;
                }
                this.videoData.setComment(string3);
                continue;
            }
            if (string2.equalsIgnoreCase(LANGUAGE_TAG)) {
                if (this.videoData.getLanguage() != null) {
                    this.videoData.setLanguage(this.videoData.getLanguage() + ";" + string3);
                    continue;
                }
                this.videoData.setLanguage(string3);
                continue;
            }
            if (string2.equalsIgnoreCase(LICENSE_TAG)) {
                this.videoData.setLicense(string3);
                continue;
            }
            if (string2.equalsIgnoreCase(TITLE_TAG)) {
                this.videoData.setTitle(string3);
                continue;
            }
            if (!string2.equalsIgnoreCase(DATE_TAG)) continue;
            this.videoData.setYear(string3);
        }
    }
}

