/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;

@Singleton
public class MetaDataReader {
    private static final Log LOG = LogFactory.getLog(MetaDataReader.class);
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final LimeXMLSchemaRepository limeXMLSchemaRepository;
    private final MetaDataFactory metaDataFactory;

    @Inject
    MetaDataReader(LimeXMLDocumentFactory limeXMLDocumentFactory, LimeXMLSchemaRepository limeXMLSchemaRepository, MetaDataFactory metaDataFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        this.metaDataFactory = metaDataFactory;
    }

    public LimeXMLDocument readDocument(File file) throws IOException {
        MetaReader metaReader = this.metaDataFactory.parse(file);
        if (metaReader == null) {
            throw new IOException("unable to parse file");
        }
        List<NameValue<String>> list = metaReader.toNameValueList();
        if (list.isEmpty()) {
            throw new IOException("invalid/no data.");
        }
        String string = metaReader.getSchemaURI();
        LimeXMLSchema limeXMLSchema = this.limeXMLSchemaRepository.getSchema(string);
        if (limeXMLSchema == null || limeXMLSchema.getCanonicalizedFields().isEmpty()) {
            throw new IOException("schema: " + string + " doesn't exist");
        }
        try {
            return this.limeXMLDocumentFactory.createLimeXMLDocument(list, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Error creating document", illegalArgumentException);
            throw (IOException)new IOException().initCause(illegalArgumentException);
        }
    }
}

