/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CapabilitiesVM
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    static final byte[] FEATURE_SEARCH_BYTES = new byte[]{87, 72, 65, 84};
    static final byte[] SIMPP_CAPABILITY_BYTES = new byte[]{73, 77, 80, 80};
    static final byte[] LIME_UPDATE_BYTES = new byte[]{76, 77, 85, 80};
    static final byte[] TLS_SUPPORT_BYTES = new byte[]{84, 76, 83, 33};
    public static final int VERSION = 0;
    private final Set<SupportedMessageBlock> _capabilitiesSupported;

    CapabilitiesVM(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_NULL_VENDOR_ID, 10, n, byArray2, network);
        this._capabilitiesSupported = new HashSet<SupportedMessageBlock>();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPayload());
            int n2 = ByteOrder.ushort2int(ByteOrder.leb2short(byteArrayInputStream));
            for (int i = 0; i < n2; ++i) {
                this._capabilitiesSupported.add(new SupportedMessageBlock(byteArrayInputStream));
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    CapabilitiesVM(Set<SupportedMessageBlock> set) {
        super(F_NULL_VENDOR_ID, 10, 0, CapabilitiesVM.derivePayload(set));
        this._capabilitiesSupported = set;
    }

    private static byte[] derivePayload(Set<SupportedMessageBlock> set) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)set.size(), byteArrayOutputStream);
            for (SupportedMessageBlock supportedMessageBlock : set) {
                supportedMessageBlock.encode(byteArrayOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    public int supportsCapability(byte[] byArray) {
        for (SupportedMessageBlock supportedMessageBlock : this._capabilitiesSupported) {
            int n = supportedMessageBlock.matches(byArray);
            if (n <= -1) continue;
            return n;
        }
        return -1;
    }

    public int supportsTLS() {
        return this.supportsCapability(TLS_SUPPORT_BYTES);
    }

    public int supportsFeatureQueries() {
        return this.supportsCapability(FEATURE_SEARCH_BYTES);
    }

    public boolean supportsWhatIsNew() {
        return FeatureSearchData.supportsWhatIsNew(this.supportsCapability(FEATURE_SEARCH_BYTES));
    }

    public int supportsSIMPP() {
        return this.supportsCapability(SIMPP_CAPABILITY_BYTES);
    }

    public int supportsUpdate() {
        return this.supportsCapability(LIME_UPDATE_BYTES);
    }

    public int isActiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.ACTIVE.getCapabilityName());
    }

    public int isPassiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE.getCapabilityName());
    }

    public int isPassiveLeafNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE_LEAF.getCapabilityName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CapabilitiesVM) {
            CapabilitiesVM capabilitiesVM = (CapabilitiesVM)object;
            return ((Object)this._capabilitiesSupported).equals(capabilitiesVM._capabilitiesSupported);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * ((Object)this._capabilitiesSupported).hashCode();
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    @Override
    public String toString() {
        return "{CapabilitiesVM:" + super.toString() + "; supporting: " + this._capabilitiesSupported + "}";
    }

    public static class SupportedMessageBlock {
        final byte[] _capabilityName;
        final int _version;
        final int _hashCode;

        public String toString() {
            return new String(this._capabilityName) + "/" + this._version;
        }

        public SupportedMessageBlock(byte[] byArray, int n) {
            this._capabilityName = byArray;
            this._version = n;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public SupportedMessageBlock(InputStream inputStream) throws BadPacketException, IOException {
            if (inputStream.available() < 6) {
                throw new BadPacketException("invalid block.");
            }
            this._capabilityName = new byte[4];
            inputStream.read(this._capabilityName, 0, this._capabilityName.length);
            this._version = ByteOrder.ushort2int(ByteOrder.leb2short(inputStream));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this._capabilityName);
            ByteOrder.short2leb((short)this._version, outputStream);
        }

        public int matches(byte[] byArray) {
            if (Arrays.equals(this._capabilityName, byArray)) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportedMessageBlock) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)object;
                return this._version == supportedMessageBlock._version && Arrays.equals(this._capabilityName, supportedMessageBlock._capabilityName);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] byArray, int n) {
            int n2 = 0;
            n2 += 37 * n;
            for (int i = 0; i < byArray.length; ++i) {
                n2 += 37 * byArray[i];
            }
            return n2;
        }
    }
}

