/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.util.ByteOrder;

public abstract class AbstractVendorMessage
extends AbstractMessage
implements VendorMessage {
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected AbstractVendorMessage(byte[] byArray, int n, int n2, byte[] byArray2) {
        this(byArray, n, n2, byArray2, Message.Network.UNKNOWN);
    }

    protected AbstractVendorMessage(byte[] byArray, int n, int n2, byte[] byArray2, Message.Network network) {
        super((byte)49, (byte)1, 8 + byArray2.length, network);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + byArray.length);
        }
        if ((n & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + n);
        }
        if ((n2 & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + n2);
        }
        this._vendorID = byArray;
        this._selector = n;
        this._version = n2;
        this._payload = byArray2;
        this._hashCode = AbstractVendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected AbstractVendorMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3, Message.Network network) throws BadPacketException {
        super(byArray, (byte)49, by, by2, 8 + byArray3.length, network);
        if (byArray2.length != 4) {
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((n & 0xFFFF0000) != 0) {
            throw new BadPacketException("Selector Invalid!");
        }
        if ((n2 & 0xFFFF0000) != 0) {
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = byArray2;
        this._selector = n;
        this._version = n2;
        this._payload = byArray3;
        this._hashCode = AbstractVendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3;
        int n4 = 0;
        n4 += 17 * n;
        n4 += 17 * n2;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n4 += 17 * byArray[n3];
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            n4 += 17 * byArray2[n3];
        }
        return n4;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    public int getVersion() {
        return this._version;
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractVendorMessage) {
            AbstractVendorMessage abstractVendorMessage = (AbstractVendorMessage)object;
            return this._selector == abstractVendorMessage._selector && Arrays.equals(this._vendorID, abstractVendorMessage._vendorID) && Arrays.equals(this._payload, abstractVendorMessage._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, outputStream);
        ByteOrder.short2leb((short)this._version, outputStream);
        this.writeVendorPayload(outputStream);
    }

    protected void writeVendorPayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.getPayload());
    }
}

