/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.QueryRequestImpl;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.Set;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueryRequestFactoryImpl
implements QueryRequestFactory {
    private final NetworkManager networkManager;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;

    @Inject
    public QueryRequestFactoryImpl(NetworkManager networkManager, LimeXMLDocumentFactory limeXMLDocumentFactory, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        this.networkManager = networkManager;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.MACCalculatorRepositoryManager = mACCalculatorRepositoryManager;
    }

    @Override
    public QueryRequest createRequery(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        UrnSet urnSet = new UrnSet(uRN);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(true), (byte)6, "\\", "", urnSet, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        UrnSet urnSet = new UrnSet(uRN);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, "\\", "", urnSet, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(URN uRN, String string) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            string = "\\";
        }
        UrnSet urnSet = new UrnSet(uRN);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, string, "", urnSet, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createRequery(URN uRN, byte by) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (by <= 0 || by > 6) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        UrnSet urnSet = new UrnSet(uRN);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(true), by, "\\", "", urnSet, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(Set<? extends URN> set) {
        if (set == null) {
            throw new NullPointerException("null urnSet");
        }
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, "\\", "", set, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createRequery(String string) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return this.create(QueryRequestImpl.newQueryGUID(true), string);
    }

    @Override
    public QueryRequest createQuery(String string) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), string);
    }

    @Override
    public QueryRequest createOutOfBandQuery(byte[] byArray, String string, String string2) {
        string = I18NConvert.instance().getNorm(string);
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(byArray, (byte)6, string, string2, true);
    }

    @Override
    public QueryRequest createOutOfBandQuery(byte[] byArray, String string, String string2, MediaType mediaType) {
        string = I18NConvert.instance().getNorm(string);
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(byArray, (byte)6, string, string2, true, mediaType);
    }

    @Override
    public QueryRequest createOutOfBandQuery(String string, byte[] byArray, int n) {
        byte[] byArray2 = GUID.makeAddressEncodedGuid(byArray, n);
        return this.createOutOfBandQuery(byArray2, string, "");
    }

    @Override
    public QueryRequest createWhatIsNewQuery(byte[] byArray, byte by) {
        return this.createWhatIsNewQuery(byArray, by, null);
    }

    @Override
    public QueryRequest createWhatIsNewQuery(byte[] byArray, byte by, MediaType mediaType) {
        if (by < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return this.createQueryRequest(byArray, by, "WhatIsNewXOXO", "", null, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 1, false, this.getMetaFlag(mediaType));
    }

    @Override
    public QueryRequest createWhatIsNewOOBQuery(byte[] byArray, byte by) {
        return this.createWhatIsNewOOBQuery(byArray, by, null);
    }

    @Override
    public QueryRequest createWhatIsNewOOBQuery(byte[] byArray, byte by, MediaType mediaType) {
        if (by < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return this.createQueryRequest(byArray, by, "WhatIsNewXOXO", "", null, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, true, 1, false, this.getMetaFlag(mediaType));
    }

    @Override
    public QueryRequest createQuery(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), string, string2);
    }

    @Override
    public QueryRequest createQuery(String string, byte by) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (by <= 0 || by > 6) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), by, string);
    }

    @Override
    public QueryRequest createQuery(byte[] byArray, String string, String string2) {
        string = I18NConvert.instance().getNorm(string);
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(byArray, string, string2);
    }

    @Override
    public QueryRequest createQuery(byte[] byArray, String string, String string2, MediaType mediaType) {
        string = I18NConvert.instance().getNorm(string);
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(byArray, (byte)6, string, string2, mediaType);
    }

    @Override
    public QueryRequest createProxyQuery(QueryRequest queryRequest, byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + byArray.length);
        }
        byte[] byArray2 = queryRequest.getPayload();
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        byArray3[0] = SearchSettings.DISABLE_OOB_V2.getBoolean() ? (byte)(byArray3[0] & 0xFFFFFFFB) : (byte)(byArray3[0] | 4);
        GGEP gGEP = new GGEP(true);
        gGEP.put("SO");
        try {
            byArray3 = QueryRequestImpl.patchInGGEP(byArray3, gGEP, this.MACCalculatorRepositoryManager);
            return this.createNetworkQuery(byArray, queryRequest.getTTL(), queryRequest.getHops(), byArray3, queryRequest.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException(badPacketException.getMessage());
        }
    }

    @Override
    public QueryRequest createDoNotProxyQuery(QueryRequest queryRequest) {
        if (!GUID.isLimeGUID(queryRequest.getGUID())) {
            throw new IllegalArgumentException("query request from different vendor cannot not be unmarked");
        }
        if (!queryRequest.isOriginated()) {
            throw new IllegalArgumentException("query not originated from here");
        }
        return this.createQueryRequest(queryRequest.getGUID(), queryRequest.getTTL(), queryRequest.getMinSpeed(), queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getQueryUrns(), queryRequest.getQueryKey(), queryRequest.isFirewalledSource(), queryRequest.getNetwork(), queryRequest.desiresOutOfBandReplies(), queryRequest.getFeatureSelector(), true, queryRequest.getMetaMask(), false);
    }

    @Override
    public QueryRequest createQuery(QueryRequest queryRequest, byte by) {
        try {
            return this.createNetworkQuery(queryRequest.getGUID(), by, queryRequest.getHops(), queryRequest.getPayload(), queryRequest.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException(badPacketException.getMessage());
        }
    }

    @Override
    public QueryRequest unmarkOOBQuery(QueryRequest queryRequest) {
        if (!GUID.isLimeGUID(queryRequest.getGUID())) {
            throw new IllegalArgumentException("query request from different vendor cannot not be unmarked");
        }
        return this.createQueryRequest(queryRequest.getGUID(), queryRequest.getTTL(), queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getQueryUrns(), queryRequest.getQueryKey(), queryRequest.isFirewalledSource(), queryRequest.getNetwork(), false, queryRequest.getFeatureSelector(), queryRequest.doNotProxy(), queryRequest.getMetaMask());
    }

    @Override
    public QueryRequest createQueryKeyQuery(String string, AddressSecurityToken addressSecurityToken) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (addressSecurityToken == null) {
            throw new NullPointerException("null query key");
        }
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, string, "", URN.NO_URN_SET, addressSecurityToken, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQueryKeyQuery(URN uRN, AddressSecurityToken addressSecurityToken) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (addressSecurityToken == null) {
            throw new NullPointerException("null query key");
        }
        UrnSet urnSet = new UrnSet(uRN);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, "\\", "", urnSet, addressSecurityToken, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createMulticastQuery(byte[] byArray, QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        byte[] byArray2 = queryRequest.getPayload();
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        byArray3[0] = (byte)(byArray3[0] & 0xFFFFFFFB);
        byArray3[0] = (byte)(byArray3[0] | 0x20);
        try {
            return this.createNetworkQuery(byArray, (byte)1, queryRequest.getHops(), byArray3, Message.Network.MULTICAST);
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException(badPacketException.getMessage());
        }
    }

    @Override
    public QueryRequest createQueryKeyQuery(QueryRequest queryRequest, AddressSecurityToken addressSecurityToken) {
        return this.createQueryRequest(queryRequest.getGUID(), queryRequest.getTTL(), queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getQueryUrns(), addressSecurityToken, queryRequest.isFirewalledSource(), Message.Network.UNKNOWN, queryRequest.desiresOutOfBandReplies(), queryRequest.getFeatureSelector(), false, queryRequest.getMetaMask());
    }

    @Override
    public QueryRequest createBrowseHostQuery() {
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, "    ", "", URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0, false);
    }

    @Override
    public QueryRequest createNonFirewalledQuery(String string, byte by) {
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), by, string, "", URN.NO_URN_SET, null, false, Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createNetworkQuery(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
        return new QueryRequestImpl(byArray, by, by2, byArray2, network, this.limeXMLDocumentFactory, this.MACCalculatorRepositoryManager);
    }

    private QueryRequest create(byte[] byArray, String string) {
        return this.create(byArray, string, "");
    }

    private QueryRequest create(byte[] byArray, byte by, String string) {
        return this.create(byArray, by, string, "");
    }

    private QueryRequest create(byte[] byArray, String string, String string2) {
        return this.create(byArray, (byte)6, string, string2);
    }

    private QueryRequest create(byte[] byArray, byte by, String string, String string2) {
        return this.createQueryRequest(byArray, by, string, string2, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    private QueryRequest create(byte[] byArray, byte by, String string, String string2, MediaType mediaType) {
        return this.createQueryRequest(byArray, by, string, string2, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, this.getMetaFlag(mediaType));
    }

    private QueryRequest create(byte[] byArray, byte by, String string, String string2, boolean bl) {
        return this.createQueryRequest(byArray, by, string, string2, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, bl, 0, false, 0);
    }

    private QueryRequest create(byte[] byArray, byte by, String string, String string2, boolean bl, MediaType mediaType) {
        return this.createQueryRequest(byArray, by, string, string2, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, bl, 0, false, this.getMetaFlag(mediaType));
    }

    private int getMetaFlag(MediaType mediaType) {
        int n = 0;
        if (mediaType != null) {
            if (mediaType == MediaType.getAudioMediaType()) {
                n |= 4;
            } else if (mediaType == MediaType.getVideoMediaType()) {
                n |= 8;
            } else if (mediaType == MediaType.getImageMediaType()) {
                n |= 0x20;
            } else if (mediaType == MediaType.getDocumentMediaType()) {
                n |= 0x10;
            } else if (mediaType == MediaType.getProgramMediaType()) {
                n = OSUtils.isLinux() || OSUtils.isAnyMac() ? (n |= 0x80) : (OSUtils.isWindows() ? (n |= 0x40) : (n |= 0xC0));
            }
        }
        return n;
    }

    @Override
    public QueryRequest createQueryRequest(byte[] byArray, byte by, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n) {
        return this.createQueryRequest(byArray, by, string, string2, set, addressSecurityToken, bl, network, bl2, n, false, 0);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] byArray, byte by, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n, boolean bl3, int n2) {
        return this.createQueryRequest(byArray, by, 0, string, string2, set, addressSecurityToken, bl, network, bl2, n, bl3, n2, true);
    }

    private QueryRequest createQueryRequest(byte[] byArray, byte by, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n, boolean bl3, int n2, boolean bl4) {
        return this.createQueryRequest(byArray, by, 0, string, string2, set, addressSecurityToken, bl, network, bl2, n, bl3, n2, bl4);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] byArray, byte by, int n, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n2, boolean bl3, int n3) {
        return this.createQueryRequest(byArray, by, n, string, string2, set, addressSecurityToken, bl, network, bl2, n2, bl3, n3, true);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] byArray, byte by, int n, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n2, boolean bl3, int n3, boolean bl4) {
        return new QueryRequestImpl(byArray, by, n, string, string2, set, addressSecurityToken, bl, network, bl2, n2, bl3, n3, bl4, this.networkManager.canDoFWT(), this.limeXMLDocumentFactory);
    }
}

