/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryReplyImpl;
import com.limegroup.gnutella.search.HostDataFactory;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.security.SecurityToken;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueryReplyFactoryImpl
implements QueryReplyFactory {
    private final HostDataFactory hostDataFactory;
    private final ResponseFactory responseFactory;

    @Inject
    public QueryReplyFactoryImpl(HostDataFactory hostDataFactory, ResponseFactory responseFactory) {
        this.hostDataFactory = hostDataFactory;
        this.responseFactory = responseFactory;
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl) {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, false, false, false, false, false, false, true, bl, false, IpPort.EMPTY_SET, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, DataUtils.EMPTY_BYTE_ARRAY, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, IpPort.EMPTY_SET, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IllegalArgumentException {
        return this.createQueryReply(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, bl, bl2, bl3, bl4, bl5, bl6, IpPort.EMPTY_SET);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Set<? extends IpPort> set) throws IllegalArgumentException {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, set, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Set<? extends IpPort> set, SecurityToken securityToken) throws IllegalArgumentException {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, false, set, securityToken);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Set<? extends IpPort> set) throws IllegalArgumentException {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, set, null);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, Set<? extends IpPort> set, SecurityToken securityToken) throws IllegalArgumentException {
        return this.createInternal(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, true, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, set, securityToken);
    }

    @Override
    public QueryReply createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        return this.createFromNetwork(byArray, by, by2, byArray2, Message.Network.UNKNOWN);
    }

    @Override
    public QueryReply createQueryReply(byte[] byArray, QueryReply queryReply) {
        try {
            return this.createFromNetwork(byArray, queryReply.getTTL(), queryReply.getHops(), queryReply.getPayload());
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException("Invalid QR", badPacketException);
        }
    }

    @Override
    public QueryReply createWithNewAddress(byte[] byArray, QueryReply queryReply) {
        if (Arrays.equals(byArray, queryReply.getIPBytes())) {
            return queryReply;
        }
        byte[] byArray2 = (byte[])queryReply.getPayload().clone();
        System.arraycopy(byArray, 0, byArray2, 3, 4);
        try {
            return this.createFromNetwork(queryReply.getGUID(), queryReply.getTTL(), queryReply.getHops(), byArray2);
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException("Invalid QR", badPacketException);
        }
    }

    QueryReply createWithNewGGEP(QueryReplyImpl queryReplyImpl, byte[] byArray) {
        byte by;
        int n = queryReplyImpl.getQHDOffset();
        if (n == -1) {
            return queryReplyImpl;
        }
        byte[] byArray2 = queryReplyImpl.getPayload();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(queryReplyImpl.getPayload(), 0, n);
        int n2 = ByteOrder.ubyte2int(byArray2[n]);
        if (n2 == 1) {
            byteArrayOutputStream.write(2);
            by = byArray2[n + 1];
            by = (byte)(by | 0x20);
            byteArrayOutputStream.write(by);
            byteArrayOutputStream.write(by);
        } else {
            byteArrayOutputStream.write(n2);
            by = (byte)(byArray2[n + 1] | 0x20);
            byte by2 = (byte)(byArray2[n + 2] | 0x20);
            byteArrayOutputStream.write(by);
            byteArrayOutputStream.write(by2);
            byteArrayOutputStream.write(byArray2, n + 3, n2 - 2);
        }
        try {
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            return queryReplyImpl;
        }
        if (queryReplyImpl.getGGEPEnd() != -1) {
            byteArrayOutputStream.write(byArray2, queryReplyImpl.getGGEPEnd(), byArray2.length - queryReplyImpl.getGGEPEnd());
        } else {
            byteArrayOutputStream.write(byArray2, byArray2.length - 16, 16);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        try {
            return this.createFromNetwork(queryReplyImpl.getGUID(), queryReplyImpl.getTTL(), queryReplyImpl.getHops(), byArray3, queryReplyImpl.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            throw new RuntimeException(badPacketException);
        }
    }

    @Override
    public QueryReply createWithReturnPathInfo(QueryReply queryReply, IpPort ipPort, IpPort ipPort2) {
        GGEP gGEP;
        QueryReplyImpl queryReplyImpl = (QueryReplyImpl)queryReply;
        byte[] byArray = queryReplyImpl.getPayload();
        if (queryReplyImpl.getGGEPStart() != -1 && queryReplyImpl.getGGEPEnd() != -1) {
            try {
                gGEP = new GGEP(byArray, queryReplyImpl.getGGEPStart());
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                return queryReplyImpl;
            }
        } else {
            gGEP = new GGEP();
        }
        this.addReturnPathInfo(ipPort, ipPort2, queryReplyImpl.getHops(), queryReplyImpl.getTTL(), gGEP);
        return this.createWithNewGGEP(queryReplyImpl, gGEP.toByteArray());
    }

    private void addReturnPathInfo(IpPort ipPort, IpPort ipPort2, byte by, byte by2, GGEP gGEP) {
        byte[] byArray;
        String string = this.getReturnPathSuffix(gGEP);
        if (string == null) {
            return;
        }
        if (ipPort != null) {
            byArray = new byte[6];
            System.arraycopy(ipPort.getInetAddress().getAddress(), 0, byArray, 0, 4);
            ByteOrder.short2beb((short)ipPort.getPort(), byArray, 4);
            gGEP.put("RPI" + string, byArray);
        }
        byArray = new byte[6];
        System.arraycopy(ipPort2.getInetAddress().getAddress(), 0, byArray, 0, 4);
        ByteOrder.short2beb((short)ipPort2.getPort(), byArray, 4);
        gGEP.put("RPS" + string, byArray);
        gGEP.put("RPH" + string, by);
        gGEP.put("RPT" + string, by2);
    }

    private String getReturnPathSuffix(GGEP gGEP) {
        for (int i = 0; i < 100000; ++i) {
            if (gGEP.hasKey("RPI" + i) || gGEP.hasKey("RPS" + i) || gGEP.hasKey("RPH" + i) || gGEP.hasKey("RPT" + i)) continue;
            return String.valueOf(i);
        }
        return null;
    }

    @Override
    public QueryReply createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
        return new QueryReplyImpl(byArray, by, by2, byArray2, network, this.hostDataFactory, this.responseFactory);
    }

    private QueryReply createInternal(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, Set<? extends IpPort> set, SecurityToken securityToken) {
        return new QueryReplyImpl(byArray, by, n, byArray2, l, responseArray, byArray3, byArray4, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, set, securityToken, this.hostDataFactory, this.responseFactory);
    }
}

