/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.MessageParserBinder;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.net.SocketAddress;
import org.limewire.inspection.InspectablePrimitive;

@Singleton
public class MessageParserBinderImpl
implements MessageParserBinder {
    private final PingReplyFactory pingReplyFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final QueryRequestFactory queryRequestFactory;
    private final VendorMessageFactory vendorMessageFactory;
    private final PingRequestFactory pingRequestFactory;
    @InspectablePrimitive(value="bad hops messages")
    private static volatile long badHops;
    @InspectablePrimitive(value="bad ttl messages")
    private static volatile long badTTL;
    @InspectablePrimitive(value="high hops messages")
    private static volatile long highHops;
    @InspectablePrimitive(value="adjusted ttl messages")
    private static volatile long adjustings;
    @InspectablePrimitive(value="parsed messages")
    private static volatile long parsings;

    @Inject
    public MessageParserBinderImpl(PingReplyFactory pingReplyFactory, QueryRequestFactory queryRequestFactory, QueryReplyFactory queryReplyFactory, VendorMessageFactory vendorMessageFactory, PingRequestFactory pingRequestFactory) {
        this.pingReplyFactory = pingReplyFactory;
        this.queryRequestFactory = queryRequestFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.vendorMessageFactory = vendorMessageFactory;
        this.pingRequestFactory = pingRequestFactory;
    }

    public void bind(MessageFactory messageFactory) {
        messageFactory.setParser((byte)0, new PingRequestParser());
        messageFactory.setParser((byte)1, new PingReplyParser());
        messageFactory.setParser((byte)-128, new QueryRequestParser());
        messageFactory.setParser((byte)-127, new QueryReplyParser());
        messageFactory.setParser((byte)64, new PushRequestParser());
        messageFactory.setParser((byte)48, new RouteTableUpdateParser());
        messageFactory.setParser((byte)49, new VendorMessageParser());
        messageFactory.setParser((byte)50, new VendorMessageStableParser());
    }

    private class VendorMessageStableParser
    extends GnutellaMessageParser {
        private VendorMessageStableParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.vendorMessageFactory.deriveVendorMessage(byArray, by, by2, byArray2, network);
        }
    }

    private class VendorMessageParser
    extends GnutellaMessageParser {
        private VendorMessageParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.vendorMessageFactory.deriveVendorMessage(byArray, by, by2, byArray2, network);
        }
    }

    private static class RouteTableUpdateParser
    extends GnutellaMessageParser {
        private RouteTableUpdateParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return RouteTableMessage.read(byArray, by, by2, byArray2, network);
        }
    }

    private static class PushRequestParser
    extends GnutellaMessageParser {
        private PushRequestParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new PushRequestImpl(byArray, by, by2, byArray2, network);
        }
    }

    private class QueryReplyParser
    extends GnutellaMessageParser {
        private QueryReplyParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            if (byArray2.length < 26) {
                throw new BadPacketException("Query reply too short: " + byArray2.length);
            }
            return MessageParserBinderImpl.this.queryReplyFactory.createFromNetwork(byArray, by, by2, byArray2, network);
        }
    }

    private class QueryRequestParser
    extends GnutellaMessageParser {
        private QueryRequestParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            if (byArray2.length < 3) {
                throw new BadPacketException("Query request too short: " + byArray2.length);
            }
            return MessageParserBinderImpl.this.queryRequestFactory.createNetworkQuery(byArray, by, by2, byArray2, network);
        }
    }

    private class PingReplyParser
    extends GnutellaMessageParser {
        private PingReplyParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.pingReplyFactory.createFromNetwork(byArray, by, by2, byArray2, network);
        }
    }

    private class PingRequestParser
    extends GnutellaMessageParser {
        private PingRequestParser() {
        }

        protected Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
            return MessageParserBinderImpl.this.pingRequestFactory.createFromNetwork(byArray, by, by2, byArray2, network);
        }
    }

    public static abstract class GnutellaMessageParser
    implements MessageFactory.MessageParser {
        public Message parse(byte[] byArray, byte[] byArray2, Message.Network network, byte by, SocketAddress socketAddress) throws BadPacketException, IOException {
            byte by2 = byArray[16];
            byte by3 = byArray[17];
            byte by4 = byArray[18];
            if (by4 < 0) {
                badHops++;
                throw new BadPacketException("Negative (or very large) hops");
            }
            if (by3 < 0) {
                badTTL++;
                throw new BadPacketException("Negative (or very large) TTL");
            }
            if (by4 > by && by2 != 1) {
                highHops++;
                throw new BadPacketException("func: " + by2 + ", ttl: " + by3 + ", hops: " + by4);
            }
            if (by3 + by4 > by && by2 != 1) {
                adjustings++;
                by3 = (byte)(by - by4);
                assert (by3 >= 0);
            } else {
                parsings++;
            }
            byte[] byArray3 = new byte[16];
            System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
            return this.parse(byArray3, by3, by4, byArray2, network);
        }

        protected abstract Message parse(byte[] var1, byte var2, byte var3, byte[] var4, Message.Network var5) throws BadPacketException;
    }
}

