/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.messagehandlers.RestrictedResponder;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.InspectionResponse;
import com.limegroup.gnutella.messages.vendor.InspectionResponseFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.collection.Periodic;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionRequestHandler
extends RestrictedResponder {
    private final Provider<MessageRouter> router;
    private final InspectionResponseFactory factory;
    private final Periodic sender;
    private final List<InspectionResponse> queue = new LinkedList<InspectionResponse>();
    private ReplyHandler currentHandler;
    private int currentInterval;

    @Inject
    public InspectionRequestHandler(Provider<MessageRouter> provider, NetworkManager networkManager, UDPReplyHandlerFactory uDPReplyHandlerFactory, UDPReplyHandlerCache uDPReplyHandlerCache, InspectionResponseFactory inspectionResponseFactory, @Named(value="inspection") SecureMessageVerifier secureMessageVerifier, @Named(value="messageExecutor") ExecutorService executorService, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, NetworkInstanceUtils networkInstanceUtils) {
        super(FilterSettings.INSPECTOR_IP_ADDRESSES, secureMessageVerifier, MessageSettings.INSPECTION_VERSION, networkManager, uDPReplyHandlerFactory, uDPReplyHandlerCache, executorService, networkInstanceUtils);
        this.router = provider;
        this.factory = inspectionResponseFactory;
        this.sender = new Periodic(new Runnable(){

            public void run() {
                InspectionRequestHandler.this.send();
            }
        }, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processAllowedMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        assert (message instanceof InspectionRequest);
        InspectionRequest inspectionRequest = (InspectionRequest)message;
        InspectionResponse[] inspectionResponseArray = this.factory.createResponses(inspectionRequest);
        if (inspectionResponseArray.length > 0 && inspectionResponseArray[0].shouldBeSent()) {
            replyHandler.reply(inspectionResponseArray[0]);
        }
        this.router.get().forwardInspectionRequestToLeaves(inspectionRequest);
        InspectionRequestHandler inspectionRequestHandler = this;
        synchronized (inspectionRequestHandler) {
            this.queue.clear();
            if (inspectionResponseArray.length < 2) {
                return;
            }
            for (int i = 1; i < inspectionResponseArray.length; ++i) {
                this.queue.add(inspectionResponseArray[i]);
            }
            this.currentHandler = replyHandler;
            this.currentInterval = inspectionRequest.getSendInterval();
        }
        this.sender.rescheduleIfSooner(this.currentInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send() {
        int n;
        InspectionResponse inspectionResponse = null;
        ReplyHandler replyHandler = null;
        InspectionRequestHandler inspectionRequestHandler = this;
        synchronized (inspectionRequestHandler) {
            if (!this.queue.isEmpty()) {
                inspectionResponse = this.queue.remove(0);
                replyHandler = this.currentHandler;
            }
            n = this.currentInterval;
        }
        if (inspectionResponse == null || replyHandler == null) {
            this.sender.unschedule();
            return;
        }
        if (inspectionResponse.shouldBeSent()) {
            replyHandler.reply(inspectionResponse);
        }
        this.sender.rescheduleIfLater(n);
    }
}

