/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class HTTPRequestMethod {
    private final String METHOD_NAME;
    public static final HTTPRequestMethod GET = new HTTPRequestMethod("GET"){

        public void writeHttpResponse(HTTPMessage hTTPMessage, OutputStream outputStream) throws IOException {
            if (hTTPMessage == null) {
                throw new NullPointerException("cannot write null response object");
            }
            if (outputStream == null) {
                throw new NullPointerException("cannot write to null output stream");
            }
            hTTPMessage.writeMessageHeaders(outputStream);
            hTTPMessage.writeMessageBody(outputStream);
            outputStream.flush();
        }
    };
    public static final HTTPRequestMethod HEAD = new HTTPRequestMethod("HEAD"){

        public void writeHttpResponse(HTTPMessage hTTPMessage, OutputStream outputStream) throws IOException {
            if (hTTPMessage == null) {
                throw new NullPointerException("cannot write null response object");
            }
            if (outputStream == null) {
                throw new NullPointerException("cannot write to null output stream");
            }
            hTTPMessage.writeMessageHeaders(outputStream);
            outputStream.flush();
        }
    };

    private HTTPRequestMethod(String string) {
        this.METHOD_NAME = string.toUpperCase();
    }

    public String getMethod() {
        return this.METHOD_NAME;
    }

    public abstract void writeHttpResponse(HTTPMessage var1, OutputStream var2) throws IOException;

    public String toString() {
        return "HTTPRequestMethod: " + this.METHOD_NAME;
    }
}

