/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AltLocUtils;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.Function;
import org.limewire.http.HeaderInterceptor;

public class AltLocHeaderInterceptor
implements HeaderInterceptor {
    private final HTTPUploader uploader;
    private final AltLocManager altLocManager;
    private final AlternateLocationFactory alternateLocationFactory;

    public AltLocHeaderInterceptor(HTTPUploader hTTPUploader, AltLocManager altLocManager, AlternateLocationFactory alternateLocationFactory) {
        this.uploader = hTTPUploader;
        this.altLocManager = altLocManager;
        this.alternateLocationFactory = alternateLocationFactory;
    }

    public void process(Header header, HttpContext httpContext) throws HttpException, IOException {
        if (HTTPHeaderName.ALT_LOCATION.matches(header)) {
            this.parseAlternateLocations(this.uploader.getAltLocTracker(), header.getValue(), true, true);
        } else if (HTTPHeaderName.NALTS.matches(header)) {
            this.parseAlternateLocations(this.uploader.getAltLocTracker(), header.getValue(), false, false);
        } else if (HTTPHeaderName.FALT_LOCATION.matches(header)) {
            AltLocTracker altLocTracker = this.uploader.getAltLocTracker();
            this.parseAlternateLocations(altLocTracker, header.getValue(), true, false);
            altLocTracker.setWantsFAlts(true);
        } else if (HTTPHeaderName.BFALT_LOCATION.matches(header)) {
            AltLocTracker altLocTracker = this.uploader.getAltLocTracker();
            this.parseAlternateLocations(altLocTracker, header.getValue(), false, false);
            altLocTracker.setWantsFAlts(false);
        }
    }

    private void parseAlternateLocations(final AltLocTracker altLocTracker, String string, final boolean bl, boolean bl2) {
        AltLocUtils.parseAlternateLocations(altLocTracker.getUrn(), string, bl2, this.alternateLocationFactory, new Function<AlternateLocation, Void>(){

            @Override
            public Void apply(AlternateLocation alternateLocation) {
                if (alternateLocation instanceof PushAltLoc) {
                    ((PushAltLoc)alternateLocation).updateProxies(bl);
                }
                if (bl) {
                    AltLocHeaderInterceptor.this.altLocManager.add(alternateLocation, null);
                } else {
                    AltLocHeaderInterceptor.this.altLocManager.remove(alternateLocation, null);
                }
                altLocTracker.addLocation(alternateLocation);
                return null;
            }
        });
    }
}

