/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.MetaEditor;
import com.limegroup.gnutella.gui.xml.editor.application.ApplicationTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.document.DocumentTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.image.ImageTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.video.VideoTabbedPane;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class XmlTypeEditor
extends MetaEditor {
    private static final String SELECTION_PANEL = "SELECTION_PANEL";
    private static final String TABBED_PANEL = "TABBED_PANEL";
    private JPanel cardPanel;
    private JPanel selectionPanel;
    private JButton backButton;
    private String[] schemas;
    private JList schemaList;

    public XmlTypeEditor(Frame frame, FileDesc[] fileDescArray, String string) {
        super(frame, fileDescArray, string);
        LimeXMLSchema limeXMLSchema = this.hasXMLSelected();
        if (limeXMLSchema != null) {
            this.createAndDisplayTab(limeXMLSchema);
        }
    }

    protected void initCenterPanel() {
        this.cardPanel = new JPanel(new CardLayout());
        this.cardPanel.add((Component)this.getSelectionPanel(), SELECTION_PANEL);
        this.add((Component)this.cardPanel, "Center");
    }

    private JPanel getSelectionPanel() {
        this.selectionPanel = new JPanel();
        this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.selectionPanel.setLayout(new BoxLayout(this.selectionPanel, 1));
        JLabel jLabel = new JLabel(I18n.tr("Unknown file type. Please choose the type that best describes this file."));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.selectionPanel.add(jLabel);
        this.schemas = this.getSchemaList();
        String[] stringArray = new String[this.schemas.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = XMLUtils.getTitleForSchemaURI(this.schemas[i]);
        }
        this.schemaList = new JList<String>(stringArray);
        this.schemaList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.schemaList);
        this.selectionPanel.add(jScrollPane);
        return this.selectionPanel;
    }

    protected void initSouthPanel() {
        super.initSouthPanel();
        JPanel jPanel = new JPanel();
        this.backButton = new JButton(I18n.tr("Back"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XmlTypeEditor.this.backAction();
            }
        });
        jPanel.add(this.backButton);
        this.okButton.setText(I18n.tr("Next"));
        this.southPanel.add((Component)jPanel, "West");
    }

    protected void saveAndDisposeWindow() {
        if (this.selectionPanel.isVisible()) {
            int n = this.schemaList.getSelectedIndex();
            if (n > -1) {
                LimeXMLSchemaRepository limeXMLSchemaRepository = GuiCoreMediator.getLimeXMLSchemaRepository();
                LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(this.schemas[n]);
                this.createAndDisplayTab(limeXMLSchema);
            }
        } else {
            for (int i = 0; i < this.fds.length; ++i) {
                List<LimeXMLDocument> list = this.fds[i].getLimeXMLDocuments();
                for (LimeXMLDocument limeXMLDocument : list) {
                    if (limeXMLDocument == null) continue;
                    String string = limeXMLDocument.getSchemaURI();
                    SchemaReplyCollectionMapper schemaReplyCollectionMapper = GuiCoreMediator.getSchemaReplyCollectionMapper();
                    LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
                    assert (limeXMLReplyCollection != null) : "Trying to remove data from a non-existent collection";
                    limeXMLReplyCollection.removeDoc(this.fds[i]);
                }
            }
            MetaDataSaver metaDataSaver = new MetaDataSaver(this.tabbedPane.getFileDesc(), this.tabbedPane.getSchema(), this.tabbedPane.getInput());
            metaDataSaver.saveMetaData();
            this.disposeWindow();
        }
    }

    private LimeXMLSchema hasXMLSelected() {
        for (int i = 0; i < this.fds.length; ++i) {
            LimeXMLDocument limeXMLDocument = this.fds[i].getXMLDocument();
            if (limeXMLDocument == null) continue;
            limeXMLDocument.getXMLString();
            return limeXMLDocument.getSchema();
        }
        return null;
    }

    private String[] getSchemaList() {
        LimeXMLSchemaRepository limeXMLSchemaRepository = GuiCoreMediator.getLimeXMLSchemaRepository();
        return limeXMLSchemaRepository.getAvailableSchemaURIs();
    }

    private void createAndDisplayTab(LimeXMLSchema limeXMLSchema) {
        this.createTabs(limeXMLSchema);
        this.cardPanel.add((Component)this.tabbedPane, TABBED_PANEL);
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, TABBED_PANEL);
        this.pack();
        this.backButton.setEnabled(true);
        this.okButton.setText(I18n.tr("OK"));
    }

    private void createTabs(LimeXMLSchema limeXMLSchema) {
        if (limeXMLSchema.getDescription().equals("audio")) {
            if (!(this.tabbedPane instanceof AudioTabbedPane)) {
                this.tabbedPane = new AudioTabbedPane(this.fds);
            }
        } else if (limeXMLSchema.getDescription().equals("video")) {
            if (!(this.tabbedPane instanceof VideoTabbedPane)) {
                this.tabbedPane = new VideoTabbedPane(this.fds);
            }
        } else if (limeXMLSchema.getDescription().equals("application")) {
            if (!(this.tabbedPane instanceof ApplicationTabbedPane)) {
                this.tabbedPane = new ApplicationTabbedPane(this.fds);
            }
        } else if (limeXMLSchema.getDescription().equals("document")) {
            if (!(this.tabbedPane instanceof DocumentTabbedPane)) {
                this.tabbedPane = new DocumentTabbedPane(this.fds);
            }
        } else if (limeXMLSchema.getDescription().equals("image") && !(this.tabbedPane instanceof ImageTabbedPane)) {
            this.tabbedPane = new ImageTabbedPane(this.fds);
        }
    }

    private void backAction() {
        if (this.selectionPanel.isVisible()) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show(this.cardPanel, SELECTION_PANEL);
        this.okButton.setText(I18n.tr("Next"));
        this.backButton.setEnabled(false);
    }
}

