/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailsPanel
extends JPanel {
    private Font boldFont = null;
    private List<NameValue<String>> list = new ArrayList<NameValue<String>>();

    public DetailsPanel() {
    }

    public DetailsPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    private void add(String string, String string2) {
        this.list.add(new NameValue<String>(string, string2));
    }

    public void initWithFileDesc(FileDesc fileDesc, String string) {
        Object object;
        Object object2;
        String string2 = MetaEditorUtil.getKind(fileDesc.getFile());
        if (string2 != null) {
            this.add(I18n.tr("Kind:"), string2);
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = GuiCoreMediator.getSchemaReplyCollectionMapper();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(fileDesc.getSHA1Urn());
        LimeXMLSchemaRepository limeXMLSchemaRepository = GuiCoreMediator.getLimeXMLSchemaRepository();
        LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(string);
        if (limeXMLDocument != null) {
            for (SchemaFieldInfo object32 : limeXMLSchema.getCanonicalizedFields()) {
                object2 = object32.getCanonicalizedFieldName();
                if (DetailsPanel.skipField((String)object2) || (object = limeXMLDocument.getValue((String)object2)) == null || ((String)object).equals("")) continue;
                String string3 = MetaEditorUtil.getStringResource((String)object2);
                this.add(string3, (String)object);
            }
        }
        Object object4 = I18n.tr("Size:");
        String string4 = GUIUtils.toUnitbytes(fileDesc.getFileSize());
        this.add((String)object4, string4);
        object4 = I18n.tr("Date Modified:");
        String string5 = GUIUtils.msec2DateTime(fileDesc.lastModified());
        this.list.add(new NameValue<String>((String)object4, string5));
        object2 = new GridBagLayout();
        this.setLayout((LayoutManager)object2);
        object = new GridBagConstraints();
        for (NameValue nameValue : this.list) {
            this.addLabel(nameValue, (GridBagLayout)object2, (GridBagConstraints)object);
        }
    }

    protected void addLabel(NameValue<String> nameValue, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Serializable serializable;
        JLabel jLabel = new JLabel(nameValue.getKey(), 11);
        if (this.boldFont == null) {
            serializable = jLabel.getFont();
            this.boldFont = new Font(serializable.getName(), 1, serializable.getSize());
        }
        jLabel.setFont(this.boldFont);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 3);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        serializable = new MultiLineLabel(nameValue.getValue(), 300);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints((Component)serializable, gridBagConstraints);
        this.add((Component)serializable);
    }

    private static boolean skipField(String string) {
        if (string.equals("audios__audio__title__")) {
            return true;
        }
        if (string.equals("audios__audio__artist__")) {
            return true;
        }
        if (string.equals("audios__audio__album__")) {
            return true;
        }
        if (string.equals("audios__audio__seconds__")) {
            return true;
        }
        if (string.equals("audios__audio__comments__")) {
            return true;
        }
        return !MetaEditorUtil.contains(string);
    }
}

