/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLNames;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    private static final Log LOG = LogFactory.getLog(XMLUtils.class);
    private static Map<String, ResourceBundle> bundles;

    private XMLUtils() {
    }

    public static List<String> getDisplayList(LimeXMLDocument limeXMLDocument) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LimeXMLSchema limeXMLSchema = limeXMLDocument.getSchema();
        List<SchemaFieldInfo> list = limeXMLSchema.getCanonicalizedFields();
        for (SchemaFieldInfo schemaFieldInfo : list) {
            String string = schemaFieldInfo.getCanonicalizedFieldName();
            String string2 = limeXMLDocument.getValue(string);
            if (string2 == null || schemaFieldInfo.isHidden()) continue;
            NameValue<String> nameValue = XMLUtils.getDisplayPair(schemaFieldInfo, string2, limeXMLSchema);
            linkedList.add(nameValue.getName() + ": " + nameValue.getValue());
        }
        return linkedList;
    }

    public static NameValue<String> getDisplayPair(SchemaFieldInfo schemaFieldInfo, String string, LimeXMLSchema limeXMLSchema) {
        String string2 = XMLUtils.getResource(schemaFieldInfo.getCanonicalizedFieldName());
        string = XMLUtils.getDisplay(schemaFieldInfo, string);
        return new NameValue<String>(string2, string);
    }

    public static String getDisplay(SchemaFieldInfo schemaFieldInfo, String string) {
        if (schemaFieldInfo.getJavaType() == Date.class) {
            try {
                string = CommonUtils.seconds2time(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            string = LimeXMLUtils.unencodeXML(string);
        }
        return string;
    }

    public static Comparable<?> getComparable(SchemaFieldInfo schemaFieldInfo, String string) {
        if (schemaFieldInfo == null || string == null) {
            return null;
        }
        if (schemaFieldInfo.getJavaType() == Integer.class || schemaFieldInfo.getJavaType() == Date.class) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return string;
    }

    public static String getResource(String string) {
        String string2 = LimeXMLNames.getDisplayName(string);
        if (string2 != null) {
            return I18n.tr(string2);
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Missing resource for '" + string + "', falling back to default");
        }
        return XMLUtils.fallbackResource(string, XMLUtils.getBundleForField(string));
    }

    public static String getTitleForSchemaFromField(String string) {
        if (!string.endsWith("__")) {
            return null;
        }
        int n = string.indexOf("__") + 2;
        int n2 = string.indexOf("__", n);
        return XMLUtils.getResource(string.substring(0, n2));
    }

    public static String getTitleForSchemaURI(String string) {
        LimeXMLSchema limeXMLSchema = GuiCoreMediator.getLimeXMLSchemaRepository().getSchema(string);
        if (limeXMLSchema != null) {
            return XMLUtils.getTitleForSchema(limeXMLSchema);
        }
        return null;
    }

    public static String getTitleForSchema(LimeXMLSchema limeXMLSchema) {
        return XMLUtils.getResource(limeXMLSchema.getRootXMLName() + "__" + limeXMLSchema.getInnerXMLName());
    }

    private static ResourceBundle getBundleForField(String string) {
        if (bundles == null) {
            XMLUtils.loadBundles();
        }
        return bundles.get(XMLUtils.getDescriptionFromField(string));
    }

    private static String getDescriptionFromField(String string) {
        int n = string.indexOf("__") + 2;
        int n2 = string.indexOf("__", n);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    private static void loadBundles() {
        bundles = new HashMap<String, ResourceBundle>();
        Collection<LimeXMLSchema> collection = GuiCoreMediator.getLimeXMLSchemaRepository().getAvailableSchemas();
        for (LimeXMLSchema limeXMLSchema : collection) {
            String string = limeXMLSchema.getDescription();
            try {
                bundles.put(string, GUIMediator.getXMLResourceBundle(string));
            }
            catch (MissingResourceException missingResourceException) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Missing resource bundle for schema: " + string, missingResourceException);
            }
        }
    }

    private static String fallbackResource(String string, ResourceBundle resourceBundle) {
        block3: {
            if (resourceBundle != null) {
                try {
                    return resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Missing fallback resource for: " + string + ", capitalizing field name.", missingResourceException);
                }
            }
        }
        return XMLUtils.processField(string);
    }

    private static String formatFieldName(String string) {
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1).replace('_', ' ').trim();
    }

    private static String processField(String string) {
        int n = string.endsWith("__") ? string.length() - 2 : string.length();
        int n2 = string.lastIndexOf("__", n - 1) + 2;
        return XMLUtils.formatFieldName(string.substring(n2, n));
    }
}

