/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import org.limewire.collection.NameValue;

public abstract class IndentingPanel
extends JPanel
implements Scrollable {
    private static final String KEY_PROP = "lime.canonKey";
    private static final String DEFAULT_PROP = "lime.defaultField";
    private static final int DEFAULT_FIELDS = 5;
    private KeyProcessingTextField keyProcessingTextField;

    public IndentingPanel(LimeXMLSchema limeXMLSchema, ActionListener actionListener, Document document, UndoManager undoManager, boolean bl, boolean bl2, boolean bl3) {
        this.setOpaque(false);
        int n = bl ? limeXMLSchema.getCanonicalizedFields().size() : 5;
        List<SchemaFieldInfo> list = limeXMLSchema.getCanonicalizedFields();
        boolean bl4 = true;
        int n2 = 0;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        for (int i = 0; i < list.size(); ++i) {
            JComponent jComponent;
            SchemaFieldInfo schemaFieldInfo = list.get(i);
            if (schemaFieldInfo.isInvisible() || !bl3 && !schemaFieldInfo.isEditable()) continue;
            if (n2 == n) {
                this.addMoreOptions(gridBagConstraints);
                bl4 = false;
            }
            if ((jComponent = this.addField(limeXMLSchema, schemaFieldInfo, gridBagConstraints, bl4, bl3)) instanceof KeyProcessingTextField) {
                KeyProcessingTextField keyProcessingTextField = (KeyProcessingTextField)jComponent;
                if (this.keyProcessingTextField == null) {
                    this.keyProcessingTextField = keyProcessingTextField;
                    if (document != null) {
                        keyProcessingTextField.setDocument(document);
                    }
                    if (undoManager != null) {
                        keyProcessingTextField.setUndoManager(undoManager);
                    }
                }
                keyProcessingTextField.addActionListener(actionListener);
            }
            ++n2;
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        this.add(Box.createGlue(), gridBagConstraints);
        this.setFieldsVisible(false);
    }

    public void addMoreOptionsListener(ActionListener actionListener) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JCheckBox)) continue;
            ((JCheckBox)component).addActionListener(actionListener);
        }
    }

    private void addMoreOptions(GridBagConstraints gridBagConstraints) {
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("More Search Options"));
        jCheckBox.setOpaque(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                IndentingPanel.this.setFieldsVisible(jCheckBox.isSelected());
                IndentingPanel.this.invalidate();
                IndentingPanel.this.revalidate();
            }
        });
        gridBagConstraints.insets = new Insets(2, 0, 5, 0);
        gridBagConstraints.fill = 0;
        this.add((Component)jCheckBox, gridBagConstraints);
    }

    private JComponent getTextField(boolean bl) {
        return bl ? new SearchField(14) : new ClearableAutoCompleteTextField(30);
    }

    private JComboBox getOptions(SchemaFieldInfo schemaFieldInfo) {
        List<NameValue<String>> list = schemaFieldInfo.getEnumerationList();
        int n = list.size();
        Object[] objectArray = new ComboBoxValue[n + 1];
        objectArray[0] = new ComboBoxValue("", "");
        for (int i = 0; i < n; ++i) {
            objectArray[i + 1] = new ComboBoxValue(list.get(i));
        }
        Arrays.sort(objectArray);
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setOpaque(false);
        return jComboBox;
    }

    private JComponent addField(LimeXMLSchema limeXMLSchema, SchemaFieldInfo schemaFieldInfo, GridBagConstraints gridBagConstraints, boolean bl, boolean bl2) {
        String string = schemaFieldInfo.getCanonicalizedFieldName();
        String string2 = XMLUtils.getResource(string);
        JLabel jLabel = new JLabel(string2);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.fill = 2;
        this.add((Component)jLabel, gridBagConstraints);
        JComponent jComponent = null;
        switch (schemaFieldInfo.getFieldType()) {
            case 1: {
                jComponent = this.getTextField(bl2);
                break;
            }
            case 2: {
                jComponent = this.getOptions(schemaFieldInfo);
                break;
            }
            default: {
                throw new IllegalStateException("bad type: " + schemaFieldInfo.getFieldType() + ", name: " + string);
            }
        }
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)jComponent, gridBagConstraints);
        jComponent.putClientProperty(KEY_PROP, string);
        if (!bl) {
            jLabel.putClientProperty(DEFAULT_PROP, Boolean.FALSE);
            jComponent.putClientProperty(DEFAULT_PROP, Boolean.FALSE);
        }
        return jComponent;
    }

    private void setFieldsVisible(boolean bl) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object object;
            Component component = this.getComponent(i);
            if (!(component instanceof JComponent) || (object = ((JComponent)component).getClientProperty(DEFAULT_PROP)) != Boolean.FALSE) continue;
            component.setVisible(bl);
        }
    }

    public void requestFirstFocus() {
        if (this.keyProcessingTextField != null) {
            this.keyProcessingTextField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public KeyProcessingTextField getFirstTextField() {
        return this.keyProcessingTextField;
    }

    protected JComponent getField(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Object object;
            Component component = this.getComponent(i);
            if (!(component instanceof JComponent) || (object = ((JComponent)component).getClientProperty(KEY_PROP)) == null || !object.equals(string)) continue;
            return (JComponent)component;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.clearField(this.getComponent(i));
        }
    }

    protected void clearField(Component component) {
        if (component instanceof JTextField) {
            ((JTextField)component).setText(null);
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setSelectedIndex(0);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 0: {
                return rectangle.width / 10;
            }
            case 1: {
                return rectangle.height / 10;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 0: {
                return rectangle.width;
            }
            case 1: {
                return rectangle.height;
            }
        }
        throw new IllegalArgumentException("Unknown orientation " + n);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

