/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.AquaSortArrowIcon;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.limewire.util.OSUtils;

public final class SortHeaderRenderer
extends DefaultTableCellRenderer
implements ThemeObserver {
    public static Icon ASCENDING;
    public static Icon DESCENDING;
    private boolean allowIcon = true;

    private static void updateIcons() {
        if (OSUtils.isMacOSX() || ThemeSettings.isWindowsTheme()) {
            ASCENDING = AquaSortArrowIcon.getAscendingIcon();
            DESCENDING = AquaSortArrowIcon.getDescendingIcon();
        } else {
            ASCENDING = SortArrowIcon.getAscendingIcon();
            DESCENDING = SortArrowIcon.getDescendingIcon();
        }
    }

    public SortHeaderRenderer() {
        this.setHorizontalAlignment(0);
        this.setIconTextGap(2);
        this.setHorizontalTextPosition(2);
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        SortHeaderRenderer.updateIcons();
    }

    public void setAllowIcon(boolean bl) {
        this.allowIcon = bl;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n3 = -1;
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.allowIcon && jTable instanceof JSortTable) {
            object5 = (JSortTable)((Object)jTable);
            n3 = object5.getSortedColumnIndex();
            bl3 = object5.isSortedColumnAscending();
            bl4 = object5.getPressedColumnIndex() == n2;
        }
        object5 = this;
        if (jTable != null) {
            object4 = jTable.getTableHeader();
            try {
                if (object4 != null && (object3 = (object2 = ((JTableHeader)object4).getDefaultRenderer()).getTableCellRendererComponent(jTable, object, bl, bl2, n, n2)) instanceof JLabel) {
                    object5 = (JLabel)object3;
                    ((JComponent)object5).setFont(((Component)object4).getFont());
                    ((JComponent)object5).setBackground(((Component)object4).getBackground());
                    ((JComponent)object5).setForeground(((Component)object4).getForeground());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (object instanceof Icon) {
            ((JLabel)object5).setIcon((Icon)object);
            ((JLabel)object5).setText(null);
        } else {
            object4 = n2 == n3 ? (bl3 ? ASCENDING : DESCENDING) : null;
            ((JLabel)object5).setIcon((Icon)object4);
            ((JLabel)object5).setText(object == null ? null : object.toString());
        }
        if (object5 != this) {
            ((JLabel)object5).setHorizontalAlignment(0);
            ((JLabel)object5).setIconTextGap(2);
            ((JLabel)object5).setHorizontalTextPosition(2);
        }
        object4 = UIManager.getBorder("TableHeader.cellPressedBorder");
        object2 = UIManager.getBorder("TableHeader.cellBorder");
        object3 = ((JComponent)object5).getBorder();
        if (object3 == object4 || object3 == object2 || object3 == null) {
            if (bl4) {
                ((JComponent)object5).setBorder((Border)(object4 == null ? object2 : object4));
            } else {
                ((JComponent)object5).setBorder((Border)object2);
            }
        }
        return object5;
    }

    static {
        SortHeaderRenderer.updateIcons();
    }
}

