/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class KeyTypedMover
implements KeyListener {
    private String prefix = "";
    private String typedString = "";
    private long lastTime = 0L;
    private final long timeFactor = 500L;

    public void keyTyped(KeyEvent keyEvent) {
        int n;
        LimeJTable limeJTable = (LimeJTable)keyEvent.getSource();
        TableModel tableModel = limeJTable.getModel();
        if (tableModel.getRowCount() == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || this.isNavigationKey(keyEvent)) {
            return;
        }
        boolean bl = true;
        char c = keyEvent.getKeyChar();
        long l = keyEvent.getWhen();
        int n2 = limeJTable.getSelectionModel().getLeadSelectionIndex();
        if (l - this.lastTime < 500L) {
            this.typedString = this.typedString + c;
            if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                ++n2;
            } else {
                this.prefix = this.typedString;
            }
        } else {
            ++n2;
            this.prefix = this.typedString = "" + c;
        }
        this.lastTime = l;
        if (n2 < 0 || n2 >= tableModel.getRowCount()) {
            bl = false;
            n2 = 0;
        }
        if ((n = limeJTable.getNextMatch(this.prefix, n2, Position.Bias.Forward)) >= 0) {
            limeJTable.setSelectedRow(n);
            limeJTable.ensureRowVisible(n);
        } else if (bl && (n = limeJTable.getNextMatch(this.prefix, 0, Position.Bias.Forward)) >= 0) {
            limeJTable.setSelectedRow(n);
            limeJTable.ensureRowVisible(n);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isNavigationKey(keyEvent)) {
            this.prefix = "";
            this.typedString = "";
            this.lastTime = 0L;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean isNavigationKey(KeyEvent keyEvent) {
        InputMap inputMap = ((JComponent)keyEvent.getSource()).getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        return inputMap != null && inputMap.get(keyStroke) != null;
    }
}

